package circusRefine.core.context;

import circusRefine.core.print.Printer;
import circusRefine.util.CodigoParametro;
import circusRefine.util.Pair;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.base.visitor.VisitorUtils;
import net.sourceforge.czt.circus.ast.ActionPara;
import net.sourceforge.czt.circus.ast.ChannelSetPara;
import net.sourceforge.czt.circus.ast.NameSetPara;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.circus.visitor.ActionParaVisitor;
import net.sourceforge.czt.circus.visitor.ChannelSetParaVisitor;
import net.sourceforge.czt.circus.visitor.NameSetParaVisitor;
import net.sourceforge.czt.circus.visitor.ProcessParaVisitor;
import net.sourceforge.czt.z.ast.ConstDecl;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.visitor.ConstDeclVisitor;
import net.sourceforge.czt.z.visitor.VarDeclVisitor;

/**
 * Esse visitor é utilizado para capturar a definição das diversas variáveis
 * da especificação e guardá-las. A estrutura conterá o nome da variável que pode
 * ser ação, processo, schema e string parseável de sua definição.
 * @author Alessandro
 *
 */
public class ContextVisitor implements TermVisitor<Void>,
										ActionParaVisitor<Void>,
										ChannelSetParaVisitor<Void>,
										NameSetParaVisitor<Void>,
										ProcessParaVisitor<Void>,
										ConstDeclVisitor<Void>,
										VarDeclVisitor<Void>{

	/* Nome do termo, <Corpo do termo em String, Cod. do que se trata o termo>*/
	private java.util.Hashtable<Name, Pair<String, CodigoParametro>> contextos;
	
	private ContextVisitor() {
		contextos = new java.util.Hashtable<Name, Pair<String,CodigoParametro>>();
	}
	
	public static java.util.Hashtable<Name, Pair<String, CodigoParametro>> getContexto(Term termo) {
		ContextVisitor visitor = new ContextVisitor();
		termo.accept(visitor);
		
		return visitor.getContextos();
		
	}
	
	public static void testeContexto(Term termo){
		java.util.Hashtable<Name, Pair<String, CodigoParametro>> contexto = ContextVisitor.getContexto(termo);
		for (Name name : contexto.keySet()){
			System.out.println(contexto.get(name).getFirst());
		}
		
	}
	
	private java.util.Hashtable<Name, Pair<String, CodigoParametro>> getContextos() {
		return contextos;
	}

	public Void visitTerm(Term arg0) {
		 VisitorUtils.visitTerm(this, arg0);
		 return null;
	}

	public Void visitActionPara(ActionPara arg0) {
		
		String str = Printer.printLATTEX(arg0.getCircusAction());
		contextos.put(arg0.getName(), new Pair<String, CodigoParametro>(str,CodigoParametro.ACTION));
		return null;
	}

	
	public Void visitChannelSetPara(ChannelSetPara arg0) {
		String str = Printer.printLATTEX(arg0.getChannelSet());
		contextos.put(arg0.getName(), new Pair<String, CodigoParametro>(str,CodigoParametro.CHANSET));
		return null;
	}

	public Void visitNameSetPara(NameSetPara arg0) {
		String str = Printer.printLATTEX(arg0.getNameSet());
		contextos.put(arg0.getName(), new Pair<String, CodigoParametro>(str,CodigoParametro.NAMESET));
		return null;
	}

	public Void visitProcessPara(ProcessPara arg0) {
		String str = Printer.printLATTEX(arg0.getCircusProcess());
		contextos.put(arg0.getName(), new Pair<String, CodigoParametro>(str,CodigoParametro.ACTION));
		 VisitorUtils.visitTerm(this, arg0);
		return null;
	}

	@Override
	public Void visitConstDecl(ConstDecl arg0) {
		String str = Printer.printLATTEX(arg0.getExpr());
		contextos.put(arg0.getName(), new Pair<String, CodigoParametro>(str,CodigoParametro.EXPRESSION));
		return null;
	}

	@Override
	public Void visitVarDecl(VarDecl arg0) {
		String str = Printer.printLATTEX(arg0.getExpr());
		for (Name name : arg0.getName()){
			contextos.put(name, new Pair<String, CodigoParametro>(str,CodigoParametro.EXPRESSION));
		}
		return null;
	}

}
