/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.astmodifiers;

import net.sourceforge.czt.base.ast.Term;

/**
 * Interface implementada por todas as classes responsveis por 
 * modificar a AST
 * 
 * @author Cristiano Castro
 *
 * @param <E> o tipo do Term filho encapsulado
 */
public interface IASTModifierAnn extends Cloneable {
	
	/**
	 * Mtodo para modificar o termo encapsulado
	 * 
	 * @param newTerm o novo termo encapsulado
	 */
	public void setTerm(Term newTerm);
	
	/**
	 * Mtodo que acessa o termo encapsulado pela classe
	 * 
	 * @return o termo encapsulado
	 */
	public Term getTerm();
	
	/** Produz uma cpia da anotao do termo */
	public IASTModifierAnn clone() throws CloneNotSupportedException;
	
	/** 
	 * Cria uma cpia da anotao com <code>null</code> como termo
	 * encapsulado
	 * 
	 * @return uma cpia da anotao encapsulando <code>null</code>
	 */
	public IASTModifierAnn create();
	
}
