/*
 * Projeto: Circus Refine 
 */
package circusRefine.core;

/**
 * Resposta do programa  ao de remoo de um comentrio
 * 
 * @author Cristiano Castro
 */
public class RemoveCommentAnswer implements StepAnswer {

	/** Linha */
	private int linhaInicial;
	
	private int linhaFinal;
	
	private int identificador;

	/**
	 * Insere um novo passo de remoo de comentrio
	 *  
	 * @param lInicial a linha inicial onde o comentrio foi 
	 *  removido
	 * @param lFinal a linha final onde o comentrio foi 
	 *  removido
	 */
	public RemoveCommentAnswer(int lInicial, int lFinal, int id) {
		this.setLinhaInicial(lInicial);
		this.setLinhaFinal(lFinal);
		this.setIdentificador(id);
	}
	
	/**
	 * @return the linhaInicial
	 */
	public int getLinhaInicial() {
		return linhaInicial;
	}

	/**
	 * @param linhaInicial the linhaInicial to set
	 */
	private void setLinhaInicial(int linhaInicial) {
		this.linhaInicial = linhaInicial;
	}

	/**
	 * @return the linhaFinal
	 */
	public int getLinhaFinal() {
		return linhaFinal;
	}

	/**
	 * @param linhaFinal the linhaFinal to set
	 */
	private void setLinhaFinal(int linhaFinal) {
		this.linhaFinal = linhaFinal;
	}
	
	public int getIdentificador() {
		return identificador;
	}

	public void setIdentificador(int identificador) {
		this.identificador = identificador;
	}
	
	
}
