/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core;

import net.sourceforge.czt.z.ast.Para;

/**
 * Insere Classe utilizada para inserir um pargrafo na especificao
 * 
 * @author Cristiano Castro
 */
public class InsertAnswer {
	
	/** Pargrafo inserido na especificao */
	private Para insertedPara;
	private InsertParagraphStatus status;

	public InsertAnswer(Para insertedPara, InsertParagraphStatus status) {
		super();
		this.insertedPara = insertedPara;
		this.status = status;
	}

	public InsertAnswer( Para para ) {
		this.setInsertedPara( para );
	}
	
	/**
	 * @return the insertedPara
	 */
	public Para getInsertedPara() {
		return insertedPara;
	}

	/**
	 * @param insertedPara the insertedPara to set
	 */
	private void setInsertedPara(Para insertedPara) {
		this.insertedPara = insertedPara;
	}

	public InsertParagraphStatus getStatus() {
		return status;
	}

	public void setStatus(InsertParagraphStatus status) {
		this.status = status;
	}
	
}


