
/*
 * Projeto : Circus Refine
 *
 * Tipo : GerenciadorExterno
 */
package circusRefine.core;

import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.util.UnmarshalException;
import net.sourceforge.czt.circus.ast.ActionPara;
import net.sourceforge.czt.circus.ast.ActionTransformerPred;
import net.sourceforge.czt.circus.ast.BasicProcess;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.ParallelAction;
import net.sourceforge.czt.circus.ast.ParallelProcess;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.circus.ast.ProcessTransformerPred;
import net.sourceforge.czt.circus.ast.Transformation;
import net.sourceforge.czt.circus.ast.TransformerPred;
import net.sourceforge.czt.circus.impl.ParallelProcessImpl;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.circuspatt.ast.CircusPatternFactory;
import net.sourceforge.czt.circuspatt.impl.CircusPatternFactoryImpl;
import net.sourceforge.czt.circuspatt.util.CircusLaw;
import net.sourceforge.czt.parser.util.ParseException;
import net.sourceforge.czt.session.CommandException;
import net.sourceforge.czt.session.FileSource;
import net.sourceforge.czt.session.Markup;
import net.sourceforge.czt.session.Source;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.impl.ZNameImpl;
import net.sourceforge.czt.zpatt.ast.Sequent;
import net.sourceforge.czt.zpatt.ast.SequentList;
import circusRefine.core.annotations.StatementSchExprAnn;
import circusRefine.core.annotations.TemporaryTermAnn;
import circusRefine.core.crules.CRulesException;
import circusRefine.core.crules.CancelledApplException;
import circusRefine.core.crules.LawDefinitionAnn;
import circusRefine.core.crules.factories.LawNumberAnn;
import circusRefine.core.crules.messages.CRulesMissingMessageException;
import circusRefine.core.crules.parseArgument.ParseArgumentException;
import circusRefine.core.crules.parseArgument.ParseArgumentUtils;
import circusRefine.core.crules.utils.HierarchyLawsTree;
import circusRefine.core.crules.utils.NodeHierarchyLaws;
import circusRefine.core.developments.DevelopmentTree;
import circusRefine.core.developments.DevelopmentsManager;
import circusRefine.core.developments.PODevelopmentTree;
import circusRefine.core.idt.IdtUtils;
import circusRefine.core.print.Printer;
import circusRefine.core.relations.DesfazerRelationsVisitor;
import circusRefine.core.relations.RefazerRelationsVisitor;
import circusRefine.core.relations.RelationRowLaw;
import circusRefine.core.relations.RelationsAnn;
import circusRefine.core.relations.RelationsUtils;
import circusRefine.core.relations.UpdateRelationsVisitor;
import circusRefine.core.specificationeditor.SpecificationEditorException;
import circusRefine.core.storage.AdicaoComentario;
import circusRefine.core.storage.CarregamentoEspecificacao;
import circusRefine.core.storage.CarregamentoSubDesenvolvimento;
import circusRefine.core.storage.Coleta;
import circusRefine.core.storage.InsertParagraph;
import circusRefine.core.storage.LawApplication;
import circusRefine.core.storage.RemocaoComentario;
import circusRefine.core.storage.SetandoStatusOp;
import circusRefine.core.storage.StepOfExecution;
import circusRefine.core.storage.ToSave;
import circusRefine.core.util.CodParamVisitor;
import circusRefine.core.util.EqualsTermsUtils;
import circusRefine.core.util.POLog;
import circusRefine.core.util.TermoColetado;
import circusRefine.core.util.Text;
import circusRefine.gui.CaixaLeis;
import circusRefine.gui.ChangeFormatException;
import circusRefine.gui.Comentario;
import circusRefine.gui.ErrorDialog;
import circusRefine.gui.InfoLei;
import circusRefine.gui.InfoTelas;
import circusRefine.gui.TecladoArcAngelC;
import circusRefine.gui.TelaCodigo;
import circusRefine.gui.TelaDesenvolvimento;
import circusRefine.gui.TelaAnimacao;
import circusRefine.gui.TelaObrigacao;
import circusRefine.gui.TelaParametro;
import circusRefine.gui.TelaPrincipal;
import circusRefine.gui.TelaTatica;
import circusRefine.util.CRefineException;
import circusRefine.util.CancelledInsertionOfParaExceptionn;
import circusRefine.util.CodNameParam;
import circusRefine.util.CodigoParametro;
import circusRefine.util.ComentariosUtils;
import circusRefine.util.CommentsType;
import circusRefine.util.Identificador;
import circusRefine.util.Internacional;
import circusRefine.util.NatToRoman;
import circusRefine.util.OPTipos;
import circusRefine.util.Pair;
import circusRefine.util.circusstring.CircusToLatex;
import circusRefine.util.circusstring.LatexToCircusTactics;
import circusRefine.util.docgenerator.DocGenerator;
import circusRefine.util.zstring.ZtoLatex;
import circusRefine.Tactic.Excecao.LawNotFound;
import circusRefine.Tactic.Excecao.TacticNotFound;
import circusRefine.Tactic.Excecao.Unification;
import circusRefine.Tactic.Factories.TacticsCreator;
import circusRefine.Tactic.Principal.*;
import circusRefine.Tactic.Util.GerenciadorTaticas;
import circusRefine.Tactic.Util.RCell;
import circusRefine.Tactic.Util.TacticAnswer;
import circusRefine.Tactic.Util.ArcAngelCToCircus.ArcAngelCToCircus;

/**
 * GerenciadorExterno eum tipo respons�vel pelo gerenciamento das
 * telas do sistema.
 * 
 * @author Alessandro Gurgel
 * @author Cristiano Gurgel
 * @author Manuela Xavier
 */
public class ExternalManager {

	/**
	 * Testa se um termo e temporario para a aplicação de uma lei
	 *
	 * @param termo o termo a ser testado
	 * @return <code>true</code> caso o termo seja tempor�rio,
	 *  <code>false</code> caso contr�rio
	 */
	public static <T extends Term> boolean isTemporaryTerm(T termo) {
		return termo.getAnn(TemporaryTermAnn.class) != null;
	}

	/**
	 * Pega o termo real ap�s a aplicação de uma lei
	 *
	 * @param termo
	 * @return
	 */
	public static Term getRealTerm(Term termo) {

		/*
		 * Caso o termo seja tempor�rio, ele retorna o termo real que
		 * foi encapsulado
		 */
		if (ExternalManager.isTemporaryTerm(termo)) {
			termo = termo.getAnn(TemporaryTermAnn.class).getRealTerm();
		} else if (ExternalManager.hasSpectStmtCommand(termo)) {
			termo = termo.getAnn(StatementSchExprAnn.class).getTermo();
		}

		return termo;
	}

	private static boolean hasSpectStmtCommand(Term termo) {
		return termo.getAnn(StatementSchExprAnn.class) != null;
	}
	/**
	 * a lista com os relacionamentos linha inicial, final e
	 * noPrograma correspondente
	 */
	private List<Relacionamento> relacionamentosTela;

	/* Gerenciador interno do sistema */
	private InternalManager gerInterno;
	private TelaPrincipal telaPrincipal;
	private TelaDesenvolvimento telaDesenvolvimento;
	private TelaAnimacao telaAnimacao;
	private TelaObrigacao telaObrigacao;
	private TelaTatica telaTatica;
	private TelaCodigo telaCodigoAtual;
	private CaixaLeis caixaLeis;
	private InfoTelas infoTelas;

	private String filePath = "";//By Samuel Barrocas

	public TelaCodigo getTelaCodigoAtual () {
		return this.telaCodigoAtual;
	}
	public void setFilePath (String p) {
		this.telaCodigoAtual.setFilePath (p);
	}
	public String getFilePath () {
		return this.filePath;
	}

	TecladoArcAngelC tecArcAngelC;
	public String[] textoDesTac;
	Tatica taticaFinal = new Tatica();
	boolean aplicTatica;
	public boolean isAplicTatica() {
		return aplicTatica;
	}

	public void setAplicTatica(boolean aplicTatica) {
		this.aplicTatica = aplicTatica;
	}

	public Tatica getTaticaFinal() {
		return taticaFinal;
	}

	public void setTaticaFinal(Tatica taticaFinal) {
		this.taticaFinal = taticaFinal;
	}

	public RCell getrCellFinal() {
		return rCellFinal;
	}

	public void setrCellFinal(RCell rCellFinal) {
		this.rCellFinal = rCellFinal;
	}
	RCell rCellFinal = new RCell();
	
	/**
	 * Para diferencar uma tática d euma lei
	 */
	private int aplicacao = -1;
	private Internacional internacional;

	/* variaveis para redimensionar as janelas */
	private int tamHorizontal;
	private int tamVertical;
	/*
	 * Campo que indica se o programa esta atualmente mudando ou nao,
	 * de formato -> Unicode to Latex or Latex to Unicode
	 */
	private boolean mundandoFormato = false;
	/** Gerenciador de Multiplos Desenvolvimento*/
	private DevelopmentsManager gerDevelopments;
	private boolean loading; /* auxiliar true no momento de salva*/

	private boolean continuing; /* auxiliar true na continuacao de um subdesenvolvimento*/

	private boolean changingFormat;

	/**
	 * Construtor da classe GerenciadorExterno.
	 *
	 * @param linguagem      Linguagem escolhida pelo usuario para a utilizacao
	 *                       da ferramenta (portugues ou ingles).
	 * @param pais           Pais escolhido pelo usuario.
	 */
	public ExternalManager(String linguagem, String pais) {

		System.out.println("Antes inter");
		internacional = new Internacional(linguagem, pais);
		gerDevelopments = new DevelopmentsManager(this);
		System.out.println("Antes interno");
		gerInterno = new InternalManager(this, gerDevelopments);


		telaDesenvolvimento = new TelaDesenvolvimento(this);
		telaObrigacao = new TelaObrigacao(this);
		telaCodigoAtual = new TelaCodigo(this);
		telaTatica = new TelaTatica(this);
		caixaLeis = new CaixaLeis(this);
		telaPrincipal = new TelaPrincipal(this, telaDesenvolvimento, telaCodigoAtual, telaObrigacao, caixaLeis);

		//		Guarda informacoes referentes a tamanho e posicao das diversas janelas
		infoTelas = new InfoTelas();

		this.loading = false;
		this.changingFormat = false;
		this.continuing = false;
		this.relacionamentosTela = new ArrayList<Relacionamento>();
		System.out.println("Antes tactic creator");
		TacticsCreator tac = new TacticsCreator(gerInterno);
		System.out.println("depois tactic creator");

	}

	/**
	 * Metodo que retorna uma referencia para o campo que guarda as informa��es das janelas
	 * @return infoTelas
	 */
	public InfoTelas getInfoTelas() {
		return infoTelas;
	}

	/**
	 * Metodo que retorna as leis armazenadas na Caixa de Leis
	 * @return
	 */
	public java.util.List<CircusLaw> getLaws() {
		return gerInterno.getLaws();
	}

	/**
	 * @return the gerInterno
	 */
	public InternalManager getGerInterno() {
		return gerInterno;
	}

	/**
	 * @param gerInterno the gerInterno to set
	 */
	private void setGerInterno(InternalManager gerInterno) {
		this.gerInterno = gerInterno;
	}

	/**
	 *	Metodo que realiza a atualização das anota��es referentes a relacionamento
	 *	linha/termo com um termo espec�fico
	 *	@param	prog	termo a qual as anota��es din�micas serao atualizadas
	 *	@param	Tam		Tamanho do texto que sera incrementado a condição.
	 */
	public void atualizarRelationsAnn(Term prog, int Tam) {
		UpdateRelationsVisitor updateVisitor = new UpdateRelationsVisitor(Tam);
		updateVisitor.visitTerm(prog);
	}

	/**
	 * M�todo que aplica uma lei sobre um programa e mostra o resultado da apli-
	 * cação da lei nas telas de desenvolvimento, de obrigação de provas e de
	 * c�digo gerado.
	 *
	 * @param programa           Programa que sofrera aplica�ao de lei.
	 * @param codLeiSelecionada  C�digo da lei selecionada para a aplicação da lei.
	 * @param parametro          Parametro necess�rio para a aplicação da lei.
	 * @throws CommandException
	 * @throws UnmarshalException
	 * @throws IOException
	 * @throws ParseException
	 *
	 */
	public void applyLaw(NoPrograma programa, CircusLaw leiSelecionada)
	throws CRulesException, CancelledApplException {

		/**
		 * Para diferenciar no momento que for desfazer
		 */
		//aplicacao = 0;
		getDevelopment().atualizarPilhaAplicacao(0);
		this.setAplicTatica(false);

		LawAnswer resposta = null;
		int[] linhas =
			this.retornarLinhasSelecionadas();

		resposta = this.gerInterno.aplicarLei(programa.getPrograma(),
				leiSelecionada, this.gerDevelopments.getDevelopment(this.telaDesenvolvimento.getSelectedDevelopment()).getProgAtual());
		this.atualizarAposAplicacao(programa, leiSelecionada,
				resposta, linhas[0]);

		this.tirarSelecao();
		this.esvaziarRedoPilhas();
		this.retornarTelaPrincipal().habilitarUndo();

		checkFinishedSubDevelopment(resposta.getNovaAST());

	}

	/**
	 * Verifica se o Subdesenvolvimento foi terminado
	 *
	 */
	public void checkFinishedSubDevelopment(Term newAst) {
		boolean a1 = this.checkTarget(newAst);
		/* Verifica se todas as OPS foram provadas ou determinadas verdadeiras*/
		boolean a2 = this.checkPOs();

		if (a1 && a2) {
			this.subDesenvolvimentoProvado();
		} /** Alcan�ou o termo desejado mas ainda faltam POs a serem provadas */
		else if (a1 && !a2) {
			if (!this.isLoading() && !this.isChangingFormat()) {
				JOptionPane.showMessageDialog(null, this.getMessage("ReachedSubDevelopment"), this.getMessage("ReachedSubDevelopmentTitle"), JOptionPane.INFORMATION_MESSAGE);
			}
		}
	}

	/**
	 *
	 * @return true if there is an running change format operation
	 */
	private boolean isChangingFormat() {
		return changingFormat;
	}

	/**
	 * Verifica se o refinamento atingiu como
	 * termo resultante o target (o Desenvolvimenot alvo). Caso
	 * isto se comprove, a obrigação de prova que o gerou
	 * ao considerada provada verdadeira
	 * @param novaAST
	 */
	private boolean checkTarget(Term novaAST) {
		if (this.isPODevelopment() && !this.isContinuing()) {
			PODevelopmentTree subdev = (PODevelopmentTree) gerDevelopments.getDevelopment(this.getSelectedDevelopment());
			Term goal = subdev.getTarget();

			Printer.printLATTEX(goal);
			Printer.printLATTEX(novaAST);

			if (EqualsTermsUtils.equals(goal, novaAST)) {
				subdev.proved();
				return true;
			} else {
				subdev.notProved();
			}
		}
		return false;
	}

	/**
	 * M�todo para atualização das telas e outros status do CRefine ap�s
	 * a aplicação da lei ao programa
	 *
	 * @param programa
	 * @param leiAplicada
	 * @param resposta
	 */
	private void atualizarAposAplicacao(NoPrograma programa,
			CircusLaw leiSelecionada, LawAnswer resposta, int linhaInicial) {

		int id = this.getSelectedDevelopment();
		gerDevelopments.getDevelopment(id).getRespostasLeis().push(resposta);

		/*
		 * For�ando a respostaLei pega o termo real
		 */
		Term termoResultante = ExternalManager.getRealTerm(resposta.getProgResultante());

		/* O primeiro parametro sera alterado logo depois da impressao de
		 * tela Texto, pois a ultima posicao de texto antigo, guardara exa
		 * tamente a linha em que aparecera a lei aplicada */
		RelationRowLaw leiLinha = new RelationRowLaw(leiSelecionada);

		gerDevelopments.getDevelopment(id).retornarPilhaDeLeis().push(leiLinha);
		//Permite insercao de Relacionamentos
		this.retornarTelaDesenvolvimento().buildProgText(termoResultante, "aplicar", linhaInicial, true);

		int linhaLei = gerDevelopments.getDevelopment(id).retornarPilhaDeLeis().peek().getLinha();
		
		/* Trata as obrigacoes de prova */
		if (resposta.getOps().size() != 0) {

			/* Chamando o provador de Teoremas*/
		 linhaLei = gerDevelopments.getDevelopment(id).retornarPilhaDeLeis().peek().getLinha();
			 LawAnswer resp2 = resposta;
			LinkedList<ObrigacaoProva> obrigations = this.montarListaOPs(resposta,linhaLei);
			this.retornarTelaObrigacao().listarObrigacoes(obrigations);
			IdtUtils.InsertIdt(this.telaObrigacao.getIdentificador() - 1,
					programa.getPrograma(), Identificador.OBRIGACAO);
		}

		Term termoaplicado = programa.getPrograma();
		this.getTermosAplicados().push(termoaplicado);

		this.inserirIdt(termoaplicado, this.retornarTelaDesenvolvimento().getIdt() - 1, Identificador.LEI);


		/* Adiciona o passo de aplicação de lei ao hist�rico de
		 * desenvolvimento */
		resposta.setLinhaInicial(programa.getLinhaInicial());
		resposta.setLinhaFinal(programa.getLinhaFinal());
		resposta.setLeiAplicada(leiSelecionada);
		gerInterno.respostaLei = resposta;

		adicionarAplicacaoLeiAoHistorico(resposta);
	}

	/**
	 * Realiza uma simples montagem da List De Ops de acordo com as
	 * sequents retornadas pelo GerInterno;
	 * @param resposta
	 * @return uma lista de Obrigacoes de Prova com informacoes utilizadas pela GUI
	 */
	private LinkedList<ObrigacaoProva> montarListaOPs(LawAnswer resposta, int linhaLei) {
		LinkedList<ObrigacaoProva> result = new LinkedList<ObrigacaoProva>();

		for (int i = 0; i < resposta.getOps().size(); i++) {

			Pred normal = resposta.getOps().get(i).getFirst().getFirst().getPred();
			Pred extendido = resposta.getOps().get(i).getFirst().getSecond().getPred();
			OPTipos tipo = resposta.getOps().get(i).getSecond().getFirst();
			POLog log = resposta.getOps().get(i).getSecond().getSecond();

			boolean extendivel = (log.getLog().contains(getMessage("COD0717"))
					|| log.getLog().contains(getMessage("COD0718")));
			boolean toModelChecker = log.getLog().contains(getMessage("COD0748"));

			if (tipo.equals(OPTipos.OP_CHECADA_TRUE) || tipo.equals(OPTipos.OP_CHECADA_FALSE)) {
				result.add(new ObrigacaoProva(normal, extendido, tipo, log, linhaLei, extendivel, toModelChecker));
			} else {
				/* Nao foi provado e o usu�rio poder� tentar
				 * provar essa OP atrav�s de um novo desenvolvimento
				 * que deve ter o mesmo contexto */
				if (normal instanceof TransformerPred) {
					Term contexto = gerInterno.retornarContexto();
					Term contextoApos = resposta.getNovaAST();
					result.add(new ObrigacaoProva(normal, extendido, tipo, log, linhaLei, extendivel, contexto, contextoApos, toModelChecker));

				} else {
					result.add(new ObrigacaoProva(normal, extendido, tipo, log, linhaLei, extendivel, toModelChecker));
				}
			}


		}
		return result;
	}
	
	/**
	 * Realiza uma simples montagem da List De Ops de acordo com as
	 * sequents retornadas pelo GerInterno;
	 * @param resposta
	 * @return uma lista de Obrigacoes de Prova com informacoes utilizadas pela GUI
	 */
	private LinkedList<ObrigacaoProva> montarListaOPs(RCell resposta, int linhaLei) {
		LinkedList<ObrigacaoProva> result = new LinkedList<ObrigacaoProva>();

		for (int i = 0; i < resposta.getOps().size(); i++) {

			Pred normal = resposta.getOps().get(i).getFirst().getFirst().getPred();
			Pred extendido = resposta.getOps().get(i).getFirst().getSecond().getPred();
			OPTipos tipo = resposta.getOps().get(i).getSecond().getFirst();
			POLog log = resposta.getOps().get(i).getSecond().getSecond();

			boolean extendivel = (log.getLog().contains(getMessage("COD0717"))
					|| log.getLog().contains(getMessage("COD0718")));
			boolean toModelChecker = log.getLog().contains(getMessage("COD0748"));

			if (tipo.equals(OPTipos.OP_CHECADA_TRUE) || tipo.equals(OPTipos.OP_CHECADA_FALSE)) {
				result.add(new ObrigacaoProva(normal, extendido, tipo, log, linhaLei, extendivel, toModelChecker));
			} else {
				/* Nao foi provado e o usu�rio poder� tentar
				 * provar essa OP atrav�s de um novo desenvolvimento
				 * que deve ter o mesmo contexto */
				if (normal instanceof TransformerPred) {
					Term contexto = gerInterno.retornarContexto();
					Term ast = this.getProgramaAtual();
					Term contextoApos = ast;
					result.add(new ObrigacaoProva(normal, extendido, tipo, log, linhaLei, extendivel, contexto, contextoApos, toModelChecker));

				} else {
					result.add(new ObrigacaoProva(normal, extendido, tipo, log, linhaLei, extendivel, toModelChecker));
				}
			}


		}
		return result;
	}

	/**
	 * Aplica uma lei com tudo setado, utilizado para a abertura
	 * de um programa.
	 *
	 * @param linhaInicial a linha inicial do termo no qual ser�
	 * 	aplicado a lei
	 * @param linhaFinal a linha final do termo no qual ser� aplicado
	 * 	a lei
	 * @param lei a lei a ser aplicada
	 * @param parametros as strings com os par�metros
	 */
	public void applyLaw(int linhaInicial, int linhaFinal, CircusLaw lei,
			List<String> parametros) throws CRulesException {

		/* retorna um termo a partir de sua linha final/inicial */
		NoPrograma nodo = this.retornarProgramaSelecionado(linhaInicial,
				linhaFinal);
		LawAnswer resposta = new LawAnswer();
		resposta = this.getGerInterno().aplicarLei(nodo.getPrograma(),
				lei, parametros);
		this.atualizarAposAplicacao(nodo, lei, resposta, linhaInicial);

		checkFinishedSubDevelopment(resposta.getNovaAST());


	}

	/**
	 * Efetua a mudança de exibição do refinamento do CRefine.
	 *
	 * @param novoMarkup novo estilo de exibição do programa
	 */
	public void mudarMarkup(Markup novoMarkup) {
		try {
			if (this.getSelectedDevelopment() != -1) {
				this.setMarkUp(novoMarkup);
				this.changingFormat = true;
				this.retornarTelaPrincipal().this_MudarExibicao(novoMarkup);
				this.changingFormat = false;
			}
		} catch (ChangeFormatException e) {
			e.printStackTrace();
			ErrorDialog errorDialog = new ErrorDialog(this, "",
					e);
			errorDialog.setVisible(true);
		}
	}

	/**
	 * Usado para retornar a classe de internacionalizacao
	 *
	 * @return a classe de internacionalização
	 */
	public Internacional getInternacional() {
		return internacional;
	}

	/**
	 * M�todo que retorna o tamanho horizontal do monitor.
	 *
	 * @return       O tamnho horizontal do monitor.
	 *
	 */
	public int getTamanhoHorizontal() {
		return tamHorizontal;
	}

	/**
	 * M�todo que retorna o tamanho vertical do monitor.
	 *
	 * @return       O tamnho vertical do monitor.
	 *
	 */
	public int getTamanhoVertical() {
		return tamVertical;
	}

	/**
	 * M�todo que inicializa todas as telas da ferramenta.
	 *
	 */
	public void inicializar() {

		telaDesenvolvimento = new TelaDesenvolvimento(this);
		telaAnimacao = new TelaAnimacao(this);
		telaObrigacao = new TelaObrigacao(this);
		telaCodigoAtual = new TelaCodigo(this);
		telaTatica = new TelaTatica(this);

		//Carregando ToolTips do CaixaLeis


		caixaLeis = new CaixaLeis(this);

		telaPrincipal = new TelaPrincipal(this, telaDesenvolvimento, telaCodigoAtual, telaObrigacao,  caixaLeis);

		infoTelas.setInfoDes(telaDesenvolvimento.getHeight(), telaDesenvolvimento.getWidth(), telaDesenvolvimento.getX(), telaDesenvolvimento.getY());
		infoTelas.setInfoAnimacao(telaAnimacao.getHeight(), telaAnimacao.getWidth(), telaAnimacao.getX(), telaAnimacao.getY());
		infoTelas.setInfoObri(telaObrigacao.getHeight(), telaObrigacao.getWidth(), telaObrigacao.getX(), telaObrigacao.getY());
		infoTelas.setInfoCod(telaCodigoAtual.getHeight(), telaCodigoAtual.getWidth(), telaCodigoAtual.getX(), telaCodigoAtual.getY());

		telaPrincipal.setExtendedState(TelaPrincipal.MAXIMIZED_BOTH);

		//telaCodigoAtual = new FCodigo(this);
		this.mostrarTelaDesenvolvimento();
		//this.mostrarTelaAnimacao();
		this.mostrarTelaObrigacao();
		this.mostrarTelaCodigoAtual();
		this.mostrarTelaPrincipal();

		/* Carrega as leis */
		//this.loadingLaws();
	}

	public void listarCodigosAtuais() {
	}

	/**
	 * M�todo que maximiza as telas da ferramenta.
	 *
	 */
	public void maximizarTelas() {
		telaDesenvolvimento.show();
		telaAnimacao.show();
		telaObrigacao.show();
		telaCodigoAtual.show();
	}

	/**
	 * M�todo que minimiza as telas da ferramenta.
	 *
	 */
	public void minimizarTelas() {
		telaDesenvolvimento.hide();
		telaAnimacao.hide();
		telaObrigacao.hide();
		telaCodigoAtual.hide();
	}

	/**
	 * M�todo que exibe a tela de ajuda da ferramenta.
	 *
	 */
	public void mostrarTelaAjuda() {
		//		telaHelp.show();
	}

	/**
	 * M�todo que exibe a tela do c�digo atual do programa que est� sendo refinado.
	 *
	 */
	public void mostrarTelaCodigoAtual() {
		telaCodigoAtual.setVisible(true);
	}

	/**
	 * M�todo que exibe a tela de desenvolvimento da ferramenta.
	 *
	 */
	public void mostrarTelaDesenvolvimento() {
		telaDesenvolvimento.setVisible(true);
	}

	public void mostrarTelaAnimacao() {
		telaAnimacao.setVisible(true);
	}

	public void esconderTelaAnimacao() {
		telaAnimacao.setVisible(false);
	}

	public void mostrarTelaTaticas() {
		telaTatica.setVisible(true);
	}


	/**
	 * M�todo que exibe a tela de digitação da ferramenta.
	 *
	 */
	public void mostrarTelaDigitacao(int numTela) {
		//		numeroTelaParam = numTela;
		//		telaDigitacao.show();
	}

	/**
	 * M�todo que exibe a tela de informa��es da ferramenta.
	 *
	 */
	public void mostrarTelaExplicacao() {
		//		telaExplicacao.show();
	}

	/**
	 * M�todo que exibe a tela de Nova Especificacao da ferramenta.
	 *
	 */
	public void mostrarTelaNovaEspec() {
		//		telaNovaEspec.show();
	}

	/**
	 * M�todo que exibe a tela de obrigação de provas da ferramenta.
	 *
	 */
	public void mostrarTelaObrigacao() {
		telaObrigacao.setVisible(true);
	}

	/**
	 * M�todo que exibe a tela principal da ferramenta.
	 *
	 */
	public void mostrarTelaPrincipal() {
		telaPrincipal.setVisible(true);
	}

	/**
	 * M�todo que exibe a tela de informa��es da ferramenta
	 *
	 */
	public void mostrarTelaSobre() {
		//		telaSobre.show();
	}

	/**
	 * M�todo que transforma um n�mero natural em um n�mero romano.
	 *
	 * @param nat        O n�mero natural que ser� transformado em romano.
	 * @param quant      Quantidade de vezes que este m�todo foi chamado
	 *                   recursivamente (este par�metro e�til para o controle de
	 *                   par�nteses que ser�o impressos na tela).
	 *
	 * @return           Uma String que representa o n�mero romano.
	 *
	 */
	public String natToRom(int valor, int qtd) {
		return NatToRoman.natToRom(valor, qtd);
	}

	/**
	 * M�todo que chama os procedimentos para receber um novo
	 * programa, mostr�-lo na tela, e guard�-lo na lista de
	 * desenvolvimento.
	 *
	 * @param strPrograma String programa que passar� pelo parser.
	 * @see #openSpecification(Source)
	 */
	public int openSpecification(String pathPrograma) throws CRefineException {
		File fileSource = new File(pathPrograma);
		FileSource source = new FileSource(fileSource);

		int result = -1;
		result = this.openSpecification(source, fileSource.getName());
		//TODO retirarthis.atualizarTelaCodigo(result);


		/* Atualiza a lista de acoes */

		return result;

	}

	/**
	 * M�todo que chama os procedimentos para receber um novo
	 * programa, mostr�-lo na tela, e guard�-lo na lista de
	 * desenvolvimento.
	 *
	 * @param source a fonte para a abertura da especificação
	 */
	public int openSpecification(Source source, String name) throws CRefineException {
		int id;
		try {
			LoadAnswer resposta = gerInterno.openSpecification(source);
			id = gerDevelopments.inserirNovoDesenvolvimento(name, telaPrincipal.getMarkUp(), resposta);
			telaDesenvolvimento.adicionarNovoDesenvolvimento(id);
			telaObrigacao.adicionarNovoObrigacao(id);

		} catch (ParseException except) {
			//"COD0510"
			CRefineException e = new CRefineException(except, except.getMessage());
			e.setTitleCode("COD0510");
			throw e;

		} catch (IOException except) {
			CRefineException e = new CRefineException(except, except.getMessage());
			e.setTitleCode("COD0609");
			throw e;
		} catch (UnmarshalException except) {
			String msg = this.getMessage("COD0657");
			CRefineException e = new CRefineException(msg, except, null);
			throw e;
		}

		return id;
	}

	/**
	 * Adiciona uma aplicação de lei ao hist�rico de refinamento
	 * do Desenvolvimento Selecionado
	 *
	 * @param resposta a resposta da aplicação de lei
	 */
	private void adicionarAplicacaoLeiAoHistorico(LawAnswer resposta) {
		LawNumberAnn ann = resposta.getLeiAplicada().getAnn(LawNumberAnn.class);
		LawApplication passo =
			new LawApplication(ann.getId(), resposta.getParametrosUtilizados(),
					resposta.getLinhaInicial(), resposta.getLinhaFinal());
		this.getDevelopment().adicionarHistorico(passo);
	}

	/**
	 * Coloca o passo de remoção de coment�rio no hist�rico de
	 * desenvolvimento.
	 *
	 * @param resposta a resposta eremoção do coment�rio
	 */
	private void adicionandoRemocaoComentarioAoHistotico(RemoveCommentAnswer resposta) {
		RemocaoComentario rem = new RemocaoComentario(resposta.getLinhaInicial(),
				resposta.getLinhaFinal(), resposta.getIdentificador());
		this.getDevelopment().adicionarHistorico(rem);
	}

	/**
	 * Adiciona a Insercao de Comentario ao Historico
	 *
	 * @param resposta os dados do passo de adição de coment�rio
	 */
	private void adicionandoAdicaoComentarioAoHistorico(InsertCommentAnswer resposta) {
		AdicaoComentario novo = new AdicaoComentario(resposta.getText(),
				resposta.getLinhaInicial(), resposta.getLinhaFinal(),
				resposta.getIdentificador());

		this.getDevelopment().adicionarHistorico(novo);
	}

	/**
	 * Adiciona o passo de coleta de c�digo ao CRefine
	 *
	 * @param resposta a resposta ao passo de coleta de c�digo
	 */
	public void adicionarColetaAoHistorico(CollectAnswer resposta) {

		/* Adiciona a coleta aos passos de refinamento */
		Coleta passo = new Coleta(resposta.getTipo(),
				resposta.getNomeParagrafo());
		this.getDevelopment().adicionarHistorico(passo);
	}

	private DevelopmentTree getDevelopment() {
		int id = this.getSelectedDevelopment();
		return this.getDevelopment(id);
	}

	public void save(String path) throws CRefineException {

		try {
			//Adicionando ultimo passo a lista de historico
			//passo responsavel por configuracao de Predicados

			//Teste de Sufixo xml
			if (path.endsWith(".xml")) {
				this.gerInterno.salvar(new File(path));
				this.removerPassoSubDesenvolvimento(this.getSelectedDevelopment());
			} else {
				this.gerInterno.salvar(new File(path + ".xml"));
			}

		} catch (FileNotFoundException except) {
			CRefineException e = new CRefineException(except, except.getMessage());
			e.setTitleCode("COD0263");
			throw e;
		} catch (IOException except) {
			CRefineException e = new CRefineException(except, except.getMessage());
			e.setTitleCode("COD0263");
			throw e;
		} catch (Exception except) {
			CRefineException e = new CRefineException(except, except.getMessage());
			e.setTitleCode("SaveError");
			throw e;
		}

	}

	/**
	 * Remove o recem inserido passo de SubDesenvolvimento de um Desenvolvimento
	 * que foi recentemente salvo;
	 * @param selectedDevelopment
	 */
	private void removerPassoSubDesenvolvimento(int selectedDevelopment) {
		this.gerDevelopments.removerPassoSubDesenvolvimento(selectedDevelopment);
	}

	/**
	 * Metodo que me retorna o tamanho do historico de
	 * um arquivo salvo
	 * @param fileName o nome do arquivo
	 * @return
	 * @throws IOException
	 */
	public int getHistoricSizeOfFile(String fileName) throws IOException {
		return this.gerInterno.getHistoricSizeOfFile(fileName);
	}

	public void openFile(String path) {

		try {
			loading = true;
			this.gerInterno.abrir(new File(path));
			loading = false;

			this.atualizarOpcoesColeta();
			if (getSizeOfHistorico() > 1) {
				this.telaPrincipal.habilitarUndo();
			}
		} catch (CRefineException except) {
			except.setTitleCode("COD0262");
			ErrorDialog errorDialog = new ErrorDialog(this, "",
					except);
			errorDialog.setVisible(true);
			except.printStackTrace();
		} catch (IOException except) {
			CRefineException e = new CRefineException(except, except.getMessage());
			e.setTitleCode("COD0609");
			ErrorDialog errorDialog = new ErrorDialog(this, path,
					e);
			errorDialog.setVisible(true);
			except.printStackTrace();
		} catch (Exception except) {
			CRefineException e = new CRefineException(except, except.getMessage());
			e.setTitleCode("COD0262");
			ErrorDialog errorDialog = new ErrorDialog(this, path,
					e);
			errorDialog.setVisible(true);
			except.printStackTrace();
		}

	}

	/**
	 * Atualiza a lista de a��es do programa para a coleta de c�digo
	 */
	private void updateActionTerms() {
		List<String> nomes = this.listarNomesActionPara();
		this.telaPrincipal.listarNomesTermsPara(nomes);
	}

	private void updateProcessTerms() {
		List<String> nomes = this.listarNomesProcessPara();
		this.telaPrincipal.listarNomesTermsPara(nomes);
	}

	public List<String> listarNomesProcessPara() {
		Term prog = this.retornarProgAtual();
		List<ProcessPara> processos = gerInterno.retornarProcessPara(prog);
		List<String> nomes = new ArrayList<String>();
		/* lista as a��es comuns */
		for (ProcessPara process : processos) {
			String nome = process.getZName().getWord();
			nomes.add(nome);
		}
		nomes.add(0, this.getMessage("COD0514"));

		return nomes;
	}

	/**
	 * Lista as Acoes que podem ser coletadas.
	 *
	 * @return uma lista de <code>String</code>s com os nomes das
	 * 			acoes
	 */
	public List<String> listarNomesActionPara() {

		Term prog = this.retornarProgAtual();
		List<ActionPara> acoes = gerInterno.retornarActionsPara(prog);
		ListTerm<BasicProcess> basicProc = gerInterno.retornarBasicProcess(prog);
		List<String> nomes = new ArrayList<String>();

		int i = 0;

		/* lista as a��es comuns */
		for (ActionPara acao : acoes) {
			String nome = acao.getZName().getWord();
			if (!nome.equals(CircusUtils.DEFAULT_MAIN_ACTION_NAME)) {
				nomes.add(nome);
			}
			i++;
		}

		/* Lista as MainAction */
		i = 0;
		for (BasicProcess proc : basicProc) {

			/* COD0471 == Acao Principal */
			nomes.add(this.getInternacional().retornarMensagem("COD0471")
					+ "(" + i + ")");
			i++;
		}



		/* COD0472 == Coletar Ação */
		nomes.add(0, this.getMessage("COD0472"));

		return nomes;
	}

	/**
	 * Acessa o status dessa classe para posterior salvamento de um
	 * refinamento
	 *
	 * @return o status do gerenciador externo
	 */
	/*protected StatusExterno retornarStatus() {
    return new StatusExterno(this.getRelacionamentos(),
    this.RespostaLeisUtilizadas, this.redoRespostaLeisUtilizadas);
    }*/
	/**
	 * Seta o status desta classe. Utilizado no processo de abertura
	 * de um refinamento
	 *
	 * @param novoStatus o novo status a ser setado no gerenciador
	 *  externo
	 */
	/*protected void setarStatus(StatusExterno novoStatus) {
    this.relacionamentosTela = novoStatus.getRelacionamentos();
    this.RespostaLeisUtilizadas = novoStatus.getRespostaLeisUtilizadas();
    this.redoRespostaLeisUtilizadas = novoStatus.getRespostaLeisDesfeitas();
    }*/
	/**
	 * Salva um refinamento em um arquivo.
	 *
	 * @param arquivo o aquivo onde ser� salvo o conteudo do
	 * 	refinamento
	 */
	/*public void salvarPrograma(File arquivo) throws IOException {
    CircusRefineStatus aSalvar =
    new CircusRefineStatus(this.retornarTelaDesenvolvimento().retornarStatus(),
    this.retornarStatus(), this.gerInterno.retornarStatus(),
    this.retornarTelaPrincipal().retornarStatus());
    aSalvar.salvar(arquivo);

    }*/
	public CaixaLeis retornarCaixaLeis() {
		return this.caixaLeis;
	}

	/**
	 * Lista as obrigacoes de prova de todas as leis aplicadas
	 * durante o refinamento. Utilizado na abertura de um
	 * refinamento.
	 *
	 * @return a lista com as Strings de todas as obrigacoes de
	 * 	prova.
	 */
	//	private List<Pred> listarObrigacoes() {
	//	ArrayList<Pred> obgs = new ArrayList<Pred>();
	//	for (RespostaLei resposta : this.RespostaLeisUtilizadas) {
	//	obgs.addAll(resposta.getObrigacoes());
	//	}
	//	return obgs;
	//	}
	public void exibirErrosLei(List errors) {
		String strErrors = this.getMessage("COD0470");
		strErrors = strErrors + "\n";
		for (Object next : errors) {
			String strNext = quebrarString(next.toString());
			strErrors = strErrors + "  -> " + strNext + "\n";
		}
		telaDesenvolvimento.showError(this.getMessage("COD0465"), strErrors, JOptionPane.INFORMATION_MESSAGE);
	}

	public void addRelacionamentos(List<Relacionamento> rels) {
		this.relacionamentosTela.addAll(rels);
	}
	/*
    public java.util.List<Relacionamento> getRelacionamentosAtuais() {
    return relacionamentosTela.peek();
    }
	 */

	public List<Relacionamento> getRelacionamentos() {
		return relacionamentosTela;
	}

	/**
	 * Metodo que me realiza a Coleta de Ação na Tela de Desenvolvimentos
	 * Especialmente util para os relacionamentos de Tela.
	 * @param nome	nome da ação selecionada no actionsParag
	 */
	public CollectAnswer coletarCodigoAcao(String nome) {

		/*Esse arrumadinho serve pra colocar o nome da acao principal na forma default
		 * utilizada no CircusUtils.java*/
		if (nome.startsWith(this.getMessage("COD0471"))) {
			nome = CircusUtils.DEFAULT_MAIN_ACTION_NAME;
		}

		/* Pesquisa pelo termo a coletar */
		CollectAnswer resposta = gerInterno.coletarCodigoAcao(nome, this.retornarProgAtual());

		TermoColetado newTerm = new TermoColetado(nome, TipoColeta.ACAO);
		this.adicionarTermoColetado(newTerm);


		if (resposta.getTermoColetado() != null) {
			telaDesenvolvimento.collectedScreen(resposta.getTermoColetado());
			IdtUtils.inserirIdtTermoColetado(resposta.getTermoColetado());
		}
		return resposta;

	}

	/**
	 * Metodo que me realiza a Coleta de Processo na Tela de Desenvolvimentos
	 * Especialmente util para os relacionamentos de Tela.
	 *
	 * @param nome	nome do Processo selecionada no actionsParag
	 */
	public CollectAnswer coletarCodigoProcesso(String nome) {

		/* Procura pelo processo */
		CollectAnswer resposta =
			this.getGerInterno().coletarCodigoProcesso(nome, this.retornarProgAtual());
		Term process = resposta.getTermoColetado();

		TermoColetado newTerm = new TermoColetado(nome, TipoColeta.PROCESSO);
		this.adicionarTermoColetado(newTerm);

		if (process != null) {
			telaDesenvolvimento.collectedScreen(process);
			IdtUtils.inserirIdtTermoColetado(process);

		}

		return resposta;
	}

	/**
	 * Metodo que retorna o termo referente ao nome que foi selecionado no
	 * JComboBox
	 * @param nome String selecionado do JComboc actionParag
	 * @return termo
	 */
	public Term TermFromName(TermoColetado nome) {

		String name = nome.getNome();
		if (nome.getTipo().equals(TipoColeta.ACAO)) {
			if (nome.getNome().startsWith(this.getMessage("COD0471"))) {

				name = CircusUtils.DEFAULT_MAIN_ACTION_NAME;
			}

			CollectAnswer resposta = gerInterno.coletarCodigoAcao(name, getDevelopment().getProgAtual());
			return resposta.getTermoColetado();
		} else {
			CollectAnswer resposta = gerInterno.coletarCodigoProcesso(name, getDevelopment().getProgAtual());
			return resposta.getTermoColetado();
		}
	}

	/**
	 * Retorna o termo que compreende a linha inicial linhaI e a linha final
	 * linhaF e cujo desenvolvimento eindexado por idt
	 * @param idt indice do desenvolvimento
	 * @param linhaI linha inicial
	 * @param linhaF linha final
	 * @return termo
	 */
	public NoPrograma retornarProgramaSelecionado(int idt, int linhaI, int linhaF) {


		NoPrograma toReturn = this.gerDevelopments.retornarProgSelecionado(idt, linhaI, linhaF);

		return toReturn;
	}

	/**
	 *
	 *
	 * @param termoSelecionado
	 * @return
	 */
	public Term wrapForTransformer(Term termoSelecionado) {
		if (termoSelecionado instanceof Expr && termoSelecionado.getAnn(StatementSchExprAnn.class) == null) {
			CircusPatternFactory factory = new CircusPatternFactoryImpl();

			/* Cria a anotação de que a classe foi transformada */
			TemporaryTermAnn ann = new TemporaryTermAnn(termoSelecionado);
			termoSelecionado =
				factory.createSchExprAction((Expr) termoSelecionado);

			/* Adiciona a anotação ecapsula que contem o elemento */
			termoSelecionado.getAnns().add(ann);

		} else if (termoSelecionado instanceof Expr && termoSelecionado.getAnn(StatementSchExprAnn.class) != null) {

			termoSelecionado.getAnn(StatementSchExprAnn.class).getTermo().getAnns().add(new StatementSchExprAnn(termoSelecionado));

			return termoSelecionado.getAnn(StatementSchExprAnn.class).getTermo();
		} else if (termoSelecionado instanceof ProcessPara) {

			/*
			 * Cria a anotação para disfarcar um paragrafo de processo
			 * em um processo
			 */
			termoSelecionado =
				((ProcessPara) termoSelecionado).getCircusProcess();
		}
		return termoSelecionado;
	}

	/**
	 *
	 * @param linhaI
	 * @param linhaF
	 * @return
	 */
	//	public Term retornarProgramaRelacionado(int linhaI, int linhaF) {
	//	SelectionTermByStackVisitor seleciona =
	//	new SelectionTermByStackVisitor(new RelationsAnn(linhaI, linhaF));
	//	Term result = this.gerInterno.retornarProgAtual().accept(seleciona);
	//	return result;
	//	}
	public void showTypecheckerErrors(List errors) {
		String strErrors = this.getMessage("COD0466");
		strErrors = strErrors + "\n";
		for (Object next : errors) {
			String strNext = quebrarString(next.toString());
			strErrors = strErrors + "  -> " + strNext + "\n";
		}
		telaDesenvolvimento.showError(this.getMessage("COD0465"), strErrors, JOptionPane.INFORMATION_MESSAGE);
	}

	private String quebrarString(String str) {
		String strTmp = str;
		if (str.length() > 100) {
			strTmp = str.substring(0, 100);
			strTmp = strTmp + "\n";
			strTmp = strTmp + "       " + quebrarString(str.substring(100));
		}

		return strTmp;
	}

	/**
	 * M�todo que retorna uma mensagem representada pelo c�digo passado como
	 * par�metro.
	 *
	 * @param cod           C�digo da mensagem que se quer retornar.
	 *
	 * @return              Uma string que representa a mensagem.
	 *
	 */
	public String getMessage(String codigo) {
		String mensagem = internacional.retornarMensagem(codigo);
		return mensagem;
	}

	/**
	 * M�todo que verifica se existe algum programa selecionado.
	 *
	 * @return       O programa selecionado.
	 *
	 */
	public NoPrograma getSelectedProg() /*throws ProgramaSelecionadoInvalidoException*/ {
		int id = telaDesenvolvimento.getSelectedDevelopment();
		return telaDesenvolvimento.retornarProgSelecionado(id);
	}

	/**
	 * M�todo que retorna a tela de desenvolvimento do sistema.
	 *
	 * @return       A tela de desenvolvimento.
	 *
	 */
	public TelaDesenvolvimento retornarTelaDesenvolvimento() {
		return telaDesenvolvimento;
	}

	public TelaAnimacao retornarTelaAnimacao() {
		return telaAnimacao;
	}

	/**
	 * M�todo que retorna a tela de Obriga��es do sistema.
	 *
	 * @return       A tela de Obriga��es.
	 *
	 */
	public TelaObrigacao retornarTelaObrigacao() {
		return telaObrigacao;
	}

	/**
	 * M�todo que retorna a tela de Codigo do sistema.
	 *
	 * @return       A tela de Codigo.
	 *
	 */
	public TelaCodigo retornarTelaCodigo() {
		return telaCodigoAtual;
	}

	/**
	 * M�todo que retorna a telaPrincipal do sistema.
	 *
	 * @return       A tela Principal.
	 *
	 */
	public TelaPrincipal retornarTelaPrincipal() {
		return telaPrincipal;
	}

	/**
	 * Método que retornar a Tela Tática
	 * @return
	 */
	public TelaTatica retornarTelaTatica() {
		return telaTatica;

	}

	/**
	 * M�todo que salva o arquivo desenvolido na ferramenta como sendo do tipo
	 * texto para servir para uma posterior impress�o deste arquivo.
	 *
	 */
	/*	public void salvarParaArquivoTexto(){
    telaImprimir.show();
    } */
	/**
	 * M�todo que salva o programa desenvolvido na ferramenta com um tipo aceito
	 * por ela.
	 *
	 * @param nomeArquivo    Nome que ser� dado ao arquivo para uma posterior
	 *                       identificação.
	 *
	 */
	/*	public void salvarPrograma(String nomeArquivo) throws Exception{
    // Guardando os atributos de status da tela de desenvolvimento
    StatusTelaDesenvolvimento statusTelaDesenvolvimento = telaDesenvolvimento.retornarStatusTelaDesenvolvimento();
    // Guardando os atributos de status da tela de obrigacao de provas
    StatusTelaObrigacao statusTelaObrigacao = telaObrigacao.retornarStatusTelaObrigacao();
    // Guardando os atributos de status da tela de codigo gerado
    StatusTelaCodigo statusTelaCodigo = telaCodigoAtual.retornarStatusTelaCodigo();
    // Guardando todos os atributos das telas num objeto so
    StatusTelaCompleto statusTelas = new StatusTelaCompleto(statusTelaDesenvolvimento, statusTelaObrigacao, statusTelaCodigo, this.numDesfazer);
    gerInterno.salvarPrograma(nomeArquivo, statusTelas);
    } */
	/**
	 * M�todo que seta o foco das janelas da aplicação.
	 *
	 */
	public void setarFocus() {
		this.mostrarTelaObrigacao();
		this.mostrarTelaDesenvolvimento();
		this.mostrarTelaCodigoAtual();
		this.mostrarTelaPrincipal();
	}

	/**
	 * M�todo para setar o status do programa em um determinado momento, mostrando
	 * o status na tela principal.
	 *
	 * @param status         Valor a ser atribuido como status do programa.
	 *
	 */
	public void setarStatus(String status) {
		telaPrincipal.setarStatus(status);
	}

	/**
	 * M�todo que seta as vari�veis que representam o tamanho do monitor.
	 *
	 * @param x      Tamanho horzontal do monitor.
	 * @param y      Tamanho vertical do monitor.
	 *
	 */
	public void setTamanhoMonitor(int x, int y) {
		tamHorizontal = x;
		tamVertical = y;

	}

	/**
	 * M�todo que retorna o tipo de par�metro necess�rio para a aplicação da lei.
	 *
	 * @param codLeiSelecionada      C�digo da lei selecionada pelo usu�rio.
	 *
	 * @return                       Um interio que indica qual o tipo do par�me-
	 *                               tro necess�rio.
	 *
	 */
	/*	public int tipoParametro(int codLeiSelecionada) throws CodigoParametroInexistenteException {
    int codigo;
    codigo = gerInterno.tipoParametro(codLeiSelecionada);
    return codigo;
    } */
	/**
	 * Retira a seleção, se existir, da tela de obrigação de desenvolvimento.
	 *
	 */
	public void tirarSelecao() {
		this.telaDesenvolvimento.tirarSelecao();
		this.telaObrigacao.tirarSelecao();
	}

	/**
	 * Metodo utilizado para desfazer uma aplicacao de lei ou uma colecao de acao
	 *
	 */
	public void desfazer() throws CRulesException, CRefineException {
		this.getDevelopment().getLastAction().undoStep(this);
		this.getDevelopment().desfazerPasso();
	}

	/**
	 * Responsavel por atualizar alguns identificadores da GUI.
	 * Se uma acao foi refeita, os identificadores que devem
	 * ser recolados devem estar nas pilhas de undo do Historico
	 */
	public void redoIdentGUI() throws CRefineException {
		if (this.getDevelopment().getLastAction() instanceof LawApplication) {
			this.atualizarTelaCodigo();
			this.telaDesenvolvimento.updateLawIdentifierGUI(false);
		} else if (this.getDevelopment().getLastAction() instanceof AdicaoComentario) {
			int linha = ((AdicaoComentario) this.getDevelopment().getLastAction()).getLinhaInicial();
			this.telaDesenvolvimento.updateCommentIdentifierGUI(linha);
		} else if (this.getDevelopment().getLastAction() instanceof RemocaoComentario) {

			int linha = ((RemocaoComentario) this.getDevelopment().getLastAction()).getLinhaInicial();
			this.telaDesenvolvimento.updateCommentIdentifierGUI(linha);

		}
	}

	/**
	 * Responsavel por atualizar alguns identificadores da GUI.
	 * Se uma acao foi desfeita, os identificadores que devem
	 * ser recolados devem estar nas pilhas de redo do Historico
	 */
	public void undoIdentGUI() throws CRefineException {
		if (this.getDevelopment().getRedoLastAction() instanceof LawApplication) {
			this.atualizarTelaCodigo();
			this.telaDesenvolvimento.updateLawIdentifierGUI(true);
		} else if (this.getDevelopment().getRedoLastAction() instanceof InsertParagraph) {
			this.atualizarTelaCodigo();
		} else if (this.getDevelopment().getRedoLastAction() instanceof AdicaoComentario) {
			int linha = ((AdicaoComentario) this.getDevelopment().getRedoLastAction()).getLinhaInicial();
			this.telaDesenvolvimento.updateCommentIdentifierGUI(linha);
		} else if (this.getDevelopment().getRedoLastAction() instanceof RemocaoComentario) {

			int linha = ((RemocaoComentario) this.getDevelopment().getRedoLastAction()).getLinhaInicial();
			this.telaDesenvolvimento.updateCommentIdentifierGUI(linha);

		}
	}

	/**
	 * Responsavel por atualizar alguns identificadores da GUI.
	 * Se uma acao foi desfeita, os identificadores que devem
	 * ser recolados devem estar nas pilhas de redo do Historico
	 */
	public void undoIdentGUITatica() throws CRefineException {

		this.atualizarTelaCodigo();
		int linha = gerInterno.respostaLei.getLinhaInicial();
		this.telaDesenvolvimento.updateLawIdentifierGUITactic(true, linha);

	}


	/**
	 * Responsavel por atualizar alguns identificadores da GUI.
	 * Se uma acao foi desfeita, os identificadores que devem
	 * ser recolados devem estar nas pilhas de redo do Historico
	 */
	public void redoIdentGUITatica() throws CRefineException {

		this.atualizarTelaCodigo();
		int linha = gerInterno.respostaLei.getLinhaInicial();
		this.telaDesenvolvimento.updateLawIdentifierGUITactic(false, linha);

	}

	public void refazer() throws CRefineException, CRulesException {

		this.getDevelopment().getRedoLastAction().redoStep(this);

		/* Atualiza o hist�rico de desenvolvimento */
		this.getDevelopment().refazerPasso();


	}

	public void refazerTatica() throws CRefineException, CRulesException {

		this.refazerInterno();
		this.checkFinishedSubDevelopment(this.retornarProgAtual());
		this.reaplicarTatica(); // dentro do reapplyscreen ele reinsere o idt de aplicacao
		//this.refazerPilhasLeis();


	}

	/**
	 * Metodo que me retornar o tipo de Lei que sera aplicado. Podendo ser
	 * Equivalencia, Simulação ou Refinamento dependendo do tipo de Transformation
	 */
	public Transformation getType(CircusLaw c) {

		return gerInterno.getType(c);
	}

	/**
	 * Esvazia pilhas de undo
	 *
	 */
	public void esvaziarPilhas() {

		int id = this.getSelectedDevelopment();

		this.getDevelopment(id).esvaziarUndo();
		this.retornarTelaDesenvolvimento().esvaziarPilhas();
	}

	/**
	 * M�todo utilizado para esvaziar as pilhas do redo
	 *
	 */
	public void esvaziarRedoPilhas() {
		int id = this.getSelectedDevelopment();

		this.getDevelopment(id).esvaziarRedo();

		this.retornarTelaDesenvolvimento().esvaziarRedoPilhas();
		this.telaPrincipal.desabilitarRedo();

		//		RelationsUtils.removeRedoStack(this.gerInterno.retornarProgAtual());
	}

	/**
	 * M�todo que coloca a barrinha de rolagem pra baixo apos aplicação de uma lei
	 */
	public void desceRoll() {
		this.telaDesenvolvimento.desceRoll();
	}

	/**
	 * Metodo que chama o visitor para desfazer a ultima Relacao
	 * @param name	nome do Termo em que ser�o desfeitos as ultimas rela��es
	 */
	public void desfazerRelacoes(TermoColetado name) {
		Term termo = this.TermFromName(name);
		DesfazerRelationsVisitor des = new DesfazerRelationsVisitor();
		des.visitTerm(termo);

	}

	/**
	 * Metodo que chama o visitor para refazer a ultima Relacao
	 * @param name	Nome do Termo Termo em que serao refeitas as ultimas rela��es
	 */
	public void refazerRelacoes(TermoColetado name) {
		Term termo = this.TermFromName(name);
		RefazerRelationsVisitor ref = new RefazerRelationsVisitor();
		ref.visitTerm(termo);
	}

	/**
	 * Metodo utilizado no frame InfoLeis para se obter a observacao
	 * da Lei
	 * @param law Lei base do frame InfoLei
	 * @param Janela de Lei em que sera inserido as obriga��es
	 */
	public void setarObservacaoDaLei(CircusLaw law, InfoLei infoLaw) {
		LawDefinitionAnn ann = law.getAnn(LawDefinitionAnn.class);
		if (ann != null) {
			if (ann.getDescription() != null) {
				infoLaw.setarObservacoes(ann.getDescription());
			}
		}
	}

	/**
	 * Metodo utilizado no frame InfoLeis para se obter os predicados
	 * da Lei em forma de String utilizando o printer.
	 * @param law Lei base do frame InfoLei
	 * @param Janela de Lei em que sera inserido as obriga��es
	 */
	public void setarObrigacoesDaLei(CircusLaw law, InfoLei infoLaw) {

		String[] resTemp = null;
		SequentList seqList = law.getProvisoos();

		/* Nao necessita guardar relacionamentos*/
		Printer printer = new Printer(this.getMark(), false);
		int counterPreds = 1;
		int index = 1;
		LawDefinitionAnn opAnn = law.getAnn(LawDefinitionAnn.class);

		if (opAnn == null || opAnn.getPos() == null) {
			for (Sequent seq : seqList) {
				if (index > 0) {
					Pred pred = seq.getPred();
					resTemp = (String[]) printer.visitTerm(pred);
					infoLaw.setObrigacoes(resTemp, counterPreds);
					counterPreds++;
				}
				index++;
			}
		} else {
			for (String op : opAnn.getPos()) {
				if (index > 0) {
					String[] temp = op.split("\n");
					infoLaw.setObrigacoes(temp, counterPreds);
					counterPreds++;
				}
				index++;
			}
		}


	}

	/**
	 * Metodo utilizado para setar os famoses jokers, anteriores a aplicação da
	 * lei
	 * @param law  Lei base do frame InfoLei
	 * @param infoLei	Janela em que sera setada o field Antes
	 */
	public void setarAntesDaLei(CircusLaw law, InfoLei infoLei) {

		/* Nao precisar inserir Relacionamentos*/
		Printer printer = new Printer(this.getMark(), false);
		LawDefinitionAnn ann = law.getAnn(LawDefinitionAnn.class);
		//Se for uma Lei de Ação
		if (law.isActionLaw()) {
			if (ann == null || ann.getBeforeApplication() == null) {
				ActionTransformerPred antesPred = law.getActionRel();
				CircusAction antes = antesPred.getSpec();
				String[] result = (String[]) printer.visitTerm(antes);
				infoLei.setAntes(result);
			} else {
				infoLei.setAntes(ann.getBeforeApplication());
			}
		} //Caso contrario, ou seja, uma lei de processo
		else {
			if (ann == null || ann.getBeforeApplication() == null) {
				ProcessTransformerPred antesPred = law.getProcessRel();
				CircusProcess antes = antesPred.getSpec();
				String[] result = (String[]) printer.visitTerm(antes);
				infoLei.setAntes(result);
			} else {
				infoLei.setAntes(ann.getBeforeApplication());
			}

		}

	}

	/**
	 * Metodo utilizado para setar o campo depois do frame Infolei, o qual
	 * representa os novos termos gerados apos a aplicação da lei
	 * @param law
	 * @param infoLei
	 */
	public void setarDepoisDaLei(CircusLaw law, InfoLei infoLei) {

		/* Nao precisa setar relacionamentos*/
		Printer printer = new Printer(this.getMark(), false);

		LawDefinitionAnn ann = law.getAnn(LawDefinitionAnn.class);
		//Se for uma Lei de Ação
		if (law.isActionLaw()) {
			if (ann == null || ann.getBeforeApplication() == null) {
				ActionTransformerPred antesPred = law.getActionRel();
				CircusAction antes = antesPred.getImpl();
				String[] result = (String[]) printer.visitTerm(antes);
				infoLei.setDepois(result);
			} else {
				infoLei.setDepois(ann.getAfterApplication());
			}
		} //Caso contrario, ou seja, uma lei de processo
		else {
			if (ann == null || ann.getBeforeApplication() == null) {
				ProcessTransformerPred antesPred = law.getProcessRel();
				CircusProcess antes = antesPred.getImpl();
				String[] result = (String[]) printer.visitTerm(antes);
				infoLei.setDepois(result);
			} else {
				infoLei.setDepois(ann.getAfterApplication());
			}
		}

	}

	/**
	 * Metodo utilizado na captura dos parametros utilizando a tela parametros,
	 * chamando o parser de argumentos
	 * @param jokers o conjunto de jokers representando os argumentos
	 * 		 formais
	 * @return a lista de par�metros correspondentes ao Joker
	 * @throws CancelledApplException
	 */
	public List<String> mostrarTelaParametros(List<Term> jokers)
	throws CancelledApplException {

		List<String> result = new ArrayList<String>(jokers.size());

		for (Term term : jokers) {

			/* Pega o tipo do par�metro a ser adicionado */
			CodNameParam cod = CodParamVisitor.getCode(term);

			/* Pega a string representando o argumento */
			String argumento =
				this.retornarCaixaLeis().mostrarTelaParametro(cod.getCodigo(),
						cod.getName());

			/* Usu�rio cancelou a aplicação da lei */
			if (argumento == null) {

				try {
					throw new CancelledApplException("CancelledApplMsg");
				} catch (CRulesMissingMessageException e) {
				}
			}

			/* Adicionando elista de argumentos */
			result.add(argumento);
		}

		return result;
	}

	/**
	 * Realiza a remocao do programa original em Latex e
	 * realiza a impressao do mesmo em Unicode
	 *
	 */
	public void MudandoProgramaOriginal() {
		if (this.retornarProgAtual() != null) {

			RelationsUtils.removeStack(this.retornarProgAtual());

			Term ast = retornarProgAtual();
			this.retornarTelaDesenvolvimento().setarTelaTextoDePrograma(ast);

			ast = retornarProgAtual();
			this.telaPrincipal.incrementProgress();
		}
	}

	/**
	 * Metodo que pegara um termo, e verificar dentro das leis carregas,
	 * quais sao unificadas pelo termo
	 * @param term termo que se deseja pegar as possiveis aplicacoes de lei
	 * @return lista de leis aplicav�is
	 */
	public List<CircusLaw> aplicableLaws(Term term) {
		List<CircusLaw> result = this.gerInterno.filterLaws(term, this.getLaws());

		return result;
	}

	/**
	 * Metodo que retornar a lei Selecionado no ComBoxdeLeis
	 * @return lei selecionada
	 */
	public CircusLaw retornarLeiSelecionada() {
		String nameLaw = this.caixaLeis.retornarLeiSelecionada();
		if (nameLaw != this.getMessage("COD0592")) {
			for (CircusLaw lei : this.getLaws()) {
				if (lei.getName().equals(nameLaw)) {
					return lei;
				}
			}
		}
		return null;
	}

	/**
	 * Metodo que habilita o botao de aplicarLei na Tela Principal
	 */
	public void HabilitarAplicarLei() {
		this.retornarTelaPrincipal().HabilitarAplicarLei();
	}

	public void DesabilitarAplicarLei() {
		this.retornarTelaPrincipal().DesabilitarAplicarLei();
	}

	/**
	 * Insere coment�rio no CRefine
	 *
	 * @param text coment�rio o conte�do do coment�rio a ser inserido
	 */
	public void insertComment(String text) {

		/* Captura as linhas e insere os coment�rios */
		int[] linhas =
			this.retornarLinhasSelecionadas();
		this.insertComment(text, linhas[0], linhas[1]);
		this.telaDesenvolvimento.updateCommentIdentifierGUI(linhas[0]);
	}

	/**
	 * Insere um coment�rio na ferramenta explicitando as linhas Inicial
	 * e Final no qual o coment�rio ser� posto
	 *
	 * @param text a String com o texto do coment�rio
	 * @param linhaInicial a linha inicial da tela de desenvolvimento
	 *  selecionada para o coment�rio
	 * @param linhaFinal a linha final da tela de desenvolvimento
	 *  selecionada para o coment�rio
	 */
	public void insertComment(String text, int linhaInicial, int linhaFinal) {
		/* Insere o coment�rio ao programa */
		InsertCommentAnswer resposta =
			this.telaDesenvolvimento.inserirComentario(text, linhaInicial,
					linhaFinal);
		/* Inserindo ao Historico */
		this.adicionandoAdicaoComentarioAoHistorico(resposta);
		this.esvaziarRedoPilhas();
		this.retornarTelaPrincipal().habilitarUndo();
	}

	/**
	 * Edita um coment�rio
	 *
	 * @param text o novo texto do coment�rio
	 */
	public void editComment(String text) {
		int[] linhas =
			this.retornarLinhasSelecionadas();
		this.editComment(text, linhas[0], linhas[1]);
	}

	/**
	 * Edita um coment�rio explicitando as linhas inicial e final do
	 * coment�rio
	 *
	 * @param text o novo conte�do do coment�rio
	 * @param linhaInicial a linha inicial do coment�rio
	 * @param linhaFinal a linha final do coment�rio
	 */
	public void editComment(String text, int linhaInicial, int linhaFinal) {
		/* Edita propriamente o coment�rio */
		Comentario comment = this.telaDesenvolvimento.editarComentario(text, linhaInicial,
				linhaFinal);
		this.editarComentarioEmHistorico(comment);
	}

	/**
	 * Atualiza o texto do comentario editado
	 * @param comment
	 */
	private void editarComentarioEmHistorico(Comentario comment) {

		this.gerDevelopments.editarComentarioEmHistorico(comment, this.getSelectedDevelopment());
	}

	/**
	 * Remove um coment�rio da ferramenta.
	 *
	 * @param comment o coment�rio a ser removido
	 */
	public void removeComment(Comentario comment) {
		RemoveCommentAnswer resposta =
			this.telaDesenvolvimento.removerComentario(comment);
		NoPrograma noProgramaSelected = this.getSelectedProg();

		this.removeIdtComment(noProgramaSelected.getPrograma(), comment);
		/* Removendo Identificadores */


		this.adicionandoRemocaoComentarioAoHistotico(resposta);
		this.esvaziarRedoPilhas();
	}

	public void removeIdtComment(Term term, Comentario comment) {
		/* Removendo Identificadores */
		if (term != null) {

			IdtUtils.removeIdt(term, Identificador.COMENTARIO);
		} else {
			if (comment.getCommentType().equals(CommentsType.COMENTARIO_DE_LEI)) {
				int i = comment.getLinha();
				List<RelationRowLaw> lista = this.retornarPilhaDeLeis();
				for (RelationRowLaw lei : lista) {
					if (lei.getLinha() == i) {
						lei.setIdt(null);
					}
				}
			}
		}
	}

	/**
	 * Remove um coment�rio do CRefine especificando-se as linhas
	 * inicial e final do coment�rio
	 *
	 * @param linhaInicial a linha Inicial do coment�rio
	 * @param linhaFinal a linha Final do coment�rio
	 */
	public void removeComment(int linhaInicial, int linhaFinal) {
		Comentario aRemover =
			this.retornarTelaDesenvolvimento().getComentario(linhaInicial,
					linhaFinal);
		this.removeComment(aRemover);
	}

	/**
	 *
	 * @return Verdadeiro caso haja algum programa em desenvolvimento
	 */
	public boolean hasProgram() {
		return this.telaDesenvolvimento.hasProgram();
	}

	public void inserirIdtComent(Term term, int i) {
		IdtUtils.InsertCommentIdt(term, i);
	}

	/**
	 * Insere o identificador no Termo
	 * @param programa
	 * @param i
	 */
	public void inserirIdt(Term programa, int i, Identificador a) {
		IdtUtils.InsertIdt(i, programa, a);
	}

	/**
	 * Metodo que mexe com as pilhas de programas e de ultimas a��es.
	 * Nao altera nada relacionado a Interface.
	 */
	public void undoToPrintLatex(StringBuffer text) {

		while (!(this.getLastAction() instanceof CarregamentoEspecificacao)
				&& !(this.getLastAction() instanceof CarregamentoSubDesenvolvimento)) {
			this.getLastAction().undoPrintLatexStep(this);
			this.getDevelopment().desfazerPasso();
		}
	}

	/**
	 * Metodo que remove o Idt de coleta de termo
	 * do termo cujo nome esta guardado na string
	 * encontrada no parametro
	 * @param coletado
	 */
	public void removerIdts(TermoColetado coletado) {
		if (coletado.getTipo().equals(TipoColeta.ACAO)) {
			/*Esse arrumadinho serve pra colocar o nome da acao principal na forma default
			 * utilizada no CircusUtils.java*/
			if (coletado.getNome().startsWith(this.getMessage("COD0471"))) {
				coletado.setNome(CircusUtils.DEFAULT_MAIN_ACTION_NAME);
			}
			CollectAnswer resposta =
				this.getGerInterno().coletarCodigoAcao(coletado.getNome(), this.getDevelopment().getProgAtual());
			Term action = resposta.getTermoColetado();
			if (action != null) {
				IdtUtils.removeIdtTermoColetado(action);
			}
		} /*
		 * PROCESS
		 */ else {

			 CollectAnswer resposta =
				 this.getGerInterno().coletarCodigoProcesso(coletado.getNome(), this.getDevelopment().getProgAtual());
			 Term process = resposta.getTermoColetado();
			 if (process != null) {
				 IdtUtils.removeIdtTermoColetado(process);
			 }

		 }
	}

	/**
	 * Metodo que mexe com as pilhas de programas e de ultimas a��es.
	 * Nao altera nada relacionado a Interface.
	 */
	public void redoPrintLatex(int redosize, StringBuffer text) {
		while (this.getSizeOfRedoHistorico() - redosize > 0) {
			this.getRedoLastAction().redoPrintLatexStep(this);
			this.getDevelopment().refazerPasso();
		}
	}

	/**
	 * Metodo que mexe com as pilhas de programas e de ultimas a��es.
	 * Nao altera nada relacionado a Interface. No entanto, retorna os
	 * textos referentes a aplicação de lei, refer�ncia as obrigacoes de
	 * prova, coleta de codigo
	 * @param strText texto em que ser� inserido tais argumentos;
	 * @param redosize- tamanho da pilha de redo antes de ter dado os undos.
	 */
	public void redoPrintLatex(StringBuffer strText, int redosize) {

		int idtLaw = 1;
		while (this.getSizeOfRedoHistorico() - redosize > 0) {
			if (this.getRedoLastAction() instanceof LawApplication) {

				Term prog = this.getDevelopment().getRedoRespostasLeis().peek().getProgResultante();

				DocGenerator printer = new DocGenerator(Text.DESENVOLVIMENTO);
				String[] desText = (String[]) printer.visitTerm(prog);
				String id = natToRom(idtLaw, 0);
				idtLaw++;

				/*
				 * Nome e simbolo da lei a ser reaplicada
				 */
				CircusLaw leiAplicada = retornarRedoTopoLei().getLaw();
				String symbol = id.toUpperCase();
				String nome = leiAplicada.getName();

				Transformation tipo = getType(leiAplicada);

				/*Tipos de LEI : Equivalencia, Simul�ao ou Refinamento*/
				if (tipo.equals(Transformation.Equivalence)) {
					symbol += " =  ";
				} else if (tipo.equals(Transformation.Refinement)) {
					symbol += " \\circrefines";
				} else {
					symbol += " \\circsimulates";
				}
				symbol += " \\t1 " + "\"" + nome + "\"";

				if (retornarRedoTopoLei().getIdt() != null) {
					symbol += " \\t1 C(" + retornarRedoTopoLei().getIdt().getIdt() + ")";
				}

				strText.append("\\begin{circus}\n");
				strText.append(symbol + " \\\\ \n");
				strText.append("\\end{circus}\n");

				strText.append("\\begin{circus}  \n");

				for (int i = 0; i < desText.length; i++) {
					if (desText[i].endsWith("\\\\")) {
						strText.append("\\t1  " + desText[i] + "\n");
					} else {
						strText.append("\\t1  " + desText[i] + "  \\\\ " + "\n");
					}
				}
				strText.append("\\end{circus}  \n\n");

				this.getRedoLastAction().redoPrintLatexStep(this);

			} else if (this.getRedoLastAction() instanceof Coleta) { //Ou seja redolastaction == 2 (Ação Coletada || Processo Coletado)

				this.gerInterno.retornarActionsPara(this.retornarProgAtual());//Atualiza campo ActionsPara
				this.gerInterno.retornarProcessPara(this.retornarProgAtual());

				Term aColetar = null;

				if (!((Coleta) this.getRedoLastAction()).getTipo().equals(TipoColeta.TERMO_INICIAL)) {
					if (this.getDevelopment().getRedoAcoesColetadas().peek().getTipo().equals(TipoColeta.ACAO)) {
						String nome = this.getDevelopment().getRedoAcoesColetadas().peek().getNome();
						if (nome.startsWith(this.getMessage("COD0471"))) {
							nome = CircusUtils.DEFAULT_MAIN_ACTION_NAME;
						}
						CollectAnswer resposta =
							this.getGerInterno().coletarCodigoAcao(nome, this.retornarProgAtual());
						aColetar = resposta.getTermoColetado();
					} else {
						String nome = this.getDevelopment().getRedoAcoesColetadas().peek().getNome();
						CollectAnswer resposta =
							this.getGerInterno().coletarCodigoProcesso(nome, retornarProgAtual());
						aColetar = resposta.getTermoColetado();
					}
				} else {
					aColetar = this.retornarProgAtual();

				}
				if (aColetar != null) {
					DocGenerator printer = new DocGenerator(Text.DESENVOLVIMENTO);
					String[] desText = (String[]) printer.visitTerm(aColetar);
					strText.append("\\t1 \\t1   " + this.getMessage("COD0539") + "\n");
					strText.append("\n\\begin{circus}  \n");
					for (int i = 0; i < desText.length; i++) {
						if (desText[i].endsWith("\\\\")) {
							strText.append("\\t1  " + desText[i] + "\n");
						} else {
							strText.append("\\t1  " + desText[i] + "  \\\\ " + "\n");
						}
					}
					strText.append("\\end{circus}  \n\n");
				}

				this.getRedoLastAction().redoPrintLatexStep(this);
			} else {
				this.getRedoLastAction().redoPrintLatexStep(this);
			}

			this.getDevelopment().refazerPasso();
		}
		if (this.isAplicTatica()){
			/*
			 * E uma aplicacao de tatica
			 */
			Tatica taticaAplicada = this.getTaticaFinal();
			RCell rCellFinal = this.getrCellFinal();
			String id = natToRom(idtLaw, 0);
			idtLaw++;
			String symbol = id.toUpperCase();
			
			DocGenerator printer = new DocGenerator(Text.DESENVOLVIMENTO);
			String[] desText = (String[]) printer.visitTerm(rCellFinal.getNoPrograma().getPrograma());
			
			symbol += " \\t1 " + "\"" + "Tactic: " + taticaAplicada.getId() + "\"";
				
			strText.append("\\begin{circus}\n");
			strText.append(symbol + " \\\\ \n");
			strText.append("\\end{circus}\n");
			
			strText.append("\\begin{circus}  \n");

			for (int i = 0; i < desText.length; i++) {
				if (desText[i].endsWith("\\\\")) {
					strText.append("\\t1  " + desText[i] + "\n");
				} else {
					strText.append("\\t1  " + desText[i] + "  \\\\ " + "\n");
				}
			}
			strText.append("\\end{circus}  \n\n");

			
		}
	}

	/**
	 * Imprime as OPs para gerar no arquivo de saida de impressao
	 * @param formatoExpandido formato em que as OPs devem ser expressas.
	 * true -> Expandido
	 * false -> Resumido
	 * @param num n�mero ideal de paginhas
	 * @return Uma LinkedList contendo a impressao de cada OP no formato selecionado
	 */
	public LinkedList<String> generatePOinDoc(boolean formatoExpandido, int num) {

		/* Identificador de PO*/
		int idt = 1;

		String beginTab = "\\begin{tabular}{|c|c|l|}";
		String fimTab = "\\end{tabular}";
		String hline = "\\hline";

		//Contador de Linhas;
		int contLinhas = 0;
		LinkedList<String> result = new LinkedList<String>();
		DocGenerator printer = new DocGenerator(Text.ESPECIFICACAO_ORIGINAL);

		LinkedList<ObrigacaoProva> oProvas = this.telaObrigacao.getOps();
		for (ObrigacaoProva op : oProvas) {
			String[] res = null;
			if (formatoExpandido) {
				if (op.getExtendido() != null) {
					res = (String[]) printer.visitTerm(op.getExtendido());
				} else {
					res = (String[]) printer.visitTerm(op.getPredicado());
				}
			} else {
				res = (String[]) printer.visitTerm(op.getPredicado());
			}
			//Verificando se
			if (res.length + contLinhas > num) {
				result.add(hline);
				result.add(fimTab);
				result.add("\\newpage");
				result.add(beginTab);
				contLinhas = res.length;
			} else {
				contLinhas += res.length;
			}

			result.add(hline);
			String identificador = NatToRoman.natToRom(idt, 0);
			identificador = identificador.toUpperCase();
			//Verifica o tipo de OP para imprimir o status corretamente
			if (op.getTipo().equals(OPTipos.OP_CHECADA_TRUE)) {
				result.add("\\textbf{" + identificador + "}" + " & "
						+ "  \\checkedtrue  &");
			} else if (op.getTipo().equals(OPTipos.OP_CHECADA_FALSE)) {
				result.add("\\textbf{" + identificador + "}" + " & "
						+ " \\checkedfalse  &");
			} else if (op.getTipo().equals(OPTipos.OP_MANUAL_CHECADA_TRUE)) {
				result.add("\\textbf{" + identificador + "}" + " & "
						+ " \\manualchecktrue  &");
			} else if (op.getTipo().equals(OPTipos.OP_MANUAL_CHECADA_FALSE)) {
				result.add("\\textbf{" + identificador + "}" + " & "
						+ " \\manualcheckfalse  &");
			} else {
				result.add("\\textbf{" + identificador + "}" + " & "
						+ " ? &");
			}
			result.add("$ \\begin{block}");
			idt++;
			for (int j = 0; j < res.length; j++) {

				if (!res[j].endsWith("\\\\")) {
					result.add("\\t1  " + res[j] + " \\\\");
				} else {
					result.add("\\t1  " + res[j]);
				}
			}
			result.add("\\end{block} $ \\\\		");
			result.add("");
		}

		return result;
	}

	public LinkedList<String> generateListCommentsInDoc() {

		LinkedList<String> result = new LinkedList<String>();
		List<Comentario> comments = telaDesenvolvimento.getComentarios();

		if (comments.size() > 0) {
			result.add("\\begin{enumerate} ");

			for (Comentario com : comments) {

				result.add("\\item");

				String[] text = com.getTexto().split("\n");
				for (int i = 0; i < text.length; i++) {
					result.add("\\t1 " + text[i] + " \\\\");
				}
				result.add("\\\\");
				result.add("\\\\");
			}

			result.add("\\end{enumerate} ");
		}
		return result;
	}

	public void AtualizarComentariosUtils() {
		ComentariosUtils.setComments(telaDesenvolvimento.getComentarios());
	}

	/**
	 * Metodo que altera na listas de historico, as linhas de aplicacoes
	 * de lei e de comentarios
	 * @param termosApli
	 */
	public void atualizarHistorico(Stack<Term> termosApli, Markup marca) {
		java.util.ListIterator<StepOfExecution> lista = getDevelopment().getPassos().getIterator();
		if (this.getSizeOfHistorico() != 0) {
			StepOfExecution inicio;
			inicio = lista.next();
			if (inicio instanceof CarregamentoEspecificacao) {
				((CarregamentoEspecificacao) inicio).setMarkupInicial(marca);
			}
			for (Term termo : termosApli) {
				RelationsAnn rel = RelationsUtils.retornarTopo(
						ExternalManager.getRealTerm(termo));
				StepOfExecution passo;
				boolean aux = true;

				while (lista.hasNext() && aux) {

					passo = lista.next();
					if (passo instanceof LawApplication) {
						((LawApplication) passo).setarLinhas(rel.getLinhaInicial(), rel.getLinhaFinal());
						aux = false;
					} else if (passo instanceof AdicaoComentario) {
						int identificador = ((AdicaoComentario) passo).getIdentificador();
						Comentario comment = this.getComentario(identificador);
						((AdicaoComentario) passo).setLinhaInicial(comment.getLinha());
						((AdicaoComentario) passo).setLinhaFinal(comment.getLinhaFinal());
					} else if (passo instanceof RemocaoComentario) {
						int identificador = ((RemocaoComentario) passo).getIdentificador();
						Comentario comment = this.getComentarioRemovido(identificador);
						((RemocaoComentario) passo).setLinhaInicial(comment.getLinha());
						((RemocaoComentario) passo).setLinhaFinal(comment.getLinhaFinal());
					}
				}
			}
			StepOfExecution passo;
			while (lista.hasNext()) {
				passo = lista.next();
				if (passo instanceof AdicaoComentario) {
					int identificador = ((AdicaoComentario) passo).getIdentificador();
					Comentario comment = this.getComentario(identificador);
					((AdicaoComentario) passo).setLinhaInicial(comment.getLinha());
					((AdicaoComentario) passo).setLinhaFinal(comment.getLinhaFinal());
				}
				if (passo instanceof RemocaoComentario) {
					int identificador = ((RemocaoComentario) passo).getIdentificador();
					Comentario comment = this.getComentarioRemovido(identificador);
					((RemocaoComentario) passo).setLinhaInicial(comment.getLinha());
					((RemocaoComentario) passo).setLinhaFinal(comment.getLinhaFinal());
				}
			}

		}


	}

	/**
	 * Metodo que retorna o comentario removido passando
	 * o identificador do mesmo como parametro
	 * @param identificador
	 * @return
	 */
	private Comentario getComentarioRemovido(int identificador) {
		Stack<Comentario> coms = this.retornarTelaDesenvolvimento().getRemovedComments();
		for (Comentario com : coms) {
			if (com.getIdentificador() == identificador) {
				return com;
			}
		}
		return null;
	}

	/**
	 * Metodo que retorna o comentario com indentificador passado
	 * como paramentro
	 * @param identificador
	 * @return
	 */
	private Comentario getComentario(int identificador) {
		ArrayList<Comentario> coms = this.retornarTelaDesenvolvimento().getComentarios();
		Comentario result;
		for (Comentario com : coms) {
			if (com.getIdentificador() == identificador) {
				result = com;
				return result;
			}
		}
		return null;
	}

	/**
	 * Metodo que retonar a raiz da arvore de leis
	 * @param leis lista de leis
	 * @return
	 */
	public NodeHierarchyLaws retornarRaizdeLeis(List<CircusLaw> leis) {
		return (new HierarchyLawsTree(this, leis)).getRaiz();
	}

	public void inicializarMenuDeLeis(JMenu menu, ActionListener action) {
		List<CircusLaw> leis = this.getLaws();
		NodeHierarchyLaws nodo = this.retornarRaizdeLeis(leis);
		this.adicionandoNodo(nodo, menu, action);
	}

	public void adicionandoNodo(NodeHierarchyLaws nodo, JMenu menu, ActionListener action) {
		if (nodo.isTypeLaw()) {
			menu.setText(nodo.getName());
			for (NodeHierarchyLaws filho : nodo.getFilhos()) {
				if (filho.isTypeLaw()) {
					JMenu novoMenu = new JMenu(filho.getName());
					menu.add(novoMenu);
					adicionandoNodo(filho, novoMenu, action);
				} else {
					adicionandoNodo(filho, menu, action);
				}
			}

		} else {
			JMenuItem lei = new JMenuItem(nodo.getName());
			lei.addActionListener(action);
			menu.add(lei);
		}
	}

	/**
	 * Metodo que retorna o comprimento da lista de historico
	 * @return
	 */
	public int getSizeOfHistorico() {
		int index = this.telaDesenvolvimento.getSelectedDevelopment();
		if (index != -1) {
			return this.gerDevelopments.getDevelopment(index).getSizeOfHistorico();
		} else {
			return -1;
		}
	}

	/**
	 * Metodo que retorna o comprimento da lista de Redo historico
	 * @return
	 */
	public int getSizeOfRedoHistorico() {
		int index = this.telaDesenvolvimento.getSelectedDevelopment();
		if (index != -1) {
			return this.gerDevelopments.getDevelopment(index).getSizeOfRedoHistorico();
		}
		return -1;

	}

	/**
	 * Retorna a ultima acao do programa
	 * @return
	 */
	public StepOfExecution getLastAction() {
		return this.getDevelopment().getLastAction();
	}

	/**
	 * Retorna a ultima acao das acoes desfeitas durante
	 * execucao do programa
	 * @return
	 */
	public StepOfExecution getRedoLastAction() {
		return this.getDevelopment().getRedoLastAction();
	}

	/**
	 * Verifica se o historico de Redo encontra-se vazio
	 * @return
	 */
	public boolean isRedoHistoricoEmpty() {
		return this.getDevelopment().isRedoHistoricoEmpty();
	}

	/**
	 * Metodo que chama o desfazer do gerenciador Interno.
	 * Utilizado no Desfazer de uma Aplicação de Lei
	 */
	public void desfazerInterno() {
		this.getDevelopment().desfazerInterno();
	}


	/**
	 * Metodo que chama o desfazerTatica do gerenciador Interno.
	 * Utilizado no Desfazer de uma Aplicação de Lei
	 */
	public void desfazerInternoTatica() {
		this.getDevelopment().desfazerInternoTatica();
	}

	/**
	 * Metodo que chama o refazer do gerenciador Interno.
	 * Utilizado no Refazer de uma Aplicação de Lei
	 */
	public void refazerInterno() {
		this.getDevelopment().refazerInterno();
	}

	/**
	 * Metodo que atualiza a tela Codigo, mediante alguma
	 * mudanca na arvore corrente.
	 * @param id identificador do desenvolvimento
	 */
	public void atualizarTelaCodigo(int id) throws CRefineException {
		try {
			if (this.getDevelopment(id).getProgAtual() != null) {
				this.telaCodigoAtual.setarTela(this.getDevelopment(id).getProgAtual());
			}
		} catch (Exception except) {
			except.printStackTrace();
			CRefineException e = new CRefineException(except, except.getMessage());
			throw e;
		}
	}

	/**
	 * Metodo que atualiza a tela Codigo, mediante alguma
	 * mudanca na arvore corrente.
	 */
	public void atualizarTelaCodigo() throws CRefineException {
		try {
			int id = telaDesenvolvimento.getSelectedDevelopment();
			if (this.getDevelopment(id).getProgAtual() != null) {

				this.telaCodigoAtual.setarTela(this.getDevelopment(id).getProgAtual());
				this.telaCodigoAtual.setFilePath(this.filePath);
			}
		} catch (Exception except) {
			except.printStackTrace();
			CRefineException e = new CRefineException(except, except.getMessage());
			throw e;
		}
	}

	/**
	 * Atualiza as opcoes de termos que podem ser coletados.
	 * Normalmente isso ocorre quando ha alguma mudanca na AST
	 * e possivelmente novos termos sao gerados.
	 */
	public void atualizarOpcoesColeta() {
		if (telaPrincipal.getOption().equals(TipoColeta.ACAO)) {
			this.updateActionTerms();
		} else if (telaPrincipal.getOption().equals(TipoColeta.PROCESSO)) {
			this.updateProcessTerms();
		} /* SUBDESENVOLVIMENTO*/ else {
			List<String> nomes = new LinkedList<String>();
			this.telaPrincipal.listarNomesTermsPara(nomes);
		}
	}

	/**
	 * Metodo que verifica se ha alguma OP a ser desfeita.
	 * Caso haja ele ja chama o metodo responsavel para desfaze-la(s)
	 * Como o metodo desfazer nao usara mais a pilha de Resposta lei,
	 * esta j� eatualizada.
	 */
	public void desfazerTelaObri_RespostaLei() {
		//Atualizando a tela Obrigação
		if (!this.getDevelopment().getRespostasLeis().isEmpty()) {
			if (this.getDevelopment().getRespostasLeis().peek().getOps().size() != 0) {
				IdtUtils.removeIdt(getTermosAplicados().peek(), Identificador.OBRIGACAO);
				this.telaObrigacao.desfazer(this.getDevelopment().getRespostasLeis().peek().getOps().size());
			}
		}
	}

	public void desfazerPilhas() {
		this.getDevelopment().desfazerPilhas();
	}

	/**
	 * Desfaz as ultimos relacionamentos, associado a termos
	 * que foram coletados e posteriormente essas coletas foram
	 * desfeitas.
	 */
	public void desfazerUltimasRelacoes_Idts() {
		this.desfazerRelacoes(getDevelopment().getUndoAcoesColetadas().peek());
		this.removerIdts(getDevelopment().getUndoAcoesColetadas().peek());
		this.desceRoll();
	}

	public void DesfazendoPilhaTermosColetados() {
		this.getDevelopment().desfazerPilhaTermosColetados();
	}

	/**
	 * Realiza a reaplicação de uma lei, reinserindo algumas OPs,
	 * atualizando identificadores e atualiza algumas pilhas.
	 */
	public void reaplicarLei() {
		this.telaDesenvolvimento.reappplyScreen(getDevelopment().getRedoRespostasLeis().peek().getProgResultante());
		if (getDevelopment().getRedoRespostasLeis().peek().getOps().size() != 0) {
			LinkedList<ObrigacaoProva> obrigs = this.montarListaOPs(
					this.getDevelopment().getRedoRespostasLeis().peek(), this.getDevelopment().retornarRedoPilhaDeLeis().peek().getLinha());
			this.telaObrigacao.listarObrigacoes(obrigs);
			IdtUtils.InsertIdt(telaObrigacao.getIdentificador(), getRedoTermosAplicados().pop(), Identificador.OBRIGACAO);
		} else {
			//Atualiza Pilha de Termos Aplicados
			getRedoTermosAplicados().pop();
		}
	}


	/**
	 * Realiza a reaplicação de uma tatica, reinserindo algumas OPs,
	 * atualizando identificadores e atualiza algumas pilhas.
	 */
	public void reaplicarTatica() {
		this.telaDesenvolvimento.reappplyScreen(getDevelopment().getRedoRespostasLeis().peek().getProgResultante());
		if (getDevelopment().getRedoRespostasLeis().peek().getOps().size() != 0) {
			LinkedList<ObrigacaoProva> obrigs = this.montarListaOPs(
					this.getDevelopment().getRedoRespostasLeis().peek(), this.getDevelopment().retornarRedoPilhaDeLeis().peek().getLinha());
			this.telaObrigacao.listarObrigacoes(obrigs);
			IdtUtils.InsertIdt(telaObrigacao.getIdentificador(), getRedoTermosAplicados().pop(), Identificador.OBRIGACAO);
		} else {
			//Atualiza Pilha de Termos Aplicados
			getRedoTermosAplicados().pop();
		}
	}


	/**
	 * Refaz Pilhas de Leis
	 *
	 */
	public void refazerPilhasLeis() {
		this.getDevelopment().refazerPilhasLeis();
	}

	/**
	 *
	 * @return O Programa atual do desenvolvimento selecionado
	 */
	public Term retornarProgAtual() {

		int id = telaDesenvolvimento.getSelectedDevelopment();
		return gerDevelopments.getDevelopment(id).getProgAtual();
	}

	public boolean isMundandoFormato() {
		return mundandoFormato;
	}

	public void setMundandoFormato(boolean mundandoFormato) {
		this.mundandoFormato = mundandoFormato;
	}

	/**
	 * Realiza o Refazer de uma Coleta de Codigo
	 */
	public void refazerColeta() {
		if (this.getDevelopment().getRedoAcoesColetadas().peek().getTipo().equals(TipoColeta.ACAO)) {

			this.coletarCodigoAcao(getDevelopment().getRedoAcoesColetadas().pop().getNome());
		} else {
			this.coletarCodigoProcesso(getDevelopment().getRedoAcoesColetadas().pop().getNome());
		}
		this.retornarTelaPrincipal().habilitarUndo();
		//this.refazerRelacoes(this.telaPrincipal.getRedoAcoesColetadas().peek());

	}

	/**
	 * Adicionao o passo de uma atribuicao de valor verdade
	 * feita pelo usuario a alguma OP ao historico
	 * @param opTipo valor atribuido
	 * @param selection indice da OP
	 */
	public void adicionandoSetValorOPHistorico(OPTipos opTipo,
			OPTipos tipoAnterior, int selection) {
		SetandoStatusOp setou = new SetandoStatusOp(tipoAnterior, opTipo, selection);
		this.adicionandoHistorico(setou);
	}

	/**
	 * Adicionao o passo de uma atribuicao de valor verdade
	 * ao pai de um refinamento utilizado para provar uma
	 * Obrigacao de Prova
	 * @param opTipo valor atribuido
	 * @param selection indice da OP
	 * @param pai indice do pai
	 */
	public void adicionandoSetValorOPHistorico(int pai, OPTipos opTipo,
			OPTipos tipoAnterior, int selection) {
		SetandoStatusOp setou = new SetandoStatusOp(tipoAnterior, opTipo, selection);
		this.getDevelopment(pai).adicionarHistorico(setou);

	}

	/**
	 * Adiciona passo de execução a lista de historico
	 * @param passo passo de execucao do programa
	 */
	public void adicionandoHistorico(StepOfExecution passo) {
		this.getDevelopment().adicionarHistorico(passo);
	}

	/**
	 * Muda o formato de exibicao de uma OP
	 * @param indiceOP indice da Op que foi alterada
	 */
	public void mudarFormatoImpressaoOP(int indiceOP, boolean inserirHistorico) {
		this.telaObrigacao.mudarFormatoImpressaoOP(indiceOP, inserirHistorico);
	}

	/**
	 * Retira o identificador de aplicacao de Lei recentemente inserido.
	 * Identificador que eutilizado no docgenerator
	 *
	 */
	public void desfazerIdentificadorLei() {
		//Anit
		IdtUtils.removeIdt(getTermosAplicados().peek(), Identificador.LEI);
	}



	/**
	 * Retira o identificador de aplicacao da Tatica recentemente inserido.
	 * Identificador que eutilizado no docgenerator
	 *
	 */
	//Ver quando não for uma aplicação de lei
	//o que essa getTermosAplicados().peek() terá?
	public void desfazerIdentificadorTatica() {
		IdtUtils.removeIdt(getTermosAplicados().peek(), Identificador.TATICA);
	}
	/**
	 * M�todo que fesfaz as acoes ate o carregamento
	 * do programa inicial. Utilizado no Unicode/Latex
	 */
	public void desfazerAteOriginal() throws CRefineException, CRulesException {
		while (this.getDevelopment().getSizeOfHistorico() > 0) {
			this.desfazer();
			this.telaPrincipal.incrementProgress();
		}
	}

	/**
	 * M�todo que realizar um refazer ate o ultimo passo
	 * antes de ser efetuado a mudanca de formato Unicode/Latex
	 */
	public void refazerTudo(int quantRefaz) throws CRulesException, CRefineException {
		while (this.getDevelopment().getSizeOfRedoHistorico() != 0 && quantRefaz > 0) {
			quantRefaz--;
			this.refazer();
			this.telaPrincipal.incrementProgress();
		}

	}

	public int getLinhaLastLawApplication() {
		return ((LawApplication) this.gerDevelopments.getDevelopment(this.getSelectedDevelopment()).getPassos().getHistorico().getLast()).linhas()[0];
	}

	public int getLinhaRedoLastLawApplication() {
		return ((LawApplication) this.gerDevelopments.getDevelopment(this.getSelectedDevelopment()).getPassos().getRedoList().getLast()).linhas()[0];
	}

	/**
	 * Metodo que realiza a insercao de um novo paragrafo
	 * no programa
	 * @throws CancelledApplException
	 * @throws ParseArgumentException
	 */
	public void insertNewParagrah() throws CRefineException, CRulesException {
		String textParagraph;

		/* Pega a string representando o argumento */
		TelaParametro telaParametro = new TelaParametro(this);
		telaParametro.mostrarTelaPara("P");
		textParagraph = telaParametro.getArgument();
		if (textParagraph == null) {
			throw new CancelledInsertionOfParaExceptionn();
		}
		parsingParagraphAndDisplay(textParagraph);

		InsertParagraph passo = new InsertParagraph(textParagraph);
		this.adicionandoHistorico(passo);

	}

	public void parsingParagraphAndDisplay(String textParagraph) throws CRefineException, CRulesException {
		InsertAnswer resposta = this.gerInterno.insertParagraph(textParagraph);
		this.retornarTelaDesenvolvimento().displayParagraph(resposta);
	}

	public void desfazerInsertedParagraph(String text) throws SpecificationEditorException, CRulesException {
		this.retornarTelaDesenvolvimento().retirarUltimasLinhas();
		gerInterno.removeParagraph(text);
	}

	public void copiarTextoSelecionado() {

		retornarTelaDesenvolvimento().selecionarLinhas();
		ArrayList<String> texto = retornarTelaDesenvolvimento().getTextoSelecionado();
		String toCopy = "";
		for (int i = 0; i < texto.size(); i++) {
			toCopy += texto.get(i) + "\n";
		}

		StringSelection data = new StringSelection(toCopy);
		java.awt.Toolkit.getDefaultToolkit().getSystemClipboard().setContents(data, data);
	}

	/**
	 * Metodo que realiza a insercao de um passo na lista de
	 * historicos
	 * @param passo
	 */
	public void inserirPassoHistorico(StepOfExecution passo) {
		this.adicionandoHistorico(passo);
	}

	/**
	 *
	 * @return o Formato de Texto do Desenvolvimento Selecionado
	 */
	public Markup getMark() {
		return this.telaPrincipal.getMarkUp();
	}

	/**
	 *
	 * @param id indice da aba
	 */
	public void atualizarTelaObrigacoes() {
		this.telaObrigacao.updateScreen();
	}

	/**
	 *
	 * @return Se o desenvolvimento em quest�o eo primeiro
	 */
	public DevelopmentTree getDevelopment(int id) {
		return gerDevelopments.getDevelopment(id);
	}

	/**
	 * Requisita a atualização do panel do
	 * Desenvolvimento i
	 * @param id indice do desenvolvimento
	 */
	public void updateScreen(int id) {
		this.telaDesenvolvimento.updateScreen(id);
	}

	/**
	 * Requisita a remoção do desenvolvimento indexado por tabNumber
	 * @param tabNumber n�mero identificador do Desenvolvimento
	 */
	public void removeDevelopment(int tabNumber) {

		this.gerDevelopments.removeDevelopment(tabNumber);
	}

	/**
	 * Limpa a Tela C�digo
	 *
	 */
	public void limparTelaCodigo() {
		this.telaCodigoAtual.novaTela(this);
		this.telaCodigoAtual.setFilePath(""); //By Samuel Barrocas
	}

	/**
	 *
	 * @return as Linhas Selecionadas do Desenvolvimento Selecionado
	 */
	public int[] retornarLinhasSelecionadas() {
		return this.telaDesenvolvimento.retornarLinhasSelecionadas();
	}

	/**
	 *
	 * @param i linha inicial
	 * @param j linha final
	 * @return O programa referente
	 */
	public NoPrograma retornarProgramaSelecionado(int i, int j) {
		int id = telaDesenvolvimento.getSelectedDevelopment();
		return this.retornarProgramaSelecionado(id, i, j);
	}

	/**
	 *
	 * @param i
	 * @param j
	 * @return se h� coment�rio na linha selecionada
	 */
	public boolean temComentario(int i, int j) {
		return telaDesenvolvimento.temComentario(i, j);
	}

	/**
	 * Atualiza a Tela Selecionada
	 *
	 */
	public void updateScreen() {
		this.telaDesenvolvimento.updateSelectedScreen();
	}

	/**
	 * Limpa opcoes de Coleta
	 *
	 */
	public void limparOpcoesColeta() {
		this.telaPrincipal.limparOpcoesColeta();
	}

	/**
	 * Atualiza identificador de Lei do texto da aba Selecionada
	 * @param b caso esse m�todo tenha sido invocado numa ação de undo
	 */
	public void updateLawIdentifierGUI(boolean b) {
		this.telaDesenvolvimento.updateLawIdentifierGUI(b);
	}

	/**
	 *
	 * @return O indice do desenvolvimento selecionado
	 */
	public int getSelectedDevelopment() {
		return this.telaDesenvolvimento.getSelectedDevelopment();
	}

	/**
	 *
	 * @return O topo de lei da pilha de Relation Row do Desenvolvimento
	 * que est� selecionado
	 */
	public RelationRowLaw retornarTopoLei() {
		int id = this.getSelectedDevelopment();
		return gerDevelopments.getDevelopment(id).retornarTopoLei();
	}


	/**
	 *
	 * @return O topo de tatica da pilha de Relation Row do Desenvolvimento
	 * que esta selecionado
	 */
	public RelationRowLaw retornarTopoTatica() {
		int id = this.getSelectedDevelopment();
		return gerDevelopments.getDevelopment(id).retornarTopoTatica();
	}

	/**
	 *
	 * @return Pilha Redo de Termos Aplicados do Desenvolvimento Selecionado
	 */
	public Stack<Term> getRedoTermosAplicados() {
		int id = this.getSelectedDevelopment();
		return gerDevelopments.getDevelopment(id).getRedoTermosAplicados();
	}

	/**
	 *
	 * @return Pilha de Termos Aplicados do Desenvolvimento em quest�o
	 */
	public Stack<Term> getTermosAplicados() {
		int id = this.getSelectedDevelopment();
		return gerDevelopments.getDevelopment(id).getTermosAplicados();
	}

	/**
	 *
	 * @return Retorna Pilha Redo de Relação Linha Lei do Desenvolvimento selecionado
	 */
	public RelationRowLaw retornarRedoTopoLei() {
		int id = this.getSelectedDevelopment();
		return gerDevelopments.getDevelopment(id).retornarRedoTopoLei();
	}

	/**
	 *
	 * @return Retorna Pilha Redo de Relação Linha Tatica do Desenvolvimento selecionado
	 */
	public RelationRowLaw retornarRedoTopoTatica() {
		int id = this.getSelectedDevelopment();
		return gerDevelopments.getDevelopment(id).retornarRedoTopoTatica();
	}

	public List<RelationRowLaw> retornarPilhaDeLeis() {
		int id = this.getSelectedDevelopment();
		return gerDevelopments.getDevelopment(id).retornarPilhaDeLeis();
	}

	public void adicionarTermoColetado(TermoColetado newTerm) {
		this.getDevelopment().adicionarTermoColetado(newTerm);
	}

	/**
	 *
	 * @return true caso seja um subdesenvolvimento que se j�
	 * obteve o target
	 */
	public boolean isPODevelopmentProved() {
		boolean poProved = false;
		if (this.isPODevelopment()) {
			poProved = ((PODevelopmentTree) this.getDevelopment()).isProved();
		}
		return poProved;
	}

	/**
	 * Verifica se o desenvolvimento selecionado
	 * pode ter as funcionalidades de Desfazer e Refazer
	 * habilitadas e qual a marca utilizada: Unicode ou Latex
	 *
	 */
	public void atualizarOpcoes() {
		boolean canUndo = false;
		boolean canRedo = false;
		Markup marca = Markup.LATEX;
		/* > 1 pois tem o carregamento inicial que nao pode ser desfeito*/
		/** Verifica se eum subdesenvolvimento bloqueado */
		if (isPODevelopmentProved()) {
			this.telaDesenvolvimento.bloquearDesenvolvimento();
		} else {
			this.telaDesenvolvimento.liberarDesenvolvimento();
		}

		if (getDevelopment().getSizeOfHistorico() > 1) {
			canUndo = true;
		}
		if (getDevelopment().getSizeOfRedoHistorico() > 0) {
			canRedo = true;
		}
		if (getDevelopment().getMarkUp().equals(Markup.UNICODE)) {
			marca = Markup.UNICODE;
		}

		this.telaPrincipal.atualizarOpcpes(canUndo, canRedo, marca);
	}

	/**
	 * Desabilita Desfazer, Refazer.
	 *
	 */
	public void limparOpcoes() {
		telaPrincipal.limparOpcoes();
	}

	/**
	 * Seleciona a linha passada como par�metro do
	 * Desenvolvimento utilizado
	 * @param toSelect linha a ser selecionada
	 */
	public void selecionarLinha(int toSelect) {
		this.telaDesenvolvimento.selecionarLinha(toSelect);
	}

	/**
	 * Ajusta o panel para exibir a linha selecioanda
	 * @param toSelect Linha selecionada
	 */
	public void normalizarSelecao(int toSelect) {
		this.telaDesenvolvimento.normalizarSelecao(toSelect);

	}

	/**
	 * Muda a seleção da aba na tela Obrigação para que
	 * corresponda com a aba selecionada na Tela Desenvolvimento
	 * @param id id da aba selecionada
	 */
	public void mudarAbaObri(int id) {
		this.telaObrigacao.mudarAba(id);

	}

	/**
	 * Muda a seleção da aba na tela Desenvolvimento para que
	 * corresponda com a aba selecionada na Tela Obrigação
	 * @param id id da aba selecionada
	 */
	public void mudarAbaODes(int id) {
		this.telaDesenvolvimento.selecionarAba(id);
	}

	/**
	 * Pega o comentario do desenvolvimento em quest�o
	 * cuja linha inicial ei a linha final ej
	 * @param i linha inicial do comentario
	 * @param j linha final do comentario
	 * @return comentario selecionado
	 */
	public Comentario getComentario(int i, int j) {
		return telaDesenvolvimento.getComentario(i, j);
	}

	/**
	 * desfaz a inserção do �ltimo coment�rio
	 *
	 */
	public void desfazerAdicaoComentario() {
		telaDesenvolvimento.desfazerAdicaoComentario();
	}

	/**
	 * refaz a inserção do �ltimo coment�rio
	 *
	 */
	public void refazerAdicaoComentario() {
		telaDesenvolvimento.refazerAdicaoComentario();

	}

	/**
	 * Desfaz a remoção do �ltimo Coment�rio
	 *
	 */
	public void desfazerRemocaoComentario() {
		telaDesenvolvimento.desfazerRemocaoComentario();
	}

	/**
	 * Refaz a remoção do �ltimo Coment�rio
	 *
	 */
	public void refazerRemocaoComentario() {
		telaDesenvolvimento.refazerRemocaoComentario();

	}

	public void setMarkUp(Markup mark) {
		this.getDevelopment().setMarkUp(mark);
	}

	/**
	 * Faz com que a tela Obrigação remova a tab indexada
	 * pelo indice tabNumber
	 * @param tabNumber numero da aba a ser removida
	 */
	public void removeAbaObri(int tabNumber) {
		this.telaObrigacao.removeAbaObri(tabNumber);
	}

	public int getDevelopmentsCount() {
		return gerDevelopments.getSize();
	}

	public void desfazerRespostasLeis() {
		this.getDevelopment().desfazerRespostasLeis();
	}

	public void desfazerPilhaDeLeis() {
		this.getDevelopment().desfazerPilhaDeLeis();

	}

	public void refazerRespostasLeis() {
		getDevelopment().refazerRespostasLeis();

	}

	public void refazerPilhaDeLeis() {
		getDevelopment().refazerPilhaDeLeis();

	}

	public void refazerAcoesColetadas() {
		getDevelopment().refazerAcoesColetadas();

	}

	public void desfazerAcoesColetadas() {
		getDevelopment().desfazerAcoesColetadas();

	}

	/**
	 * Pergunta ao usu�rio se o mesmo deseja
	 * @return se foi ou n�o selecionado a opção de fechar o desenvolvimento
	 */
	public boolean askforSaveDevelopment(boolean toQuit) {
		return this.telaPrincipal.askforSaveDevelopment(toQuit);
	}

	public String getDevelopmentName() {
		return getDevelopment().getNome();
	}

	public void fecharAbas() {
		telaDesenvolvimento.fecharAbas();
	}

	/**
	 * Cria um novo subdesenvolvimento a partir de uma obrigacao de Prova de
	 * um desenvolvimento pai
	 * @param opSelecionada Obrigacao de Prova que gera o SubDesenvolvimento
	 * @param nomeDes
	 */
	public int iniciarSubDesenvolvimento(ObrigacaoProva opSelecionada, int indiceOP, String nomeDes) {

		Integer indexDev = this.getSelectedDevelopment();

		Term origem = null;
		Term destino = null;

		if (opSelecionada.getPredicado() instanceof ActionTransformerPred) {
			origem = ((ActionTransformerPred) opSelecionada.getPredicado()).getSpec();
			destino = ((ActionTransformerPred) opSelecionada.getPredicado()).getImpl();
		} else /* instance of ProcessTRansformerPRed*/ {
			origem = ((ProcessTransformerPred) opSelecionada.getPredicado()).getSpec();
			destino = ((ProcessTransformerPred) opSelecionada.getPredicado()).getImpl();
		}
		Markup marca = this.getMark();

		String name = this.getDevelopmentName();
		name = name + "-" + this.getMessage("COD0735") + "#" + indiceOP;

		PODevelopmentTree subDev = new PODevelopmentTree(name, marca, origem, destino, opSelecionada, indexDev, indiceOP);
		int id = gerDevelopments.inserirNovoSubdesenvolvimento(this.getDevelopmentName(), subDev, indexDev, nomeDes);
		telaDesenvolvimento.adicionarNovoDesenvolvimento(id);
		telaObrigacao.adicionarNovoObrigacao(id);
		return id;

	}

	/**
	 * Carrega o programa inicial de um subdesenvolvimento
	 * @param nomePai nome do desenvolvimento pai
	 * @param programaInicial programa inicial de um subdesenvolvimento
	 * @throws CRefineException
	 */
	public void openSpecification(String nomePai, int indiceOP) throws CRefineException {

		/*
		 *Encontrando o pai do filho a ser criado
		 */
		Integer indexDev = this.encontrarPai(nomePai, indiceOP);
		ObrigacaoProva opSelecionada = this.retornarOP(indexDev, indiceOP);

		if (indexDev == -1) {
			CRefineException e = new CRefineException("Error in load file", "COD0736");
			throw e;
		}

		Term origem = null;
		Term destino = null;

		if (opSelecionada.getPredicado() instanceof ActionTransformerPred) {
			origem = ((ActionTransformerPred) opSelecionada.getPredicado()).getSpec();
			destino = ((ActionTransformerPred) opSelecionada.getPredicado()).getImpl();
		} else /* instance of ProcessTRansformerPRed*/ {
			origem = ((ProcessTransformerPred) opSelecionada.getPredicado()).getSpec();
			destino = ((ProcessTransformerPred) opSelecionada.getPredicado()).getImpl();
		}
		Markup marca = this.getMark();

		String nome = this.getDevelopmentName(indexDev);
		nome = nome + "-" + this.getMessage("COD0735") + "#" + indiceOP;

		PODevelopmentTree subDev = new PODevelopmentTree(nome, marca, origem, destino, opSelecionada, indexDev, indiceOP);

		int id = gerDevelopments.inserirNovoSubdesenvolvimento(this.getDevelopmentName(indexDev),
				subDev, indexDev, nomePai);
		telaDesenvolvimento.adicionarNovoDesenvolvimento(id);
		telaObrigacao.adicionarNovoObrigacao(id);
	}

	/**
	 *
	 * @param indexDev indice do desenvolvimento
	 * @param indiceOP indice da OP
	 * @return a OP de um dado desenvolvimento indexado por indiceOP
	 */
	private ObrigacaoProva retornarOP(Integer indexDev, int indiceOP) {
		return this.telaObrigacao.getOp(indexDev, indiceOP);
	}

	/**
	 *
	 * @param indexDev
	 * @return o nome do desenvolvimento indexado por indexDev
	 */
	private String getDevelopmentName(Integer indexDev) {
		return gerDevelopments.getDevelopment(indexDev).getNome();
	}

	/**
	 * Esse m�todo testa os desenvolvimentos para determinar qual eo desenvolvimento
	 * pai
	 * @param indiceOP indice da Obrigacao de Prova no desenvolvimento
	 * @return Indice do Desenvolvimento pai
	 */
	private Integer encontrarPai(String nomePai, int indiceOP) {
		int result = -1;
		/* testa dos ultimos desenvolvimetnos ao primeiro se um desses
		 * desenvolvimentos eo pai*/
		for (int i = this.getDevelopmentsCount() - 1; i >= 0; i--) {
			if (this.gerDevelopments.getDevelopment(i).getNome().equals(nomePai)) {
				return i;
			}
		}
		return result;
	}

	/**
	 * Carrega o subDesenvolvimento
	 * @param passos historico do subdesenvolvimento
	 */
	public void carregarSubDesenvolvimento(LinkedList<StepOfExecution> passos) {
		try {
			this.gerInterno.abrirSubDesenvolvimento(passos);

			this.atualizarOpcoesColeta();
			if (getSizeOfHistorico() > 1) {
				this.telaPrincipal.habilitarUndo();
			}
		} catch (CRefineException except) {
			except.setTitleCode("COD0262");
			ErrorDialog errorDialog = new ErrorDialog(this, "",
					except);
			errorDialog.setVisible(true);
			except.printStackTrace();
		} catch (Exception except) {
			CRefineException e = new CRefineException(except, except.getMessage());
			e.setTitleCode("COD0262");
			ErrorDialog errorDialog = new ErrorDialog(this,
					e);
			errorDialog.setVisible(true);
			except.printStackTrace();
		}
	}

	public void updateScreenALL() {
		for (int i = 0; i < this.getDevelopmentsCount(); i++) {
			telaDesenvolvimento.updateScreen(i);
			telaObrigacao.updateScreen(i);
		}

	}

	/**
	 * testa se eo programa corrente e um subdesenvolvimento
	 * e caso seja desabilita a opção de salvar.
	 * @param id id do desenvolvimetno selecionado
	 */
	public void verificarHabilitacaoSalvar(int id) {
		if (this.gerDevelopments.verificarFilho(id)) {
			telaPrincipal.desabilitarSalvar();
		} else {
			telaPrincipal.habilitarSalvar();
		}
	}

	/**
	 * Fecha a aba indexada por childAt
	 * @param childAt
	 */
	public void closeTab(Integer childAt) {
		telaDesenvolvimento.close(childAt, false);
	}

	public boolean isSubDevelopment(int tabNumber) {
		return gerDevelopments.verificarFilho(tabNumber);
	}

	public int continuarSubDesenvolvimento(int identificador, ObrigacaoProva opSelecionada) throws CRefineException, CRulesException {
		continuing = true; /* Evitar que um subdesenvolvimento ja provado
        seja reconhecido novamente*/
		Integer indexDev = this.getSelectedDevelopment();

		PODevelopmentTree subDevOculto = this.gerDevelopments.getSubDesenvolvimentoOculto(indexDev, opSelecionada, identificador);

		ToSave passos = subDevOculto.getPassos();

		//this.retornarTelaPrincipal().setarMaximumProgressBar(passos.getHistorico().size());

		for (StepOfExecution step : passos.getHistorico()) {
			step.doStep(this);
			//this.retornarTelaPrincipal().incrementProgress();
		}
		continuing = false;

		return this.getDevelopmentsCount() - 1;
	}

	/**
	 *
	 * @param identificador
	 * @param opSelecionada
	 * @return -1 indicando se o subdesenvolvimento nao est� aberto e
	 * o id do subdesenvolvimento caso contrario
	 */
	public int estaAbertoSubDev(int identificador, ObrigacaoProva opSelecionada) {
		int indexPai = this.getSelectedDevelopment();
		return this.gerDevelopments.estaAbertoSubDev(identificador, opSelecionada, indexPai);
	}

	public void finishLoading() {
		this.telaPrincipal.finish();
	}

	/**
	 *
	 * @return O texto referente ao termo target do subdesenvolvimento selecionado
	 */
	public String printTarget() {
		String result;
		result = Printer.printAll(this.gerDevelopments.getTarget(this.getSelectedDevelopment()), this.getMark(), false);


		return result;
	}

	/**
	 *
	 * @return A AST antes da aplicação da ultima lei
	 */
	public Term retornarProgAntesDeAplicacao() {
		int id = telaDesenvolvimento.getSelectedDevelopment();
		return gerDevelopments.getDevelopment(id).getPenultimoProg();
	}

	/**
	 *
	 * @param pai
	 * @param indiceOp
	 * @return o Contexto em que foi gerado a OP de indiceOP
	 * do desenvolvimento indexado pelo valor de pai
	 */
	public Term getContextoAt(int pai, int indiceOp) {

		return telaObrigacao.getContextoAt(pai, indiceOp);
	}

	/**
	 * Metodo chamado quando o SubDesenvolvimento selecionado
	 * atinge seu alvo
	 *
	 */
	public void subDesenvolvimentoProvado() {
		PODevelopmentTree subdev = (PODevelopmentTree) gerDevelopments.getDevelopment(this.getSelectedDevelopment());
		int pai = subdev.getPai();
		int indiceOp = subdev.getIdxOp();
		this.telaDesenvolvimento.showProvedTitle();
		this.telaObrigacao.subDesenvolvimentProvado(pai, indiceOp);

	}

	/**
	 * Insere uma marca de provado nos titulos das abas
	 * do subdesenvolvimento provado
	 */
	public void showProvedTitle() {
		telaDesenvolvimento.showProvedTitle();
		telaObrigacao.showProvedTitle();
	}

	public boolean isPODevelopment() {
		return isSubDevelopment(this.getSelectedDevelopment());
	}

	/**
	 * Coleta o termo inicial de um Multiplo Desenvolvimento
	 *
	 */
	public void coletarTermoInicial() {
		/* Procura pelo processo */
		Term termoColetar = this.retornarProgAtual();
		if (termoColetar != null) {
			telaDesenvolvimento.collectedScreen(termoColetar);
			IdtUtils.inserirIdtTermoColetado(termoColetar);
		}

	}

	public void inicializarOptComboBox() {
		telaPrincipal.inicializarOptComboBox();
	}

	public void adicionarColetaInitialTermHist() {
		Coleta passo = new Coleta(TipoColeta.TERMO_INICIAL, "");
		this.adicionandoHistorico(passo);
	}

	/**
	 * Desfaz as relacoes de um termo inicial coletado
	 * e também remove os identificadores de coleta nesse termo
	 *
	 */
	public void desfazerRalacoesIdtsTermoInicial() {
		/**
		 * Desfazendo Relacoes do Termo inicial Coletado
		 */
		Term termo = this.retornarProgAtual();
		DesfazerRelationsVisitor des = new DesfazerRelationsVisitor();
		des.visitTerm(termo);

		IdtUtils.removeIdtTermoColetado(termo);

		this.desceRoll();
	}

	/**
	 *
	 * @return True caso o programa esteja num processo de carregamento
	 */
	public boolean isLoading() {
		return loading;
	}

	/**
	 *
	 * @return True caso haja a execucao de uma continuação de pODesenvolvimento
	 */
	public boolean isContinuing() {
		return continuing;
	}

	/**
	 *
	 * @return True caso todas Ops foram consideradas verdadeiras
	 */
	public boolean checkPOs() {
		return telaObrigacao.checkOPs();
	}

	public void verificarSubDevPosSetarOP() {
		if (this.isPODevelopmentProved()) {
			if (this.checkPOs()) {
				subDesenvolvimentoProvado();
			}
		}
	}

	/**
	 * Verifica se o desenvolvimento em questao
	 * possui subdesenvolvimento
	 * @return
	 */
	public boolean hasChild() {
		return (getDevelopment().getChildrenCount() > 0);
	}

	public int getNumberOfDev() {
		return this.gerDevelopments.getSize();
	}

	/**
	 *
	 * @return a lista de filhos
	 */
	public LinkedList<Integer> getFilhos() {

		return this.getDevelopment().getFilhos();
	}

	public void selecionarDesenvolvimento(Integer i) {
		this.telaDesenvolvimento.selecionarAba(i);
	}

	/**
	 * Dar o update nas abas do desenvolvimento selecionado
	 */
	public void updateSelectedScreen() {
		int i = this.getSelectedDevelopment();
		telaDesenvolvimento.updateScreen(i);
		telaObrigacao.updateScreen(i);

	}

	public Term getContextoAposAt(int pai, int indiceOp) {
		return telaObrigacao.getContextoAposAt(pai, indiceOp);
	}

	/**
	 * Métodos para a parte de Táticas
	 */
	/**
	 * Método responsavel por realizar o parser de uma Tática
	 * @param file O arquivo a ser parseado
	 * @return A tática parseada
	 */
	public Tatica parseTatica(File file) throws TacticNotFound, LawNotFound{

		Tatica res = gerInterno.parserTatica(file);
		return res;
	}

	/**
	 * Método responsavel por realizar o parser de uma Tática
	 * @param file O arquivo a ser parseado
	 * @return A tática parseada
	 */
	public boolean existeTatica(Tatica tatica) {
		List<Tatica> lista = this.retornarListaTaticas();
		for (Tatica tactic : lista) {
			if (tactic.getId().equals(tatica.getId())) {
				return true;
			}
		}
		return false;
	}

	/**
	 * Método responsavel por retornar a lista de Táticas
	 * @return A lista de Táticas
	 */
	public List<Tatica> retornarListaTaticas() {
		List<Tatica> lista = gerInterno.retornarListaTaticas();
		return lista;
	}

	/**
	 * Método responsavel por adicionar uma Tática na lista de Táticas
	 * @param tatica A Tática a ser adicionada
	 */
	public void adicionarTatica(Tatica tatica) {
		gerInterno.adicionarTatica(tatica);

	}

	/**
	 * Método responsavel por atualizar a lista de Táticas
	 * @param tatica A Tática a ser atualizada
	 */
	public void updateTacticList(Tatica tatica) {
		telaPrincipal.updateTacticList(tatica);
	}
	
	/**
	 * Método responsavel por atualizar a lista de Táticas
	 */
	public void updateTacticList() {
		telaPrincipal.updateTacticList();
	}
	
	

	/**
	 * Método responsavel por verificar se ocorreu algum erro
	 * no parser
	 * @return true Caso não ocorreu erro
	 */
	public boolean verificarErroParser() {

		if (gerInterno.verificarErroParser()) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Método responsavel por retornar o código do arquivo
	 * para setar na telaTatica
	 * @param file O arquivo que o parser será realizado
	 * @return especificação ArcAngelC
	 * @throws IOException
	 */
	public String retornarEspecificacao(File file) throws IOException {
		FileSource source = new FileSource(file);
		return gerInterno.retornarStringEspecificacaoArcAngelC(source);
	}

	public void updateTelaTatica(String codigo) {
		this.telaTatica.setarTelaTatica(codigo);


	}

	/**
	 * Método que realiza a escrita do texto no arquivo
	 * @param file Arquivo que irá receber o texto
	 * @param codigoArcAngel O código que será armazenado no arquivo
	 */
	public void escreveArquivo(File file, String codigoArcAngel) {
		try {
			gerInterno.escreverArquivo(file, codigoArcAngel);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	/**
	 * Método que remove uma Tátia
	 * @param tatica a ser revomida
	 */
	public void removerTatica(Tatica tatica) {
		gerInterno.removerTatica(tatica);

	}

	/**
	 * Metodo que retorna a telaTatica
	 */
	public TelaTatica retornaTelaTatica() {
		return telaTatica;
	}

	/**
	 * Método que chama a tela de erro
	 * @param erro O erro que ocorreu no parser
	 * @param detalhe O detalhe do erro
	 */
	public void telaErro(String erro, String detalhe, String infoExtra) {
		this.telaTatica.showErrorWindow(erro, detalhe,infoExtra);

	}

	/**
	 * Método que aplica uma tática
	 */
	/**
	 * Tenho que colocar todos as exceções aqui
	 */
	public TacticAnswer aplicarTatica(Tatica tatica) {

		aplicacao = 1;
		getDevelopment().atualizarPilhaAplicacao(1);

		NoPrograma noPrograma = this.getSelectedProg();

		Term inicial = noPrograma.getPrograma();
        Term astInicial = this.getProgramaAtual();

		NoPrograma programaInicial = new NoPrograma(inicial);
		RCell rcell = new RCell(programaInicial);

		int[] linhas =
			this.retornarLinhasSelecionadas();

		TacticAnswer resposta = null;
		try {
			resposta = gerInterno.aplicarTatica(tatica, rcell);

			Vector respostas = resposta.getRespostas();
			if (respostas != null && respostas.size() > 0) {

				//Depois de aplicar a Tática
				RCell rCellResposta = null;

					

				rCellResposta = (RCell) respostas.get(0);

				noPrograma.getPrograma();
				
				this.setTaticaFinal(tatica);
				this.setrCellFinal(rCellResposta);
				this.setAplicTatica(true);
				

				this.atualizarAposAplicacaoTatica(programaInicial, tatica, resposta, linhas[0], linhas[1]);

				gerInterno.atualizarAposAplicacaoTatica();

				this.atualizarAposAplicacaoTatica(linhas[0]);
			

			}
		}catch(Unification e4){
			telaErro("Unificacao", "", e4.getDescricao());	

		}catch (Exception e) {
			GerenciadorTaticas.controlTaltLeft = false;
			GerenciadorTaticas.controlTSemi = false;
			ArrayList<Pair<String,Pair<String,Object>>> lista = new ArrayList<Pair<String,Pair<String,Object>>>();
			gerInterno.setListArgs(lista);
			JOptionPane.showMessageDialog(null, "It was not possible to apply the tactic", "Tactic: " + tatica.getId(), JOptionPane.ERROR_MESSAGE);
		}

		return resposta;
	}

	/**
	 * M�todo para atualização das telas e outros status do CRefine ap�s
	 * a aplicação da lei ao programa
	 *
	 * @param programa
	 * @param leiAplicada
	 * @param resposta
	 */
	public void atualizarAposAplicacaoTatica(NoPrograma programa,
			Tatica taticaSelecionada, TacticAnswer resposta, int linhaInicial, int linhaFinal) {

		Vector respostas = resposta.getRespostas();

		RCell rCellResposta = null;

		if (respostas != null && respostas.size() > 0) {
			rCellResposta = (RCell) respostas.elementAt(0);
		}



		//Aqui que coloca o
		int id = this.getSelectedDevelopment();
		gerDevelopments.getDevelopment(id).getRespostasTaticas().push(resposta);

		/*
		 * For�ando a respostaTatica pega o termo real
		 */
		Term termoResultante = ExternalManager.getRealTerm(rCellResposta.getNoPrograma().getPrograma());

		/* O primeiro parametro sera alterado logo depois da impressao de
		 * tela Texto, pois a ultima posicao de texto antigo, guardara exa
		 * tamente a linha em que aparecera a lei aplicada */

		//Ve se quando é uma lei o q e tem ele recebe;
		RelationRowLaw taticaLinha = new RelationRowLaw(taticaSelecionada);

		gerDevelopments.getDevelopment(id).retornarPilhaDeTaticas().push(taticaLinha);
		//Permite insercao de Relacionamentos
		this.retornarTelaDesenvolvimento().buildProgTextTatica(termoResultante, "aplicar", linhaInicial, true, taticaSelecionada);

		/* Trata as obrigacoes de prova */
	if (rCellResposta.getOps().size() != 0) {

			//	 Chamando o provador de Teoremas
		//int linhaLei = gerDevelopments.getDevelopment(id).retornarPilhaDeLeis().peek().getLinha();
		//int linhaTatica = gerDevelopments.getDevelopment(id).retornarRedoPilhaDeTaticas().peek().getLinha();

			LinkedList<ObrigacaoProva> obrigations = this.montarListaOPs(rCellResposta, linhaFinal+1);
			this.retornarTelaObrigacao().listarObrigacoes(obrigations);
			IdtUtils.InsertIdt(this.telaObrigacao.getIdentificador() - 1,
					programa.getPrograma(), Identificador.OBRIGACAO);
			
		}


		Term termoaplicado = programa.getPrograma();
		this.getTermosAplicados().push(termoaplicado);

		this.inserirIdt(termoaplicado, this.retornarTelaDesenvolvimento().getIdt() - 1, Identificador.TATICA);


		/* Adiciona o passo de aplicação de lei ao hist�rico de
		 * desenvolvimento */
		//resposta.setLinhaInicial(linhaInicial);
		//resposta.setLinhaFinal(linhaFinal);
		resposta.setTaticaAplicada(taticaSelecionada);
		gerInterno.respostaLei.setLinhaInicial(linhaInicial);

		//adicionarAplicacaoTaticaAoHistorico(resposta);
	}

	/**
	 * Método que atuliza o sistema após a aplicação de uma tática
	 * @param linha A linha inicial selecionada
	 */
	private void atualizarAposAplicacaoTatica(int linha) {

		updateScreen();
		updateLawIdentifierGUITactic(false, linha);
		atualizarTelaObrigacoes();
		try {
			atualizarTelaCodigo();
		} catch (CRefineException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		atualizarOpcoesColeta();

	}

	public void updateLawIdentifierGUITactic(boolean b, int linha) {
		this.telaDesenvolvimento.updateLawIdentifierGUITactic(b, linha);
	}

	/**
	 * Método que retornar a AST atual
	 * @return ast
	 */
	public Term getProgramaAtual() {

		return getDevelopment().getProgAtual();
	}

	/**
	 * Método que atuliza a pilha de táticas
	 * @param ast
	 */
	public void atulizarPilhaTaticas(Term ast) {
		getDevelopment().atulizarPilhaTaticas(ast);

	}

	/**
	 * Método que verifica a pilha de Táticas
	 * @return true
	 */
	public boolean verificarPilhaTaticas() {

		if (getDevelopment().verificarPilhaUndo()) {
			return true;
		}
		return false;
	}

	public void desfazerAplicarTatica(){

		this.desfazerInternoTatica();
		this.checkFinishedSubDevelopment(this.retornarProgAtual());
		this.desfazerIdentificadorTatica();
		this.retornarTelaDesenvolvimento().desfazerAplicLei();
		this.desfazerTelaObri_RespostaLei();
		//this.desfazerPilhas();
	}


	public boolean getPilhaAplicacao() {

		if (getDevelopment().getPilhaAplicacao().size()>0)
			return true;
		return false;
	}

	public int retornarPilhaAplicacao() {
		return	getDevelopment().retornarPilhaAplicacao();

	}

	public void atualizarPilhaAplicacao(int i) {
		getDevelopment().atualizarPilhaAplicacao(i);

	}

	public int retornarPilhaRedo() {
		return getDevelopment().retornarPilhaRedo();

	}

	public int retornarPilhaUndo() {
		return getDevelopment().retornarPilhaUndo();

	}

	

	public String TraduzirToLatex (String str) {

		String result = new String();
		String test = "";
		int i = 0;

		ArcAngelCToCircus arcAngel = new ArcAngelCToCircus();

		while  ( i < str.length()) {

			if (Character.isWhitespace(str.charAt(i))) {
				test = "";
				result += str.charAt(i);
			}

			else if (Character.isLetterOrDigit(str.charAt(i)) ) {
				test += str.charAt(i);
				result += str.charAt(i);

				if (arcAngel.get(test) != null)
					result = result.replace(test, arcAngel.get(test));

			}


			else {

				String aux = "" + str.charAt(i);

				if (aux.equals("@"))
					result += "@";

				if (arcAngel.get(aux) != null) {

					result += arcAngel.get(aux);
				}
				else result += str.charAt(i);

			}
			i++;
		}

		return result;
	}

	

	public int getLineTelaTatica(){
		return telaTatica.getLine();
	}


	public int setarLinha(){
		return gerInterno.getLinha();
	}
	
	public String[] getTextoDesTac() {
		return textoDesTac;
	}

	public void setTextoDesTac(String[] textoDesTac) {
		this.textoDesTac = textoDesTac;
	}

	/*public void updateTacticList() {
		final List<Tatica> list = this.retornarListaTaticas();
		for (Tatica tatica : list) {
			telaPrincipal.updateTacticListInicio(tatica);		
		}
		
	}*/

	public void escreveTaticaSerializada(Tatica tatica) {
		gerInterno.escreveTaticaSerializada(tatica);
		
	}


}


