package circusRefine.Tactic.Principal;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import circusRefine.core.InternalManager;
import circusRefine.util.Pair;
import circusRefine.Tactic.Excecao.*;
import circusRefine.Tactic.Util.*;

public class TTatica extends TacticComponent{


	/**
	 * 
	 */
	private static final long serialVersionUID = 3006945216964935650L;

	public TTatica(String nomeTatica, ArrayList<Object> argumentos) {
		this.nome       = nomeTatica;
		this.argumentos = argumentos;
	}

	public TTatica(String nomeTatica) {
		this.nome       = nomeTatica;
	}

	@Override
	public String toString() {

		return null;
	}

	@Override
	public TacticAnswer aplicar(RCell rCell, List<Object> argMap,
			InternalManager gerInterno) throws Exception, Unification {

		int tac = 0;

		Vector respostaTatica = new Vector();
		ArrayList<Pair<String,Pair<String,Object>>>  lista = new ArrayList<Pair<String,Pair<String,Object>>> ();
		RCell rCellResposta = new RCell();
		TacticAnswer resposta = null;

		Tatica tatica = gerInterno.getGerTaticas().retornarTatica(this.getNome());
		/**
		 * Verificando se a tatica existe
		 */
		if (tatica == null)
			tatica = gerInterno.getTTatica(this,argMap);

		/**
		 * Verificando os argumentos e fazendo mapeamento
		 */
		if (argMap != null && argMap.size() > 0){
			if ((tatica.getArgumentos() != null && argMap.size() > 0 &&
					tatica.getArgumentos().size() == argMap.size())
					|| gerInterno.getTiposTatica().contains(argMap.get(0)) ){
				lista = gerInterno.verificarArgumentos(argMap,tatica);
			}
		}
	
		if(lista ==null){
			tatica = null;
		}
		if (tatica != null && lista.size() > 0)
			gerInterno.setListArgs(lista);	

		//tatica = gerInterno.verificarArgumentosTaticas(argMap, tatica);
		if (tatica!=null){
		TacticAnswer resp = gerInterno.aplicarTatica(tatica, rCell);

		if (resp!= null){
			Vector resp2 = resp.getRespostas();
			if (resp2.isEmpty()){
				rCellResposta = new RCell(rCell.getNoPrograma(),rCell.getOps());
			}
			else{
				RCell rCellResp = (RCell) resp2.get(0);
				rCellResposta = new RCell(rCellResp.getNoPrograma(),rCellResp.getOps());
			}
			respostaTatica.add(rCellResposta);

			resposta = new TacticAnswer(respostaTatica);
		}
		/*System.out.println(" *************** " +
				"TATICA APLICADA" + tatica.getId() + "*********************"+
		"***************************************");
		GerenciadorTaticas.tatica++;*/
		//lista = new ArrayList<Pair<String,Pair<String,Object>>>();
		}
		return resposta;
	}


}
