package circusRefine.Tactic.Principal;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import net.sourceforge.czt.circus.impl.ParallelActionImpl;
import net.sourceforge.czt.circus.impl.ParallelProcessImpl;
import net.sourceforge.czt.zpatt.ast.Sequent;

import circusRefine.Tactic.Excecao.*;
import circusRefine.Tactic.Util.*;
import circusRefine.core.InternalManager;
import circusRefine.core.NoPrograma;
import circusRefine.core.util.POLog;
import circusRefine.util.OPTipos;
import circusRefine.util.Pair;

public class TInterleavebox extends TaticaBinaria{

	/**
	 * 
	 */
	private static final long serialVersionUID = 8911015274725247525L;


	public TInterleavebox(TacticComponent tacticLeft, TacticComponent tacticRight) {
		this.setTaticaEsquerda(tacticLeft);
		this.setTaticaDireita(tacticRight);
	}
	
	public TacticAnswer aplicar(RCell rCell, List argMap,
			InternalManager gerInterno) throws Exception,Unification  {
		Vector listAction = new Vector();
		RCell aplicar = new RCell();
		Vector respostaFinal = new Vector();
		TacticAnswer respFinal = null;
		Vector resultadoEsq = new Vector();
		Vector resultadoDir = new Vector();
		Vector respostas = new Vector();
		Vector respProdutoCart = new Vector();

		NoPrograma noProgInicial = rCell.getNoPrograma();
		if (noProgInicial.getPrograma() instanceof ParallelProcessImpl
				|| noProgInicial.getPrograma() instanceof ParallelActionImpl){
		TacticAnswer respApliDir = null;

		List<Pair<Pair<Sequent,Sequent>,Pair<OPTipos, POLog>>> ops1 = new ArrayList<Pair<Pair<Sequent,Sequent>,Pair<OPTipos, POLog>>>();
		List<Pair<Pair<Sequent,Sequent>,Pair<OPTipos, POLog>>> ops2 = new ArrayList<Pair<Pair<Sequent,Sequent>,Pair<OPTipos, POLog>>>();

		//VE SE TEM CERTO PARA O PARALLEL
		listAction = gerInterno.retornarListaAcoes(rCell.getNoPrograma().getPrograma());

		/**
		 * Recebendo o rCell da Esquerda
		 */
		aplicar = (RCell) listAction.get(0);
		aplicar = new RCell(aplicar.getNoPrograma(), rCell.getOps());

		/**
		 * Aplicar a tática da Esquerda no programa da Esquerda
		 */
		TacticAnswer respApliEsq = this.getTaticaEsquerda().aplicar(aplicar, argMap, gerInterno);

		/**
		 * Recebendo o rCell da Esquerda
		 */
		aplicar = (RCell) listAction.get(1);
		aplicar = new RCell(aplicar.getNoPrograma(), rCell.getOps());
		if (aplicar != null){

		/**
		 * Aplicar a tática da Direita no programa da Direita
		 */
		respApliDir = this.getTaticaDireita().aplicar(aplicar, argMap, gerInterno);
		}
		/**
		 * Recebendo os resultados
		 */
		if (respApliEsq != null){
		resultadoEsq = respApliEsq.getRespostas();
		/**
		 * Adicionando as respostas
		 */
		respostas.addElement(resultadoEsq);
		}
		if (respApliDir != null){
		resultadoDir  = respApliDir.getRespostas();
		respostas.addElement(resultadoDir);
		}

		/**
		 * Realizar o Produto Cartesiano das respostas
		 * Para isso, copiando as duas respostas para um vetor só
		 */

		if (respostas.size() > 0)
		respProdutoCart = ListaUtil.distributedCartesianProduct(respostas);

		/**
		 * Montar a resposta
		 */
		
		if (respProdutoCart.size() == 1){
			
			Vector parRCell = (Vector) respProdutoCart.get(0);
			if (parRCell.size() == 1){

			/**
			 * Recebendo os RCells do par
			 */

			RCell rCell1 = (RCell) parRCell.get(0);
			RCell rCellParallelbox = new RCell(rCell1.getNoPrograma(),rCell1.getOps());
			respostaFinal.addElement(rCellParallelbox);
			return null;
			
		}
		
		else{
		for (int i = 0; i < respProdutoCart.size(); i++) {
			parRCell = (Vector) respProdutoCart.get(i);

			/**
			 * Recebendo os RCells do par
			 */

			RCell rCell1 = (RCell) parRCell.get(0);
			RCell rCell2 = (RCell) parRCell.get(1);

			/**
			 * Verificando se existe OP´s repetidas
			 */

			
			if (rCell1.getOps().size() > 0)
			ops1 = rCell1.getOps();
			if (rCell2.getOps().size() > 0)
			ops2 =rCell2.getOps();

			RCell rCellInterleave = gerInterno.montarRespostaBinaria(rCell1,rCell2,noProgInicial.getPrograma());

			
			if (rCell2.getOps().size() > 0 && rCell1.getOps().size() == 0){
				//ops1.addElement(ops2);
				/**
				 * Setando as OP´s
				 */
				rCellInterleave.setOps(rCell2.getOps());
			}
			else if (rCell1.getOps().size() > 0 && rCell2.getOps().size() == 0){
				//ops1.addElement(ops2);
				/**
				 * Setando as OP´s
				 */
				rCellInterleave.setOps(rCell1.getOps());
			}


			else if (ops1.size() != 0 || ops2.size() != 0){

				for (int j = 0; j < ops2.size(); j++){
					if (!ops1.contains(ops2.get(j))) {
						ops1.add(ops2.get(j));
					}
				}
				/**
				 * Setando as OP´s
				 */
				rCellInterleave.setOps(ops1);
			}

			RCell rcellfinal = new RCell(rCellInterleave.getNoPrograma(),ops1);
			//RCell rcellfinal = new RCell(rCellParallelbox.getNoPrograma(),rCellParallelbox.getOps());
			respostaFinal.addElement(rcellfinal);

		}
		}//end else
		respFinal = new TacticAnswer(respostaFinal);
		}
		}
		
		return respFinal;
	}


	@Override
	public String toString() {
		// TODO Auto-generated method stub
		return null;
	}

}
