package circusRefine.Tactic.Principal;


import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.BasicProcess;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.circus.impl.BasicProcessImpl;
import circusRefine.Tactic.Excecao.LawNotFound;
import circusRefine.Tactic.Util.RCell;
import circusRefine.Tactic.Util.TacticAnswer;
import circusRefine.core.InternalManager;
import circusRefine.core.NoPrograma;


public class TBeginEndBox extends TaticaNaria{

	private static final long serialVersionUID = -6431619590073678139L;

	public TBeginEndBox(String nome, TacticComponent tatica) {
		this.setNome(nome);
		this.setTatica(tatica);
	}

	public TBeginEndBox(ListaTaticas lista) {
		this.setTaticas(lista);
	}

	@Override
	public String toString() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public TacticAnswer aplicar(RCell rCell, List<Object> args,
			InternalManager gerInterno)
	throws Exception, LawNotFound {

		TacticAnswer respostaFinal = null;
		RCell rCellNome = null;
		RCell rCellMainAction = null;
		Vector respFinalVector = new Vector();
		NoPrograma noPrograma;
		Vector respostaTatica = new Vector();
		Term mainAction = null;
		List<Term> process = new ArrayList<Term>();

		NoPrograma noProgInicial = rCell.getNoPrograma();

		if (noProgInicial.getPrograma() instanceof BasicProcessImpl){
			process = gerInterno.getBeginEndBox(noProgInicial);
			mainAction = process.get(0);

		}
		else{
			Term newProcess = gerInterno.getNewProcess(rCell);
			ProcessPara pp = (ProcessPara) newProcess;
			BasicProcess bp = (BasicProcess) pp.getCircusBasicProcess();
			mainAction = (Term) bp.getMainAction();
		}

		/**
		 * Acao Principal
		 */
		if (this.getTaticas().tam() == 1){

			/**
			 * Entao a tatica eh para aplicar na acao principal
			 */
			TacticComponent tComp = this.getTaticas().get(0);


			/** 
			 *  Craindo o RCell para a acao principal
			 */


			noPrograma = new NoPrograma(mainAction);
			rCellMainAction = new RCell(noPrograma,rCell.getOps());

			/**
			 * Aplicar a tatica na acao principal
			 */
			TacticAnswer respTat2 = tComp.aplicar(rCellMainAction, tComp.getArgumentos(), gerInterno);
			respostaTatica = respTat2.getRespostas();

			if (respostaTatica != null){
				RCell rCellFinal = (RCell) respostaTatica.get(0);
				rCellFinal = new RCell(rCellFinal.getNoPrograma(), rCellFinal.getOps());
				respFinalVector.add(rCellFinal);
			}

			respostaFinal = new TacticAnswer(respFinalVector);

		}else{
			for (int j = 0; j < this.getTaticas().tam(); j++) {

				/** Recebendo a 1 tatica
				 */
				TacticComponent tComp = this.getTaticas().get(j);

				/**
				 * Veririficando se o 1 argumento nome esta vazio
				 */
				if (tComp.getNome()!=null) {

					rCellNome = gerInterno.verificarNomeProcesso(process,tComp.getNome());
					if(rCellNome != null){

						/**
						 * Aplicar a tatica1 no nome
						 */
						TacticAnswer respTat1 = tComp.getTatica().aplicar(rCellNome, tComp.getTatica().getArgumentos(), gerInterno);

						respostaTatica = respTat1.getRespostas();
						respFinalVector.add(respostaTatica);
					}
					else 
						System.out.println("O parametro não é um paragrafo do processo!");


				}
				else {

					/**
					 * Entao a tatica eh para aplicar na acao principal
					 *
					 * Craindo o RCell para a acao principal
					 */

					noPrograma = new NoPrograma(mainAction);
					rCellMainAction = new RCell(noPrograma);

					/**
					 * Aplicar a tatica na acao principal
					 */
					TacticAnswer respTat2 = tComp.aplicar(rCellMainAction, tComp.getArgumentos(), gerInterno);
					respostaTatica = respTat2.getRespostas();

					respFinalVector.add(respostaTatica);
					respostaFinal = new TacticAnswer(respFinalVector);
				}


			}//for j
		}
		return respostaFinal;	
	}

}
