package circusRefine.Tactic.Principal;

import java.util.List;
import java.util.Vector;
import circusRefine.core.InternalManager;
import circusRefine.Tactic.Excecao.*;
import circusRefine.Tactic.Util.*;

public class TAlt extends TaticaBinaria{

	/**
	 * 
	 */
	private static final long serialVersionUID = -2338130427147347289L;


	public TAlt(TacticComponent taticLeft, TacticComponent taticRight) {
		this.setTaticaEsquerda(taticLeft);
		this.setTaticaDireita(taticRight);
		this.setAplicaDir(false);
		this.setAplicaEsq(false);
	}

	@Override
	public TacticAnswer aplicar(RCell rCell, List<Object> args,
			InternalManager gerInterno)
	throws Exception, LawNotFound {
		RCell rCellInicial = rCell;

		int control = 0;
		Vector respostas = new Vector();
		Vector respDir = new Vector();
		Vector respEsq = new Vector();
		TacticAnswer answerLeft = null, answerRght = null;
		

		if (!this.isAplicaEsq() || GerenciadorTaticas.rec){
		
			answerLeft = this.getTaticaEsquerda().aplicar(rCellInicial, this.getTaticaEsquerda().getArgumentos(), gerInterno);
			if (answerLeft != null){
			
			if (GerenciadorTaticas.controlTSemi){
				/**
				 * Para saber se veio de um TSemi
				 */
				GerenciadorTaticas.controlTAbort = true;
				if (!GerenciadorTaticas.controlTaltLeft){
					GerenciadorTaticas.controlTaltLeft = true;
					this.setAplicaEsq(true);
					respEsq = answerLeft.getRespostas();
					if (respEsq != null){
					RCell rCell2 = (RCell) respEsq.get(0);
					rCell2.getNoPrograma().getPrograma();

					RCell rCellResposta = new RCell(rCell.getNoPrograma(),rCell.getOps());
					respostas.add(rCellResposta);
					TacticAnswer respFinal = new TacticAnswer(ListaUtil.distributedConcatenation(respostas));
					return respFinal;
					}
				}
				else{
					respEsq = answerLeft.getRespostas();
					RCell rCell2 = (RCell) respEsq.get(0);
					rCell2.getNoPrograma().getPrograma();
					respostas.add(rCell2);
					TacticAnswer respFinal = new TacticAnswer(ListaUtil.distributedConcatenation(respostas));
					return respFinal;
				}
			}
			else{
				/**	
				Nao é de TSemi
				*/
				if (answerLeft != null){
				respEsq = answerLeft.getRespostas();
				RCell rCell2 = (RCell) respEsq.get(0);
				rCell2.getNoPrograma().getPrograma();
				respostas.add(rCell2);
				GerenciadorTaticas.controlTaltLeft = false;
				GerenciadorTaticas.controlTaltRight = false;
				this.setAplicaDir(false);
				this.setAplicaEsq(false);
				TacticAnswer respFinal = new TacticAnswer(ListaUtil.distributedConcatenation(respostas));
				return respFinal;
				}
			}
			
		}else{
			/**
			 * O resultado da aplicacao this.getTaticaEsquerda() == null
			 * falhou entao pode aplicar a tatica da direita
			 */
			this.setAplicaEsq(true);
			GerenciadorTaticas.controlTAbort = true;
			answerRght = this.getTaticaDireita().aplicar(rCellInicial, args, gerInterno);
			control = 1;
			if (!GerenciadorTaticas.controlTSemi)
				this.setAplicaDir(true);

		}
		}


		if((this.isAplicaEsq() && !this.isAplicaDir() && control == 0) || 
				(GerenciadorTaticas.controlTSemi && GerenciadorTaticas.tacRoot.equals(this.getTaticaDireita()))){
			answerRght = this.getTaticaDireita().aplicar(rCellInicial, args, gerInterno);
			this.setAplicaDir(true);
			
		}
		
		if (answerRght != null){
			
			respDir = answerRght.getRespostas();
			RCell rCell2 = (RCell) respDir.get(0);
			RCell rCellResposta = new RCell(rCell2.getNoPrograma(),rCell2.getOps());
			respostas.add(rCellResposta);
			TacticAnswer respFinal = new TacticAnswer(ListaUtil.distributedConcatenation(respostas));
			GerenciadorTaticas.controlTaltLeft = false;
			GerenciadorTaticas.controlTaltRight = false;
			this.setAplicaDir(false);
			this.setAplicaEsq(false);
			return respFinal;
		}

		GerenciadorTaticas.controlTaltLeft = false;
		GerenciadorTaticas.controlTaltRight = false;
		this.setAplicaDir(false);
		this.setAplicaEsq(false);
		
		if (answerLeft == null && answerRght == null)
			return null;
		else {
			TacticAnswer respFinal = null;
			if (respostas.size() > 1)
			respFinal = new TacticAnswer(ListaUtil.distributedConcatenation(respostas));
			else
				respFinal = new TacticAnswer(respostas);
			return respFinal;
		}
		
	}


	public String toString() {
		return null;
	}


}
