import jcsp.lang.*;

class CallStudentCollege implements CSProcess {

  public void run () {

    final String[] profId = {"Bill", "Hilary", "Gennifer", "Paula", "Monica"};
    final String[] studentId = {"Occam", "Babbage", "Einstein", "Turing"};
    // final int nPhilosophers = 5;
    // final int nStudents = 4;

    final int thinkTime = 3000;
    final int eatTime = 100;

    final int studentServiceTime = 1000;

    final int canteenServiceTime = 0;
    final int canteenSupplyTime = 3000;
    final int maxChickens = 50;

    final CallStudent.Any2AnyServiceChannel studentService = new CallStudent.Any2AnyServiceChannel ();
    final CallCanteen.Any2OneServiceChannel canteenService = new CallCanteen.Any2OneServiceChannel ();
    final CallCanteen.Any2OneSupplyChannel supply = new CallCanteen.Any2OneSupplyChannel ();
    
    final CallStudent[] students = new CallStudent[studentId.length];
    for (int i = 0; i < students.length; i++) {
      // String studentId = new Integer (i).toString ();
      students[i] = new CallStudent (studentId[i], studentService, canteenService, studentServiceTime);
    }
    
    final CallProf[] profs = new CallProf[profId.length];
    for (int i = 0; i < profs.length; i++) {
      // String profId = new Integer (i).toString ();
      profs[i] = new CallProf (profId[i], studentService, thinkTime, eatTime, i == 0);
    }

    new Parallel (
      new CSProcess[] {
        new CallClock (),
        new CallCanteen (canteenService, supply, canteenServiceTime, canteenSupplyTime, maxChickens),
        new Parallel (students),
        new Parallel (profs),
        new CallChef ("Pierre", 4, 2000, supply),       // chefId, batchSize, batchTime
        new CallChef ("Henri", 10, 20000, supply),      // chefId, batchSize, batchTime
        new CallChef ("Sid", 100, 150000, supply)       // chefId, batchSize, batchTime
      }
    ).run ();
    
  }

  public static void main (String argv[]) {
    new CallStudentCollege ().run ();
  }
  
}
