import jcsp.lang.*;

class CallStudent implements CSProcess {

  // call interface and channel

  public static interface Service {
    public String hello (String profId, CallCanteen.One2OneServiceChannel service);
  }

  public static class Any2AnyServiceChannel
   extends Any2AnyCallChannel implements Service {
    public String hello (String profId, CallCanteen.One2OneServiceChannel service) {
      join ();
      String n = ((Service) server).hello (profId, service);
      fork ();
      return n;
    }
  }
  
  // fields and constructors
  
  private final String id;
  private final ChannelAccept studentService;         // shared from all Philosphers (any-any)
  private final CallCanteen.Service canteenService;   // act as a client on this line
  private final int serviceTime;                      // how long a philosopher spends being served
  
  public CallStudent (String id, Any2AnyServiceChannel studentService,
                      CallCanteen.Service canteenService, int serviceTime) {
    this.id = id;
    this.studentService = studentService;
    this.canteenService = canteenService;
    this.serviceTime = serviceTime;
  }

  // inner process and run method

  private interface inner extends CSProcess, Service, CallCanteen.Service {};

  public void run () {

    new inner () {

      private final CSTimer tim = new CSTimer ();

      private AltingChannelAccept service;

      private int nServed = 0;

      public String hello (String profId, CallCanteen.One2OneServiceChannel service) {
        this.service = service;
        System.out.println ("   Student " + id + " -> Prof " + profId + " : hello ... ");
        return id;
      }
  
      public int takeChicken (String profId) {
        System.out.println ("   Student " + id + " -> Prof "
                                          + profId + " : that'll be 1-95 please ... ");
        tim.sleep (serviceTime);          // take the money and give any change
        nServed++;
        System.out.println ("   Student " + id + " -> Prof "
                                          + profId + " : thank you - have a nice day ["
                                          + nServed + " served]");
        return 1;
      }
  
      public void run () {
        System.out.println ("   Student " + id + " : starting ... ");
        while (true) {
          canteenService.takeChicken (id);
          System.out.println ("   Student " + id + " : got chicken ... ready to serve ...");
          studentService.accept (this);     // Philosopher makes contact
          service.accept (this);            // deal with Philosopher
        }
      }
  
    }.run ();

  }
  
}
