import jcsp.lang.*;

class CallProf implements CSProcess {
  
  //{{{  COMMENT documentation
  //
  //A Philosopher thinks for a while -- around 3 seconds -- and then goes to the
  //Canteen for food, consuming what he gets straight away.   This cycle continues
  //indefinitely.
  //
  //Except, that is, for Philosopher 0 ...  who refuses to think and just keeps
  //going to the Canteen.
  //
  //For this Canteen, when there's no chicken, the Philosphers are just kept
  //waiting in the service queue.  The greedy Philosopher no longer loses his
  //place through getting in before the food is cooked and doesn't starve.
  //
  //}}}
  
  private final String id;
  private final CallStudent.Service studentService;
  private final int thinkTime;
  private final int eatTime;
  private final boolean greedy;
  
  public CallProf (String id, CallStudent.Service studentService,
                   int thinkTime, int eatTime, boolean greedy) {
    this.id = id;
    this.studentService = studentService;
    this.thinkTime = thinkTime;
    this.eatTime = eatTime;
    this.greedy = greedy;
  }
  
  public void run () {
    final CSTimer tim = new CSTimer ();
    final CallCanteen.One2OneServiceChannel service = new CallCanteen.One2OneServiceChannel ();
    int nEaten = 0;
    while (true) {
      // everyone, unless greedy, has a little think
      if (! greedy) {
        System.out.println ("   Prof " + id + " : thinking ...");
        tim.sleep (thinkTime);   // thinking
      }
      // want chicken
      System.out.println ("   Prof " + id + " : gotta eat ...");
      String student = studentService.hello (id, service);
      System.out.println ("   Prof " + id + " -> Student " + student + " : hi, can I have a chicken please?");
      int chicken = service.takeChicken (id);
      nEaten++;
      System.out.println ("   Prof " + id + " : mmm ... that's good [" + nEaten + " so far]");
      tim.sleep (eatTime);       // eating
    }
  }
  
}
