import jcsp.lang.*;
import jcsp.util.ints.*;
import jcsp.awt.*;
import java.awt.*;

import phw.util.Ask;

public class SplatMain extends ActiveApplet {

  public static final int minWidth = 335;
  public static final int minHeight = 100;
  public static final int minBurst = 20;

  public static final int maxWidth = 1024;
  public static final int maxHeight = 768;
  public static final int maxBurst = 1000;

  public static final int squareFactor = 30;

  public void init () {

    final Dimension size = getSize ();

    final int standbyBurst = 100;
    final int standbyAcross = 4;
    final int standbyDown = 1;

    final int nAcross = getAppletInt ("nAcross", 1, size.width/squareFactor, standbyAcross);
    final int nDown = getAppletInt ("nDown", 1, size.height/squareFactor, standbyDown);
    final int burst = getAppletInt ("burst", minBurst, maxBurst, standbyBurst);

    final boolean detach = getAppletBoolean ("detach", false);

    if (detach) {

      // final One2OneChannelInt stopStart = One2OneChannelInt.create (new OverWriteOldestBufferInt (1));
      // setStopStartChannel (stopStart);
      final One2OneChannelInt destroy = One2OneChannelInt.create (new OverWriteOldestBufferInt (1));
      final One2OneChannelInt destroyAck = new One2OneChannelInt ();
      setDestroyChannels (destroy, destroyAck);
      // setDestroyChannels (destroy, destroyAck, -1);    // cheat for Sun's Java Plug-in

      final Frame frame = new Frame ("Splat");
      frame.setSize (size);
      final Splat splat = new Splat (nAcross, nDown, burst, frame, destroy, destroyAck);
      frame.pack ();
      frame.setLocation ((maxWidth - size.width)/2, (maxHeight - size.height)/2);
      frame.setVisible (true);
      frame.toFront ();
      setProcess (splat);
    } else {
      setProcess (new Splat (nAcross, nDown, burst, this, null, null));
    }

  }

  public static void main (String[] args) {
  
    System.out.println ("\nSplat starting ...\n");

    final int width = Ask.Int ("width = ", minWidth, maxWidth);
    final int height = Ask.Int ("height = ", minHeight, maxHeight);
    System.out.println ();

    final int nAcross = Ask.Int ("squares across = ", 1, width/squareFactor);
    final int nDown = Ask.Int ("squares down = ", 1, height/squareFactor);
    System.out.println ();

    final int burst = Ask.Int ("burst = ", minBurst, maxBurst);
    System.out.println ();

    final ActiveClosingFrame activeClosingframe = new ActiveClosingFrame ("Splat");
    final ActiveFrame activeFrame = activeClosingframe.getActiveFrame ();
    activeFrame.setSize (width, height);

    final Splat splat = new Splat (nAcross, nDown, burst, activeFrame, null, null);

    activeFrame.pack ();
    activeFrame.setLocation ((maxWidth - width)/2, (maxHeight - height)/2);
    activeFrame.setVisible (true);
    activeFrame.toFront ();

    new Parallel (
      new CSProcess[] {
        activeClosingframe,
        splat
      }
    ).run ();

  }

}
