import java.awt.*;
import phw.util.Ask;

class Aspect {

  static public Dimension bestAspect (Dimension dim) {
    final int width = dim.width;
    final int height = dim.height;
    if (width >= height) {
      final int ratio = width/height;
      final int remainder = width - (ratio*height);
      if (remainder <= height/2) {
        return new Dimension (width - remainder, height);
      } else {
        final int newRatio = ratio + 1;
        final int newHeight = width/newRatio;
        return new Dimension (newHeight*newRatio, newHeight);
      }
    } else {
      final int ratio = height/width;
      final int remainder = height - (ratio*width);
      if (remainder <= width/2) {
        return new Dimension (width, height - remainder);
      } else {
        final int newRatio = ratio + 1;
        final int newWidth = height/newRatio;
        return new Dimension (newWidth, newWidth*newRatio);
      }
    }
  }

  public static void main (String[] args) {

    final int maxWidth = 1024;
    final int maxDepth = 768;

    final int minWidth = 20;
    final int minDepth = 20;

    System.out.println ("Aspect starting ...");

    while (true) {
      final int width = Ask.Int ("width = ", minWidth, maxWidth);
      final int depth = Ask.Int ("depth = ", minDepth, maxDepth);
      final Dimension dim = bestAspect (new Dimension (width, depth));
      System.out.println (dim);
    }
  }

}

