import jcsp.lang.*;
import jcsp.util.*;
import jcsp.awt.*;
import java.awt.*;

public class PicassoNetwork implements CSProcess {

  private final ActiveCanvas activeCanvas;

  private final Picasso picasso;

  public PicassoNetwork (final Container parent) {

    final Dimension size = parent.getSize ();

    parent.setLayout (new BorderLayout ());
    parent.setBackground (Color.blue);

    final One2OneChannel mouseEvent =
      One2OneChannel.create (new OverWriteOldestBuffer (10));
    final One2OneChannel mouseMotionEvent =
      One2OneChannel.create (new OverWriteOldestBuffer (1));

    final DisplayList display = new DisplayList ();

    final One2OneChannel toGraphics = new One2OneChannel ();
    final One2OneChannel fromGraphics = new One2OneChannel ();

    activeCanvas = new ActiveCanvas ();
    activeCanvas.setBackground (Color.black);
    activeCanvas.addMouseEventChannel (mouseEvent);
    activeCanvas.addMouseMotionEventChannel (mouseMotionEvent);
    activeCanvas.setPaintable (display);
    activeCanvas.setGraphicsChannels (toGraphics, fromGraphics);
    activeCanvas.setSize (size);

    // If the parent is an applet, the above setSize has no effect and the activeCanvas
    // is fitted to the "Center" area (see below) of the applet's panel.

    // If the parent is a frame, the above *does* define the size of the activeCanvas
    // and the size of the parent is expanded to wrap around when it is packed.

    System.out.println ("PicassoNetwork adding ActiveCanvas to the parent ...");
    parent.add ("Center", activeCanvas);

    picasso = new Picasso (size, mouseEvent, mouseMotionEvent, display);
    // picasso = new Picasso (size, mouseEvent, mouseMotionEvent, toGraphics, fromGraphics);

  }

  public void run () {

    System.out.println ("PicassoNetwork starting up ...");

    new Parallel (
      new CSProcess[] {
        activeCanvas,
        picasso
      }
    ).run ();

  }

}

