import jcsp.lang.*;
import jcsp.util.*;
import jcsp.awt.*;

import phw.util.Ask;

public class PicassoMain extends ActiveApplet {

  public static final int minWidth = 100;
  public static final int maxWidth = 1024;

  public static final int maxHeight = 768;
  public static final int minHeight = 100;

  public void init () {
    setProcess (new PicassoNetwork (this));
  }

  public static void main (String argv[]) {
  
    System.out.println ("\nPicasso starting ...\n");

    final int width = Ask.Int ("width = ", minWidth, maxWidth);
    final int height = Ask.Int ("height = ", minHeight, maxHeight);
    System.out.println ();

    final ActiveClosingFrame activeClosingframe = new ActiveClosingFrame ("Picasso");
    final ActiveFrame activeFrame = activeClosingframe.getActiveFrame ();
    activeFrame.setSize (width, height);

    final PicassoNetwork picassoNetwork = new PicassoNetwork (activeFrame);

    activeFrame.pack ();
    activeFrame.setLocation ((maxWidth - width)/2, (maxHeight - height)/2);
    activeFrame.setVisible (true);
    activeFrame.toFront ();

    new Parallel (
      new CSProcess[] {
        activeClosingframe,
        picassoNetwork
      }
    ).run ();

  }

}
