import jcsp.lang.*;

class Fork implements CSProcess {

  // protected attributes

  protected int id;
  protected AltingChannelInputInt left, right;
  protected ForkReport report;

  // constructors

  public Fork (int nPhilosophers, int id,
               AltingChannelInputInt left, AltingChannelInputInt right,
               ForkReport report) {
    this.id = id;
    this.left = left;
    this.right = right;
    this.report = report;
  }

  // public methods

  public void run () {
    final Alternative alt = new Alternative (new Guard[] {left, right});
    final int LEFT = 0;
    final int RIGHT = 1;
    int philId;
    while (true) {
      switch (alt.fairSelect ()) {
        case LEFT:
          philId = left.read ();
          report.forkUp (id, philId);
          philId = left.read ();
          report.forkDown (id, philId);
        break;
        case RIGHT:
          philId = right.read ();
          report.forkUp (id, philId);
          philId = right.read ();
          report.forkDown (id, philId);
        break;
      }
    }
  }

}
