import jcsp.lang.*;

class DiningPhilosophersCollege implements CSProcess {

  private final int nPhilosophers;
  private final int clockPeriod;
  private final PhilReport philReport;
  private final ForkReport forkReport;
  private final ChannelOutputInt securityReport;
  private final ChannelOutputInt clockReport;

  public DiningPhilosophersCollege (int nPhilosophers, int clockPeriod,
                                    PhilReport philReport,
                                    ForkReport forkReport,
                                    ChannelOutputInt securityReport,
                                    ChannelOutputInt clockReport) {
    this.nPhilosophers = nPhilosophers;
    this.clockPeriod = clockPeriod;
    this.philReport = philReport;
    this.forkReport = forkReport;
    this.securityReport = securityReport;
    this.clockReport = clockReport;
  }

  public void run () {

    final One2OneChannelInt[] left = One2OneChannelInt.create (nPhilosophers);
    final One2OneChannelInt[] right = One2OneChannelInt.create (nPhilosophers);

    final Any2OneChannelInt down = new Any2OneChannelInt ();
    final Any2OneChannelInt up = new Any2OneChannelInt ();

    final Fork[] fork = new Fork[nPhilosophers];
    for (int i = 0; i < nPhilosophers; i++) {
      fork[i] = new Fork (nPhilosophers, i,
                          left[i], right[(i + 1)%nPhilosophers], forkReport);
    }

    final Philosopher[] phil = new Philosopher[nPhilosophers];
    for (int i = 0; i < nPhilosophers; i++) {
      phil[i] = new Philosopher (i, left[i], right[i], down, up, philReport);
    }

    new Parallel (
      new CSProcess[] {
        new Parallel (phil),
        new Parallel (fork),
        new Security (down, up, securityReport, nPhilosophers - 1),
        new CollegeClock (clockReport, clockPeriod)
      }
    ).run ();

  }

}
