import jcsp.lang.*;
import java.awt.*;
import java.awt.event.*;

public class PanelControl implements CSProcess {
 
  private final AltingChannelInput fromPanel;
  private final ChannelOutput toPanel;
  private final ChannelOutputInt hold;
 
  public PanelControl (final AltingChannelInput fromPanel,
                       final ChannelOutput toPanel,
                       final ChannelOutputInt hold) {
    this.fromPanel = fromPanel;
    this.toPanel = toPanel;
    this.hold = hold;
  }

  public void run () {

    final PanelColour panelOff = new PanelColour (Color.lightGray);
    final PanelColour panelOn = new PanelColour (Color.green);

    boolean mousePresent = false;
    toPanel.write (panelOff);

    while (true) {

      switch (((MouseEvent) fromPanel.read ()).getID ()) {
        case MouseEvent.MOUSE_PRESSED:
          if (! mousePresent) {
            mousePresent = true;
            hold.write (0);
            toPanel.write (panelOn);
          } else {
            mousePresent = false;
            hold.write (0);
            toPanel.write (panelOff);
          }
        break;
      }

    }

  }

}
