import jcsp.lang.*;

public class MultiLaunchControl implements CSProcess {
 
  private final int interval;
  private final int start;
  private final AltingChannelInputInt abort;
  private final ChannelOutputInt cancel;
  private final AltingChannelInputInt hold;
  private final ChannelOutputInt countdown;
  private final ChannelOutputInt fire;
 
  public MultiLaunchControl (final int interval,
                             final int start,
                             final AltingChannelInputInt abort,
                             final ChannelOutputInt cancel,
                             final AltingChannelInputInt hold,
                             final ChannelOutputInt countdown,
                             final ChannelOutputInt fire) {
    this.interval = interval;
    this.start = start;
    this.abort = abort;
    this.cancel = cancel;
    this.hold = hold;
    this.countdown = countdown;
    this.fire = fire;
  }

  public void run () {

    final LaunchControl launchControl =
      new LaunchControl (start, abort, hold, countdown, fire);

    final CSTimer tim = new CSTimer ();
    final long seconds = 1000;

    final Alternative alt = new Alternative (new Guard[] {tim, hold});
    final int TIMEOUT = 0;
    final int HOLD = 1;

    hold.read ();                                         // start signal

    while (true) {

      cancel.write (0);                                   // enable abort

      launchControl.run ();
      int status = launchControl.getStatus ();

      cancel.write (status);                              // graceful
      if (status == LaunchControl.FIRED) abort.read ();   // reset

      boolean waiting = true;
      tim.setAlarm (tim.read () + (interval*seconds));

      while (waiting) {
        switch (alt.priSelect ()) {
          case TIMEOUT:
            waiting = false;
          break;
          case HOLD:
            hold.read ();
            fire.write (LaunchControl.HOLDING);
            hold.read ();
            fire.write (status);
          break;
        }
      }

    }

  }

}
