import jcsp.lang.*;
import jcsp.util.*;
import jcsp.util.ints.*;
import jcsp.awt.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class MissionControlNetwork implements CSProcess {

  final private int interval;
  final private int start;
  final private Dimension size;
  final private ActiveApplet panelApplet;

  class MyActiveButton extends ActiveButton {
    public MyActiveButton (String s) {
      super (s);
    }
    public Dimension getPreferredSize () {
      return new Dimension (100, 100);
    }
    public Dimension getMinimumSize () {
      return new Dimension (100, 100);
    }
    public Dimension getMaximumSize () {
      return new Dimension (100, 100);
    }
  }

  final private ActiveButton abortButton = new ActiveButton ("    abort    ");
  final private ActiveLabel countLabel = new ActiveLabel ("                   ");
  final private ActiveLabel rocketStatus = new ActiveLabel ("   Holding   ");

  public MissionControlNetwork (final int interval,
                                final int start,
                                final Dimension size,
                                final ActiveApplet panelApplet) {

    this.interval = interval;
    this.start = start;
    this.size = size;
    this.panelApplet = panelApplet;

    // panelApplet.setLayout (new GridLayout (5, 3));
    panelApplet.setLayout (new FlowLayout (FlowLayout.CENTER, 1000, 75));

    countLabel.setAlignment (Label.CENTER);
    countLabel.setBackground (Color.white);
    rocketStatus.setAlignment (Label.CENTER);
    rocketStatus.setBackground (Color.lightGray);
    // abortButton.requestSize (100, 100);
    abortButton.setEnabled (false);
    abortButton.setBackground (Color.orange);

    panelApplet.add (abortButton);
    panelApplet.add (countLabel);
    panelApplet.add (rocketStatus);

  }
    
  public void run () {

    final One2OneChannel mouseEvent = new One2OneChannel ();           // applet panel
    final One2OneChannel panelConfigure = new One2OneChannel ();       // channels

    final One2OneChannel abortEvent =
      One2OneChannel.create (new OverWriteOldestBuffer (1));           // abort button
    final One2OneChannel abortConfigure = new One2OneChannel ();       // channels

    final One2OneChannelInt hold = new One2OneChannelInt ();           // launch control
    final One2OneChannelInt cancel = new One2OneChannelInt ();         // channels
    final One2OneChannelInt abort =
      One2OneChannelInt.create (new OverWriteOldestBufferInt (1));
    final One2OneChannelInt countdown = new One2OneChannelInt ();
    final One2OneChannelInt fire = new One2OneChannelInt ();

    final One2OneChannel countdown2 = new One2OneChannel ();
    final One2OneChannel fire2 = new One2OneChannel ();

    panelApplet.addMouseEventChannel (mouseEvent);
    panelApplet.setConfigureChannel (panelConfigure);

    abortButton.addEventChannel (abortEvent);
    abortButton.setConfigureChannel (abortConfigure);

    countLabel.setConfigureChannel (countdown2);
    rocketStatus.setConfigureChannel (fire2);

    new Parallel (
      new CSProcess[] {
        panelApplet,
        new PanelControl (mouseEvent, panelConfigure, hold),
        abortButton,
        new AbortControl (abortEvent, abortConfigure, cancel, abort),
        countLabel,
        rocketStatus,
        new MultiLaunchControl (interval, start, abort, cancel, hold, countdown, fire),
        new CSProcess () {
          public void run () {
            final LabelColour white = new LabelColour (Color.white);
            while (true) {
              int n = countdown.read ();
              countdown2.write (white);
              countdown2.write ((new Integer (n)).toString ());
            }
          }
        },
        new CSProcess () {
          public void run () {
            final LabelColour rocketGreen = new LabelColour (Color.green);
            final LabelColour rocketLightGray = new LabelColour (Color.lightGray);
            final LabelColour rocketOrange = new LabelColour (Color.orange);
            while (true) {
              switch (fire.read ()) {
                case LaunchControl.FIRED:
                  fire2.write (rocketGreen);
                  fire2.write ("Fired");
                break;
                case LaunchControl.COUNTING:
                  fire2.write (rocketGreen);
                  fire2.write ("Counting");
                break;
                case LaunchControl.HOLDING:
                  fire2.write (rocketLightGray);
                  fire2.write ("Holding");
                break;
                case LaunchControl.ABORTED:
                  fire2.write (rocketOrange);
                  fire2.write ("Aborted");
                break;
              }
            }
          }
        }
      }
    ).run ();

  }

}
