import jcsp.lang.*;
import jcsp.awt.*;

import java.awt.*;

import phw.util.Ask;

public class MandelbrotMain extends ActiveApplet {

  public static final int minWidth = 800;
  public static final int minHeight = 350;

  public static final int maxWidth = 1024;
  public static final int maxHeight = 768;

  public void init () {
    setProcess (new MandelNetwork (this));
  }

  public static void main (String[] args) {

    System.out.println ("\nWelcome to Mandelbrot ...\n");

    final int width = Ask.Int ("width = ", minWidth, maxWidth);
    final int height = Ask.Int ("height = ", minHeight, maxHeight);
    System.out.println ();

    final ActiveClosingFrame activeClosingframe = new ActiveClosingFrame ("Mandelbrot Set");
    final ActiveFrame activeFrame = activeClosingframe.getActiveFrame ();
    activeFrame.setSize (width, height);

    final MandelNetwork mandelbrot = new MandelNetwork (activeFrame);

    activeFrame.pack ();
    activeFrame.setLocation ((maxWidth - width)/2, (maxHeight - height)/2);
    activeFrame.setVisible (true);
    activeFrame.toFront ();

    new Parallel (
      new CSProcess[] {
        activeClosingframe,
        mandelbrot
      }
    ).run ();

  }

}
