import phw.util.ComplexDouble;

class MandelPoint {

  protected int maxIterations;

  protected double radiusSquared;

  public MandelPoint (final int maxIterations, final int radius) {
    this.maxIterations = maxIterations;
    radiusSquared = (double) radius*radius;
  }

  public void setMaxIterations (final int maxIterations) {
    this.maxIterations = maxIterations;
  }

  public int compute (final ComplexDouble c) {
    int n = 0;
    ComplexDouble z = (ComplexDouble) c.clone ();
    double zModulusSquared = z.modulusSquared ();
    while ((n < maxIterations) && (zModulusSquared < radiusSquared)) {
      z.mult (z).add (c);
      zModulusSquared = z.modulusSquared ();
      n++;
    }
    return n;
  }

  public int compute (final double a, final double b) {
    int n = 0;
    double x = a;
    double y = b;
    double xSquared = x*x;
    double ySquared = y*y;
    while ((n < maxIterations) && ((xSquared + ySquared) < radiusSquared)) {
      double tmp = (xSquared - ySquared) + a;
      y = ((2.0d*x)*y) + b;
      x = tmp;
      xSquared = x*x;
      ySquared = y*y;
      n++;
    }
    return n;
  }
}
