import jcsp.awt.*;

class MandelPack implements Cloneable {

  public static final int STRIDE_SILENT = 5;

  public static final int SCROLL_SILENT = 0;
  public static final int SCROLL_UP = 1;
  public static final int SCROLL_DOWN = 2;
  public static final int NO_SCROLL = 3;

  public int maxIterations, scrolling;

  public double left, top, size;

  public GraphicsCommand colouring;

  public boolean ok;

  public int[] pixels;

  public void copy (final MandelPack p) {
    maxIterations = p.maxIterations;
    scrolling = p.scrolling;
    left= p.left;
    top = p.top;
    size = p.size;
    colouring = p.colouring;
    ok = p.ok;
    System.arraycopy (p.pixels, 0, pixels, 0, pixels.length);
  }

  public Object clone () {
    try {
      final MandelPack packet = (MandelPack) super.clone ();
      packet.pixels = (int[]) pixels.clone ();
      return packet;
    } catch (CloneNotSupportedException e) {
      System.out.println (e);
      System.exit (-1);
      return null;
    }
  }

}
