import jcsp.lang.*;
import jcsp.util.*;
import jcsp.awt.*;

import jcsp.lang.*;
import jcsp.util.*;
import jcsp.awt.*;

import java.awt.*;
import java.awt.image.*;

class MandelNetwork implements CSProcess {

  private final int nWorkers = 10;

  private final ActiveCanvas activeCanvas;
  private final MandelControl mandelControl;
  private final MandelFarmer mandelFarmer;
  private final MandelHarvester mandelHarvester;
  private final MandelWorker[] mandelWorker = new MandelWorker[nWorkers];
  private final ActiveChoice scrollChoice;
  private final ActiveChoice iterationsChoice;
  private final ActiveChoice targetChoice;
  private final ActiveChoice colourChoice;
  private final ActiveButton forwardButton;
  private final ActiveButton backwardButton;
  private final ActiveButton cancelButton;
  private final ActiveLabel[] infoLabel;

  public MandelNetwork (final Container parent) {

    final int minMaxIterations = 256;
    final int maxMaxIterations = 16*4096;

    // channels

    final One2OneChannel mouseChannel =
      One2OneChannel.create (new OverWriteOldestBuffer (10));
    final One2OneChannel mouseMotionChannel =
      One2OneChannel.create (new OverWriteOldestBuffer (1));
    final One2OneChannel keyChannel =
      One2OneChannel.create (new OverWriteOldestBuffer (10));

    final One2OneChannel farmer2harvester = new One2OneChannel ();
    final One2OneChannel harvester2farmer = new One2OneChannel ();

    final Any2OneChannel workers2farmer = new Any2OneChannel ();
    final One2OneChannel farmer2workers = new One2OneChannel ();

    final Any2OneChannel workers2harvester = new Any2OneChannel ();
    final One2OneChannel harvester2workers = new One2OneChannel ();

    final One2OneChannel request = new One2OneChannel ();
    final One2OneChannel reply = new One2OneChannel ();

    final One2OneChannel toGraphics = new One2OneChannel ();
    final One2OneChannel fromGraphics = new One2OneChannel ();

    // processes

    parent.setLayout (new BorderLayout ());
    parent.setBackground (Color.black);

    activeCanvas = new ActiveCanvas ();
    activeCanvas.addMouseEventChannel (mouseChannel);
    activeCanvas.addMouseMotionEventChannel (mouseMotionChannel);
    activeCanvas.addKeyEventChannel (keyChannel);
    activeCanvas.setGraphicsChannels (toGraphics, fromGraphics);
    activeCanvas.setSize (parent.getSize ());

    // If the parent is an applet, the above setSize has no effect and the activeCanvas
    // is fitted to the "Center" area (see below) of the applet's panel.

    // If the parent is a frame, the above *does* define the size of the activeCanvas
    // and the size of the parent is expanded to wrap around when it is packed.

    parent.add ("Center", activeCanvas);

    // menus

    final Panel south = new Panel ();
    south.setBackground (Color.green);

    final One2OneChannel backwardChannel =
      One2OneChannel.create (new OverWriteOldestBuffer (1));
    final One2OneChannel backwardConfigure = new One2OneChannel ();
    backwardButton = new ActiveButton (backwardConfigure, backwardChannel, "Backward");
    backwardButton.setBackground (Color.white);
    backwardButton.setEnabled (false);
    south.add (backwardButton);

    final One2OneChannel forwardChannel =
      One2OneChannel.create (new OverWriteOldestBuffer (1));
    final One2OneChannel forwardConfigure = new One2OneChannel ();
    forwardButton = new ActiveButton (forwardConfigure, forwardChannel, "Forward");
    forwardButton.setBackground (Color.white);
    forwardButton.setEnabled (false);
    south.add (forwardButton);

    // south.add (new Label ("      ", Label.CENTER));    // padding

    final One2OneChannel scrollChannel =
      One2OneChannel.create (new OverWriteOldestBuffer (1));
    final One2OneChannel scrollConfigure = new One2OneChannel ();
    scrollChoice = new ActiveChoice (scrollConfigure, scrollChannel);
    final String[] scrollMenu = {"Silent", "Up", "Down", "None"};
    for (int i = 0; i < scrollMenu.length; i++) {
      scrollChoice.add (scrollMenu[i]);
    }
    south.add (new Label ("Scrolling", Label.CENTER));
    south.add (scrollChoice);

    final One2OneChannel iterationsChannel =
      One2OneChannel.create (new OverWriteOldestBuffer (1));
    final One2OneChannel iterationsConfigure = new One2OneChannel ();
    iterationsChoice = new ActiveChoice (iterationsConfigure, iterationsChannel);
    final String[] iterationsMenu = {"256", "512", "1K", "2K", "4K", "8K", "16K", "32K", "64K"};
    for (int i = 0; i < iterationsMenu.length; i++) {
      iterationsChoice.add (iterationsMenu[i]);
    }
    south.add (new Label ("Iterations", Label.CENTER));
    south.add (iterationsChoice);

    final One2OneChannel targetChannel =
      One2OneChannel.create (new OverWriteOldestBuffer (1));
    final One2OneChannel targetConfigure = new One2OneChannel ();
    targetChoice = new ActiveChoice (targetConfigure, targetChannel);
/*
    final String[] targetMenu = {"White", "Black", "Xor"};
*/
    final String[] targetMenu = {"White", "Black"};
    for (int i = 0; i < targetMenu.length; i++) {
      targetChoice.add (targetMenu[i]);
    }
    south.add (new Label ("Target", Label.CENTER));
    south.add (targetChoice);

    final One2OneChannel colourChannel =
      One2OneChannel.create (new OverWriteOldestBuffer (1));
    final One2OneChannel colourConfigure = new One2OneChannel ();
    colourChoice = new ActiveChoice (colourConfigure, colourChannel);
    final String[] colourMenu = {"Step", "Fade"};
    for (int i = 0; i < colourMenu.length; i++) {
      colourChoice.add (colourMenu[i]);
    }
    south.add (new Label ("Colours", Label.CENTER));
    south.add (colourChoice);

    south.add (new Label ("      ", Label.CENTER));    // padding

    final One2OneChannel cancelChannel =
      One2OneChannel.create (new OverWriteOldestBuffer (1));
    final One2OneChannel cancelConfigure = new One2OneChannel ();
    cancelButton = new ActiveButton (cancelConfigure, cancelChannel, "Cancel");
    cancelButton.setBackground (Color.white);
    cancelButton.setEnabled (false);
    south.add (cancelButton);

    parent.add ("South", south);

    // labels

    final Panel north = new Panel ();
    north.setBackground (Color.green);

    final String[] infoTitle = {"Top", "Left", "Scale"};
    final String[] infoWidth = {"XXXXXXXXXXXXXXXXXXXXXX",
                                "XXXXXXXXXXXXXXXXXXXXXX",
                                "XXXXXXXXXXXXXXXXXXXXXX"};
    final One2OneChannel[] infoConfigure = One2OneChannel.create (infoTitle.length);
    infoLabel = new ActiveLabel[infoTitle.length];
    for (int i = 0; i < infoTitle.length; i++) {
      infoLabel[i] = new ActiveLabel (infoConfigure[i], infoWidth[i]);
      infoLabel[i].setAlignment (Label.CENTER);
      infoLabel[i].setBackground (Color.white);
      north.add (new Label (infoTitle[i], Label.CENTER));
      north.add (infoLabel[i]);
    }

    parent.add ("North", north);

    mandelControl=
      new MandelControl (minMaxIterations, maxMaxIterations,
                         mouseChannel, mouseMotionChannel, keyChannel,
                         scrollConfigure, scrollChannel, scrollMenu,
                         iterationsConfigure, iterationsChannel, iterationsMenu,
                         targetConfigure, targetChannel, targetMenu,
                         colourConfigure, colourChannel, colourMenu,
                         forwardConfigure, forwardChannel,
                         backwardConfigure, backwardChannel,
                         infoConfigure,
                         request, reply, toGraphics, fromGraphics);

    mandelFarmer =
      new MandelFarmer (request, harvester2farmer, farmer2harvester,
                        cancelChannel, cancelConfigure,
                        workers2farmer, farmer2workers);

    mandelHarvester =
      new MandelHarvester (reply, farmer2harvester, harvester2farmer,
                           workers2harvester, harvester2workers,
                           toGraphics, fromGraphics);

    for (int i = 0; i < nWorkers; i++) {
      mandelWorker[i] =
        new MandelWorker (i, minMaxIterations, maxMaxIterations,
                          farmer2workers, workers2farmer,
                          harvester2workers, workers2harvester);
    }

  }

  public void run () {

/*   
    new Parallel (
      new CSProcess[] {
        activeCanvas,
        mandelControl,
        mandelFarmer,
        mandelHarvester,
        new Parallel (mandelWorker),
        scrollChoice,
        iterationsChoice,
        targetChoice,
        colourChoice,
        forwardButton,
        backwardButton,
        cancelButton,
        new Parallel (infoLabel)
      }
    ).run ();
*/

    // this is a workaround for a strange bug when running this as an applet in JDK1.2.x.
    // That bug does not allow nested Parallels within applets ... as in the above code!

    final CSProcess[] some = {activeCanvas, mandelControl, mandelFarmer, mandelHarvester,
                              scrollChoice, iterationsChoice, targetChoice, colourChoice,
                              forwardButton, backwardButton, cancelButton};
    final CSProcess[] all = new CSProcess[some.length + mandelWorker.length + infoLabel.length];
    System.arraycopy (some, 0, all, 0, some.length);
    System.arraycopy (mandelWorker, 0, all, some.length, mandelWorker.length);
    System.arraycopy (infoLabel, 0, all, some.length + mandelWorker.length, infoLabel.length);

    new Parallel (all).run ();

  }

}
