import jcsp.lang.*;
import jcsp.plugNplay.*;

public final class MultiplexExample {

  public static void main (String[] argv) {

    final One2OneChannel[] a = One2OneChannel.create (3);
    final One2OneChannel b = new One2OneChannel ();

    new Parallel (
      new CSProcess[] {
        new Numbers (a[0]),
        new Fibonacci (a[1]),
        new Squares (a[2]),
        new Multiplex (a, b),
        new CSProcess () {
          public void run () {
            String[] key = {"Numbers ",
                            "            Fibonacci ",
                            "                          Squares "};
            while (true) {
              int channel = ((Integer) b.read ()).intValue ();
              System.out.print (key[channel]);     // print channel source
              int n = ((Integer) b.read ()).intValue ();
              System.out.println (n);              // print multiplexed data
            }
          }
        }
      }
    ).run ();

  }

}
