import jcsp.lang.*;

public class TimeKeeper implements CSProcess {

  private final long interval;
  private final Barrier barrier;

  public TimeKeeper (long interval, Barrier barrier) {
    this.interval = interval;
    this.barrier = barrier;
  }

  public void run () {

    final CSTimer tim = new CSTimer ();
    long timeout = tim.read () + interval;

    // System.out.println ("TimeKeeper starting work ...");

    while (true) {
      tim.after (timeout);
      barrier.sync ();
      System.out.println ("[" + (tim.read () - timeout) + "]");
      barrier.sync ();
      timeout += interval;
    }
  }

}
