/*******************************************************************************
 *
 * $Archive: /jcsp/src/test/jcsp/BlocksTest.java $
 *
 * $Date: 1998/07/21 14:17:10 $
 *
 * $Revision: 1.1 $
 *
 * (C) Copyright 1997/8 Paul Austin <pda1@ukc.ac.uk>
 * University of Kent Canterbury
 ******************************************************************************/
package test.jcsp;

import jcsp.lang.*;
import jcsp.plugNplay.ints.*;
import jcsp.util.ints.*;

/**
 * <H2>Process Diagram</H2>
 * <H3>External View</H3>
 * <PRE>
 *  ________________
 * |                |
 * | SquaresIntTest |
 * |________________|
 * </PRE>
 * <H3>Internal View</H3>
 * <PRE>
 *  ____________________________________________________
 * |                                                    |
 * |  ______________       ________       ____________  |
 * | |              |  a  |        |  b  |            | |
 * | |  <A HREF="jcsp.plugNplay.ints.SquaresInt.html">SquaresInt</A>  |-->--|  <I>anon</I>  |-->--| <A HREF="jcsp.plugNplay.ints.PrinterInt.html">PrinterInt</A> | |
 * | |______________|     |________|     |____________| |
 * |                                                    |
 * |                                         BlocksTest |
 * |____________________________________________________|
 * </PRE>
 * <P>
 * <H2>Description</H2>
 * The BlocksTest process is designed to test some of the plugNplay processes.
 * <P>
 * <H2><A HREF="SquaresIntTest.java.doc">Sourcecode</A></H2>
 *
 * @author P.D.Austin and P.H.Welch
 */

public class SquaresIntTest implements CSProcess {
  /**
   * The main body of this process.
   */
  public void run () {

    final ChannelInt a = new One2OneChannelInt ();
    final ChannelInt b = new One2OneChannelInt ();

    new Parallel (
      new CSProcess[] {
        new SquaresInt (a),
        new CSProcess () {
          public void run () {    // this anonymous process 
            int n = a.read ();    // terminates when the numbers
            while (n > 0) {       // overflow, deadlocking
              b.write (n);        // the pipeline of which
              n = a.read ();      // it is a component.
            }
          }
        },
        new PrinterInt (b, "Perfect squares ==> ", "\n")
      }
    ).run ();
  }

  /**
   * Main entry point for the application.
   */
  public static void main (String argv[]) {
    new SquaresIntTest ().run ();
  }

}
