import jcsp.lang.*;

public class SampleProtocol {

  public static final int NOTHING_IN_PARTICULAR = 0;
  public static final int                STRING = 1;
  public static final int               INTEGER = 2;
  public static final int               COMPLEX = 3;
  public static final int        BOO_TO_A_GOOSE = 4;

  static public class NothingInParticular extends TaggedProtocol {
    public NothingInParticular () {
      super (NOTHING_IN_PARTICULAR);
    }
  }

  static public class String extends TaggedProtocol {
    public final java.lang.String string;
    public String (final java.lang.String string) {
      super (STRING);
      this.string = string;
    }
  }

  static public class Integer extends TaggedProtocol {
    public final int value;
    public Integer (final int value) {
      super (INTEGER);
      this.value = value;
    }
  }

  static public class Complex extends TaggedProtocol {
    public final float real;
    public final float imag;
    public Complex (final float real, final float imag) {
      super (COMPLEX);
      this.real = real;
      this.imag = imag;
    }
  }

  static public class BooToAGoose extends TaggedProtocol {
    public BooToAGoose () {
      super (BOO_TO_A_GOOSE);
    }
 } 

}
