import jcsp.lang.*;

public class ProcessManagerExample2 {

  public static void main (String[] argv) {

    final ProcessManager manager = new ProcessManager (
      new CSProcess () {
        public void run () {
          final CSTimer tim = new CSTimer ();
          long timeout = tim.read ();
          int count = 0;
          while (true) {
            System.out.println (count + " :-) managed process running ...");
            count++;
            timeout += 100;
            tim.after (timeout);   // every 1/10th of a second ...
          }
        }
      }
    );

    System.out.println ("\n\n\t\t\t\t\t*** start the managed process");
    manager.start ();

    final CSTimer tim = new CSTimer ();
    long timeout = tim.read ();

    for (int i = 0; i < 5; i++) {
      timeout += 2000;
      tim.after (timeout);         // after 2 seconds ...
      System.out.println (
        "\n\n\t\t\t\t\t*** suspend the managed process (" + i + "/" + 4 + ")"
      );
      manager.suspend ();
      timeout += 2000;
      tim.after (timeout);         // after 2 more seconds ...
      manager.resume ();
    }

    timeout += 2000;
    tim.after (timeout);           // after 2 more seconds ...
    System.out.println ("\n\n\t\t\t\t\t*** stop the managed process");
    manager.stop ();
    System.out.println ("\n\n\t\t\t\t\t*** and finish myself!");

  }

}
