import jcsp.lang.*;

public class ProcessManagerExample1_ss {

  private static class SelfStarter implements CSProcess {

    public SelfStarter () {
      synchronized (this) {
        new ProcessManager (this).start ();
      }
    }

    public void run () {
      final CSTimer tim = new CSTimer ();
      long timeout = tim.read ();
      int count = 0;
      while (true) {
        System.out.println (count + " :-) managed process running ...");
        count++;
        timeout += 100;
        tim.after (timeout);         // every 1/10th of a second ...
      }
    }

  }

  public static void main (String[] argv) {

    System.out.println ("\n\n\t\t\t\t\t*** constructing the managed and self-starting process");
    SelfStarter selfStarter = new SelfStarter ();

    final CSTimer tim = new CSTimer ();
    long timeout = tim.read ();

    for (int i = 0; i < 10; i++) {
      System.out.println ("\n\n\t\t\t\t\t*** I'm still executing as well");
      timeout += 1000;
      tim.after (timeout);         // every second ...
    }

    System.out.println ("\n\n\t\t\t\t\t*** I'm finishing now!");

  }

}
