import jcsp.lang.*;

public class ProcessManagerExample {

  public static void main (String[] argv) {

    ProcessManager manager = new ProcessManager (
      new CSProcess () {
        public void run () {
          int count = 0;
          while (true) {
            System.out.println (count + " :-) managed process running ...");
            count++;
          }
        }
      }
    );

    System.out.println ("*** start the managed process");
    manager.start ();
    CSTimer tim = new CSTimer ();
    long timeout = tim.read ();
    for (int i = 0; i < 5; i++) {
      timeout += 2000;
      tim.after (timeout);         // after 2 seconds ...
      System.out.println ("*** suspend the managed process (" + i + "/" + 4 + ")");
      // synchronized (System.out) {
        manager.suspend ();
      // }
      timeout += 5000;
      tim.after (timeout);         // after 5 more seconds ...
      // System.out.println ("*** resume the managed process (" + i + "/" + 4 + ")");
      manager.resume ();
    }
    timeout += 2000;
    tim.after (timeout);           // after 2 more seconds ...
    // System.out.println ("*** stop the managed process");
    // manager.stop ();
    System.out.println ("/n/n*** and finish myself!");
  }

}
