import jcsp.lang.*;

public class LaunchControlTest {

  public static void main (String[] args) {

    final int startCount = 50;

    final long seconds = 1000;
    final long abortTime = 85*seconds;
    final long holdEvery = 11*seconds;
    final long holdTime = 9*seconds;

    // Note: in the following, the public address system will become deadlocked
    // if the launch is aborted before the count reaches zero.  Similarly, if the
    // abortTime is set higher than the total countdown time (including holds),
    // the safety officer #1 will get stuck when he attempts an abortion after
    // the launch.  Also, safety officer #2 attempts to loop indefinitely putting
    // the launch on hold for a short period.  After launch or abortion, he will
    // also become blocked at the next attempted hold.

    // These issues are not hard to address - see the MissionControl applet demonstration.

    final One2OneChannelInt countdown = new One2OneChannelInt ();
    final One2OneChannelInt abort = new One2OneChannelInt ();
    final One2OneChannelInt hold = new One2OneChannelInt ();
    final One2OneChannelInt fire = new One2OneChannelInt ();

    new Parallel (
      new CSProcess[] {
        new LaunchControl (startCount, abort, hold, countdown, fire),
        new CSProcess () {                                          // public address
          public void run () {
            int count = countdown.read ();
            while (count > 0) {
              System.out.println ("\tCountdown: " + count + " seconds and counting ...");
              count = countdown.read ();
            }
            System.out.println ("\tCountdown: " + count + " ...");
          }
        },
        new CSProcess () {                                          // fire control
          public void run () {
            boolean counting = true;
            while (counting) {
              switch (fire.read ()) {
                case LaunchControl.HOLDING:
                  System.out.println ("fire control: HOLDING ... Enterprise is on hold ...");
                  fire.read ();
                  System.out.println ("fire control: COUNTING ... Enterprise is back on-line ...");
                break;
                case LaunchControl.ABORTED:
                  System.out.println ("fire control: ABORT-ABORT-ABORT ... Enterprise is standing down ...");
                  counting = false;
                break;
                case LaunchControl.FIRED:
                  System.out.println ("fire control: WE HAVE LIFT-OFF ... Enterprise is go ...");
                  counting = false;
                break;
              }
            }
          }
        },
        new CSProcess () {                                          // safety officer #1
          public void run () {
            CSTimer tim = new CSTimer ();
            long t = tim.read ();
            tim.after (t + abortTime);
            System.out.println ("safety officer #1: Who pressed that big red button ... ?!! ... !!! ...");
            abort.write (0);
          }
        },
        new CSProcess () {                                          // safety officer #2
          public void run () {
            CSTimer tim = new CSTimer ();
            long t = tim.read () + holdEvery;
            while (true) {
              tim.after (t);
              System.out.println ("safety officer #2: HOLD - HOLD - HOLD ...");
              hold.write (0);
              t += holdTime;
              tim.after (t);
              System.out.println ("safety officer #2: RELEASE - RELEASE - RELEASE ...");
              hold.write (0);
              t += holdEvery;
            }
          }
        }
      }
    ).run ();

  }

}
