import jcsp.lang.*;

public class Consumer implements CSProcess {

  private final ChannelInput in;

  public Consumer (ChannelInput in) {
    this.in = in;
  }

  public void run () {

    boolean running = true;

    while (running) {

      TaggedProtocol tp = (TaggedProtocol) in.read ();

      switch (tp.tag) {
         case SampleProtocol.NOTHING_IN_PARTICULAR:
           System.out.println ("==> NothingInParticular happening ...");
         break;
         case SampleProtocol.STRING:
           SampleProtocol.String sms = (SampleProtocol.String) tp;
           System.out.println ("==> \"" + sms.string + "\"");
         break;
         case SampleProtocol.INTEGER:
           SampleProtocol.Integer smi = (SampleProtocol.Integer) tp;
           System.out.println ("==> " + smi.value);
         break;
         case SampleProtocol.COMPLEX:
           SampleProtocol.Complex smc = (SampleProtocol.Complex) tp;
           System.out.println ("==> [" + smc.real + ", " + smc.imag + "]");
         break;
         case SampleProtocol.BOO_TO_A_GOOSE:
           System.out.println ("==> Waaaaaa!  You scared me!!  I'm off!!!");
           running = false;
         break;
      }

    }

  }

}
