import java.awt.*;
import java.awt.event.*;
import jcsp.lang.*;
import jcsp.awt.*;

public class Picasso implements CSProcess {

  final protected AltingChannelInput mouseEvent;
  final protected AltingChannelInput mouseMotionEvent;
  final protected ChannelOutput toGraphics;
  final protected ChannelInput fromGraphics;

  public Picasso (AltingChannelInput mouseEvent, AltingChannelInput mouseMotionEvent,
                  ChannelOutput toGraphics, ChannelInput fromGraphics) {
    this.mouseEvent = mouseEvent;
    this.mouseMotionEvent = mouseMotionEvent;
    this.toGraphics = toGraphics;
    this.fromGraphics = fromGraphics;
  }

  final protected DisplayList display = new DisplayList ();

  final protected String clickMessage = "C L I C K   T H E   M O U S E   T O   D R A W";
  final protected String clickPlea = "P L E A S E   M O V E   T H E   M O U S E   B A C K";

  final protected GraphicsCommand[] mouseEntered =          // fixed commands
    {new GraphicsCommand.SetColor (Color.cyan),
     new GraphicsCommand.FillRect (0, 0, 600, 400),
     new GraphicsCommand.SetColor (Color.black),
     new GraphicsCommand.DrawString (clickMessage, 180, 200)};

  final protected GraphicsCommand[] mouseExited =           // fixed commands
    {new GraphicsCommand.SetColor (Color.pink),
     new GraphicsCommand.FillRect (0, 0, 600, 400),
     new GraphicsCommand.SetColor (Color.black),
     new GraphicsCommand.DrawString (clickPlea, 160, 200)};

  final protected GraphicsCommand[] mouseDrawLine = {null};  // filled in dynamically

  final protected int targetSize = 50;
  final protected GraphicsCommand[] mouseTarget = {null};    // filled in dynamically

  protected Point point = new Point ();
  protected boolean drawing = false;
  protected boolean targetting = false;

  protected void handleMouseEvent (final MouseEvent event) {
    switch (event.getID ()) {
      case MouseEvent.MOUSE_ENTERED:
        display.change (mouseEntered, 0);
      break;
      case MouseEvent.MOUSE_EXITED:
        display.change (mouseExited, 0);
      break;
      case MouseEvent.MOUSE_PRESSED:
        int modifiers = event.getModifiers ();
        if ((modifiers & InputEvent.BUTTON1_MASK) != 0) {
          if (targetting) {
            targetting = false;
            display.set (mouseEntered);
          }
          drawing = ! drawing;
          if (drawing) point = event.getPoint ();
        } else
        if ((modifiers & InputEvent.BUTTON2_MASK) != 0) {
          drawing = false;
          targetting = ! targetting;
          display.set (mouseEntered);
          if (targetting) {
            point = event.getPoint ();
            mouseTarget[0] =
              new GraphicsCommand.DrawRect (
                point.x - (targetSize/2),
                point.y - (targetSize/2),
                targetSize, targetSize
              );
            display.extend (mouseTarget);
          }
        }
        if ((modifiers & InputEvent.BUTTON3_MASK) != 0) {
          drawing = false;
          targetting = false;
          display.set (mouseEntered);
        }
      break;
    }
  }

  protected void handleMouseMotionEvent (final MouseEvent motion) {
    final Point newPoint = motion.getPoint ();
    if (drawing) {
      mouseDrawLine[0] =
        new GraphicsCommand.DrawLine (point.x, point.y, newPoint.x, newPoint.y);
      point = newPoint;
      display.extend (mouseDrawLine);
    } else {
      mouseTarget[0] =
        new GraphicsCommand.DrawRect (newPoint.x - (targetSize/2),
                                      newPoint.y - (targetSize/2),
                                      targetSize, targetSize);
      display.change (mouseTarget, mouseEntered.length);
    }
  }

  public void run () {
    final AltingChannelInput[] mouse = {mouseEvent, mouseMotionEvent};
    final boolean[] preCondition = {true, false};
    final Alternative alt = new Alternative (mouse);
    toGraphics.write (new GraphicsProtocol.SetPaintable (display));
    fromGraphics.read ();
    display.set (mouseExited);
    while (true) {
      preCondition[1] = drawing | targetting;
      switch (alt.select (preCondition)) {
        case 0:
          handleMouseEvent ((MouseEvent) mouseEvent.read ());
        break;
        case 1:
          handleMouseMotionEvent ((MouseEvent) mouseMotionEvent.read ());
        break;
      }
    }
  }

}
