import java.awt.*;
import java.awt.event.*;
import jcsp.lang.*;
import jcsp.util.*;
import jcsp.awt.*;

public class ActivePanelExample {

  public static void main (String argv[]) {

    final Frame root = new Frame ("ActivePanel Example");

    final One2OneChannel mouseEvent =
      One2OneChannel.create (new OverWriteOldestBuffer (10));

    final ActivePanel panel = new ActivePanel ();
    panel.addMouseEventChannel (mouseEvent);

    root.setSize (400, 400);
    root.add (panel);
    root.setVisible (true);

    new Parallel (
      new CSProcess[] {
        panel,
        new CSProcess () {
          public void run () {
            final long FREE_TIME = 10000;
            final long BUSY_TIME = 1000;
            CSTimer tim = new CSTimer ();
            Alternative alt = new Alternative (new Guard[] {tim, mouseEvent});
            long timeout = tim.read ();
            tim.setAlarm (timeout + FREE_TIME);
            boolean running = true;
            while (running) {
              switch (alt.priSelect ()) {
                case 0:  // timeout happened
                  for (int i = 10; i > 0; i--) {
                    System.out.println ("*** busy busy busy ... " + i);
                    timeout = tim.read ();
                    tim.after (timeout + BUSY_TIME);
                  }
                  System.out.println ("*** free free free ... 0");
                  timeout = tim.read ();
                  tim.setAlarm (timeout + FREE_TIME);
                break;
                case 1:  // mouseEvent happened
                  switch (((MouseEvent) mouseEvent.read ()).getID ()) {
                    case MouseEvent.MOUSE_ENTERED:
                      System.out.println ("MOUSE_ENTERED");
                    break;
                    case MouseEvent.MOUSE_EXITED:
                      System.out.println ("MOUSE_EXITED");
                    break;
                    case MouseEvent.MOUSE_PRESSED:
                      System.out.println ("MOUSE_PRESSED");
                    break;
                    case MouseEvent.MOUSE_RELEASED:
                      System.out.println ("MOUSE_RELEASED");
                    break;
                    case MouseEvent.MOUSE_CLICKED:
                      System.out.println ("MOUSE_CLICKED ... goodbye!");
                      running = false;
                    break;
                  }
                break;
              }
            }
            root.setVisible (false);
            System.exit (0);
          }
        }
      }
    ).run ();
  }

}
