import java.awt.*;
import java.awt.event.*;
import jcsp.lang.*;
import jcsp.util.*;
import jcsp.awt.*;

public class ActiveMenuExample2 {

  public static void main (String argv[]) {

    final ActiveClosingFrame activeClosingFrame =
      new ActiveClosingFrame ("ActiveMenuExample Example");

    final ActiveFrame frame = activeClosingFrame.getActiveFrame ();

    final MenuBar menuBar = new MenuBar ();
    frame.setMenuBar (menuBar);

    final Menu fileMenu = new Menu ("File");
    menuBar.add (fileMenu);

    final String[] fileOptions = {"Hello World", "Rocket Science", "CSP",
                                  "Monitors", "Ignore Me", "Goodbye World"};

    final Channel event[] =
      Any2OneChannel.create (3, new OverWriteOldestBuffer (10));

    final ActiveMenuItem[] fileMenuItem =
      new ActiveMenuItem[fileOptions.length];
    for (int i = 0; i < fileOptions.length; i++) {
      fileMenuItem[i] = new ActiveMenuItem (null, event[0], fileOptions[i]);
      fileMenu.add (fileMenuItem[i]);
    }

    fileMenu.addSeparator ();

    final Any2OneChannel langConfigure = new Any2OneChannel ();
    final ActiveMenu langMenu = new ActiveMenu (langConfigure, event[2], "Language");
    fileMenu.add (langMenu);  // set up the active langMenu as a sub-menu

    final String[] langOptions = {"occam", "Java", "Smalltalk", "Algol-60",
                                  "Pascal", "Haskell", "SML", "Lisp"};

    final ActiveCheckboxMenuItem[] langCheckboxMenuItem =
      new ActiveCheckboxMenuItem[langOptions.length];
    for (int i = 0; i < langOptions.length; i++) {
      langCheckboxMenuItem[i] =
        new ActiveCheckboxMenuItem (null, event[1], langOptions[i]);
      langMenu.add (langCheckboxMenuItem[i]);
    }      

    frame.setSize (700, 350);
    frame.setBackground (Color.green);
    frame.setVisible (true);

    new Parallel (
      new CSProcess[] {     // don't forget to include all active processes
        langMenu,
        activeClosingFrame,
        new Parallel (fileMenuItem),
        new Parallel (langCheckboxMenuItem),
        new CSProcess () {
          public void run () {
            boolean running = true;
            while (running) {
              final String s = (String) event[0].read ();
              System.out.println ("File ==> `" + s + "' selected ...");
              if (s == fileOptions[0]) {
                langConfigure.write (Boolean.TRUE);
                System.out.println ("`Language' enabled ...");
              }
              running = (s != fileOptions[fileOptions.length - 1]);
            }
            frame.setVisible (false);
            System.exit (0);
          }
        },
        new CSProcess () {
          public void run () {
            while (true) {
              final ItemEvent e = (ItemEvent) event[1].read ();
              final String item = (String) e.getItem ();
              System.out.print ("Language ==> `" + item);
              if (e.getStateChange () == ItemEvent.SELECTED) {
                System.out.println ("' selected ...");
                if (item == langOptions[0]) {
                  langConfigure.write (Boolean.FALSE);
                  System.out.println ("`Language' disabled ...");
                }
              } else {
                System.out.println ("' deselected ...");
              }
            }
          }
        },
        new CSProcess () {
          public void run () {
            boolean running = true;
            while (running) {
              final String s = (String) event[2].read ();
              System.out.println ("Sub-menu ==> `" + s + "' selected ...");
            }
          }
        }
      }
    ).run ();

  }

}
