import java.awt.*;
import java.awt.event.*;
import jcsp.lang.*;
import jcsp.util.*;
import jcsp.awt.*;

public class ActiveFrameButtonExample {

  public static void main (String argv[]) {

    final Channel windowEvent =
      Any2OneChannel.create (new OverWriteOldestBuffer (10));

    final ActiveFrame frame =
      new ActiveFrame (null, windowEvent, "ActiveFrameButton Example");

    final String[] label = {"Hello World", "Rocket Science", "CSP",
                            "Monitors", "Ignore Me", "Goodbye World"};

    final Channel buttonEvent =
      Any2OneChannel.create (new OverWriteOldestBuffer (10));

    final ActiveButton[] button = new ActiveButton[label.length];
    for (int i = 0; i < label.length; i++) {
      button[i] = new ActiveButton (null, buttonEvent, label[i]);
    }

    frame.setSize (300, 200);
    frame.setLayout (new GridLayout (label.length/2, 2));
    for (int i = 0; i < label.length; i++) {
      frame.add (button[i]);
    }
    frame.setVisible (true);

    new Parallel (
      new CSProcess[] {
        new Parallel (button),
        new CSProcess () {                 // respond to window events
          public void run () {
            boolean running = true;
            while (running) {
              final WindowEvent w = (WindowEvent) windowEvent.read ();
              switch (w.getID ()) {
                case WindowEvent.WINDOW_CLOSING:
                  System.out.println ("*** WINDOW_CLOSING ...");
                  running = false;
                break;
                default:
                  System.out.println (w);
                break;
              }
            }
            frame.setVisible (false);
            System.exit (0);
          }
        },
        new CSProcess () {                 // respond to button events
          public void run () {
            boolean running = true;
            while (running) {
              final String s = (String) buttonEvent.read ();
              System.out.println ("Button `" + s + "' pressed ...");
              running = (s != label[label.length - 1]);
            }
            frame.setVisible (false);
            System.exit (0);
          }
        }
      }
    ).run ();

  }

}
