import java.awt.*;
import jcsp.lang.*;
import jcsp.util.*;
import jcsp.awt.*;

public class ActiveFileDialogExample {

  public static void main (String argv[]) {

    final Frame root = new Frame ();

    final Channel configure = new One2OneChannel ();

    final Channel event =
      One2OneChannel.create (new OverWriteOldestBuffer (10));

    final ActiveFileDialog fileDialog =
      new ActiveFileDialog (configure, event, root, "ActiveFileDialog Example");

    new Parallel (
      new CSProcess[] {
        fileDialog,
        new CSProcess () {
          public void run () {
            String dir = "C:\\";  // start directory for the file dialogue
            String file = "";
            while (file != null) {
              configure.write (dir);
              configure.write (Boolean.TRUE);
              dir = (String) event.read ();
              file = (String) event.read ();
              if (file != null)
                System.out.println ("Chosen file = `" + dir + file + "'");
            }
          System.exit (0);
          }
        }
      }
    ).run ();
  }

}
