import java.awt.*;
import java.awt.event.*;
import jcsp.lang.*;
import jcsp.util.*;
import jcsp.awt.*;

public class ActiveChoiceExample {

  public static void main (String argv[]) {

    final Frame root = new Frame ("ActiveChoice Example");

    final Channel close =
      One2OneChannel.create (new OverWriteOldestBuffer (1));

    final ActiveChoice choice = new ActiveChoice (null, close);

    final String[] menu = {"Hello World", "Rocket Science", "CSP",
                           "Monitors", "Ignore Me", "Goodbye World"};

    for (int i = 0; i < menu.length; i++) {
      choice.add (menu[i]);
    }

    root.setSize (300, 100);
    root.add (choice);
    root.setVisible (true);

    new Parallel (
      new CSProcess[] {
        choice,
        new CSProcess () {
          public void run () {
            boolean running = true;
            while (running) {
              final ItemEvent e = (ItemEvent) close.read ();
              final String item = (String) e.getItem ();
              System.out.println ("Selected ==> `" + item + "'");
              running = (item != menu[menu.length - 1]);
            }
            root.setVisible (false);
            System.exit (0);
          }
        }
      }
    ).run ();

  }

}
