import java.awt.*;
import java.awt.event.*;
import jcsp.lang.*;
import jcsp.util.*;
import jcsp.awt.*;

public class ActiveCheckboxExample2 {

  public static void main (String argv[]) {

    final Frame root = new Frame ("ActiveCheckbox Example 2");

    final String[] box = {"Hello World", "Rocket Science", "CSP",
                          "Monitors", "Ignore Me", "Goodbye World"};

    final Channel event =
      Any2OneChannel.create (new OverWriteOldestBuffer (10));

    final Channel[] config = One2OneChannel.create (box.length);

    final ActiveCheckbox[] check = new ActiveCheckbox[box.length];
    for (int i = 0; i < box.length; i++) {
      check[i] = new ActiveCheckbox (config[i], event, box[i]);
    }

    root.setSize (300, 200);
    root.setLayout (new GridLayout (box.length, 1));
    for (int i = 0; i < box.length; i++) {
      root.add (check[i]);
    }
    root.setVisible (true);

    new Parallel (
      new CSProcess[] {
        new Parallel (check),
        new CSProcess () {
          public void run () {
            final ActiveCheckbox.Configure red =
              new ActiveCheckbox.Configure () {
                public void configure (final Checkbox checkbox) {
                  checkbox.setBackground (Color.red);
                }
              };
            final ActiveCheckbox.Configure green =
              new ActiveCheckbox.Configure () {
                public void configure (final Checkbox checkbox) {
                  checkbox.setBackground (Color.green);
                }
              };
            for (int i = 0; i < box.length; i++) {
              config[i].write (red);
            }
            boolean running = true;
            while (running) {
              final ItemEvent e = (ItemEvent) event.read ();
              final String item = (String) e.getItem ();
              int i = 0;
              while (item != box[i]) i++;  // should terminate !!!
              if (e.getStateChange () == ItemEvent.SELECTED) {
                config[i].write (green);
                System.out.println ("Checked ==> `" + item + "'");
                running = (item != box[box.length - 1]);
              } else {
                config[i].write (red);
                System.out.println ("Unchecked ==> `" + item + "'");
              }
            }
            root.setVisible (false);
            System.exit (0);
          }
        }
      }
    ).run ();

  }

}
