import jcsp.lang.*;
import jcsp.util.*;
import jcsp.awt.*;

public class ActiveCanvasExample2 {

  public static void main (String argv[]) {

    final ActiveClosingFrame activeClosingFrame =
      new ActiveClosingFrame ("ActiveCanvas Example");
    final ActiveFrame activeFrame = activeClosingFrame.getActiveFrame ();

    final One2OneChannel mouseEvent =
      One2OneChannel.create (new OverWriteOldestBuffer (10));
    final One2OneChannel mouseMotionEvent =
      One2OneChannel.create (new OverWriteOldestBuffer (1));
    final One2OneChannel toGraphics = new One2OneChannel ();
    final One2OneChannel fromGraphics = new One2OneChannel ();

    final ActiveCanvas activeCanvas = new ActiveCanvas ();
    activeCanvas.addMouseEventChannel (mouseEvent);
    activeCanvas.addMouseMotionEventChannel (mouseMotionEvent);
    activeCanvas.setGraphicsChannels (toGraphics, fromGraphics);
    activeCanvas.setSize (600, 400);

    activeFrame.add (activeCanvas);
    activeFrame.pack ();
    activeFrame.setVisible (true);

    new Parallel (
      new CSProcess[] {
        activeClosingFrame,
        activeCanvas,
        new Picasso (mouseEvent, mouseMotionEvent, toGraphics, fromGraphics)
      }
    ).run ();
  }

}
