import phw.util.*;
import jcsp.lang.*;

public class RandTest {

  private static void zap (int[] count) {
    for (int i = 0; i < count.length; i++ ) {
      count[i] = 0;
    }
  }

  private static void print (int[] count) {
    for (int i = 0; i < count.length; i++ ) {
      if ((i%8) == 0) System.out.println ();
      System.out.print (count[i] + "  ");
    }
    System.out.println ();
  }

  public static void main (String[] args) {
  
    final Rand random = new Rand ();
    
    final CSTimer tim = new CSTimer ();

    final int[] count = new int[128];

    System.out.println ("\nStarting range (128) ...");
    zap (count);
    int n = 1;
    for (int i = 0; i < 25; i++) {
      final long t0 = tim.read ();
      for (int j = 0; j < n; j++) {
        count[random.range (128)]++;
      }
      final long t1 = tim.read ();
      final long span = 1000000*(t1 - t0);
      final long each = span/n;
      System.out.println (" range (128) : " + n + ", " + span + ", " + each);
      n *= 2;
    }
    print (count);

    System.out.println ("\nStarting bits (7) ...");
    zap (count);
    n = 1;
    for (int i = 0; i < 25; i++) {
      final long t0 = tim.read ();
      for (int j = 0; j < n; j++) {
        count[random.bits (7)]++;
      }
      final long t1 = tim.read ();
      final long span = 1000000*(t1 - t0);
      final long each = span/n;
      System.out.println (" bits (7) : " + n + ", " + span + ", " + each);
      n *= 2;
    }
    print (count);

    System.out.println ("\nStarting bits7 () ...");
    zap (count);
    n = 1;
    for (int i = 0; i < 25; i++) {
      final long t0 = tim.read ();
      for (int j = 0; j < n; j++) {
        count[random.bits7 ()]++;
      }
      final long t1 = tim.read ();
      final long span = 1000000*(t1 - t0);
      final long each = span/n;
      System.out.println (" bits7 () : " + n + ", " + span + ", " + each);
      n *= 2;
    }
    print (count);
    
  }

}
