import jcsp.lang.*;
import jcsp.awt.*;

import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;

public class Infection implements CSProcess {

  private int infectRate;
  private int convertRate;
  private int recoverRate;
  private int reinfectRate;
  private int sprayRadius;
  
  // private final AltingChannelInput in;

  private final AltingChannelInput fromMouse;
  private final AltingChannelInput fromMouseMotion;

  private final AltingChannelInput resetEvent;
  private final ChannelOutput resetConfigure;

  private final AltingChannelInput freezeEvent;
  private final ChannelOutput freezeConfigure;

  private final AltingChannelInputInt infectRateBarEvent;
  private final ChannelOutput infectRateBarConfigure;

  private final AltingChannelInputInt convertRateBarEvent;
  private final ChannelOutput convertRateBarConfigure;
  
  private final AltingChannelInputInt recoverRateBarEvent;
  private final ChannelOutput recoverRateBarConfigure;
  
  // private final ChannelOutput feedBack;

  private final ChannelOutput infectedConfigure;
  private final ChannelOutput deadConfigure;
  
  private final ChannelOutput infectRateLabelConfigure;
  private final ChannelOutput convertRateLabelConfigure;
  private final ChannelOutput recoverRateLabelConfigure;
  
  private final ChannelOutput toGraphics;
  private final ChannelInput fromGraphics;

  public Infection (final int infectRate,
                    // final AltingChannelInput in,
                    final AltingChannelInput fromMouse,
                    final AltingChannelInput fromMouseMotion,
                    final AltingChannelInput resetEvent,
                    final ChannelOutput resetConfigure,
                    final AltingChannelInput freezeEvent,
                    final ChannelOutput freezeConfigure,
                    final AltingChannelInputInt infectRateBarEvent,
                    final ChannelOutput infectRateBarConfigure,
                    final AltingChannelInputInt convertRateBarEvent,
                    final ChannelOutput convertRateBarConfigure,
                    final AltingChannelInputInt recoverRateBarEvent,
                    final ChannelOutput recoverRateBarConfigure,
                    final ChannelOutput infectedConfigure,
                    final ChannelOutput deadConfigure,
                    final ChannelOutput infectRateLabelConfigure,
                    final ChannelOutput convertRateLabelConfigure,
                    final ChannelOutput recoverRateLabelConfigure,
                    // final ChannelOutput feedBack,
                    final ChannelOutput toGraphics,
                    final ChannelInput fromGraphics) {

    this.infectRate = infectRate;
    this.convertRate = 80;
    this.recoverRate = 99;
    this.reinfectRate = 10;
    this.sprayRadius = 20;
    // this.in = in;
    this.fromMouse = fromMouse;
    this.fromMouseMotion = fromMouseMotion;
    this.resetEvent = resetEvent;
    this.resetConfigure = resetConfigure;
    this.freezeEvent = freezeEvent;
    this.freezeConfigure = freezeConfigure;
    this.infectRateBarEvent = infectRateBarEvent;
    this.infectRateBarConfigure = infectRateBarConfigure;
    this.convertRateBarEvent = convertRateBarEvent;
    this.convertRateBarConfigure = convertRateBarConfigure;
    this.recoverRateBarEvent = recoverRateBarEvent;
    this.recoverRateBarConfigure = recoverRateBarConfigure;
    this.infectedConfigure = infectedConfigure;
    this.deadConfigure = deadConfigure;
    this.infectRateLabelConfigure = infectRateLabelConfigure;
    this.convertRateLabelConfigure = convertRateLabelConfigure;
    this.recoverRateLabelConfigure = recoverRateLabelConfigure;
    // this.feedBack = feedBack;
    this.toGraphics = toGraphics;
    this.fromGraphics = fromGraphics;
  }

  //     colours          :   Cell.GREEN    Cell.INFECTED    Cell.DEAD
  //     -------              ----------    -------------    ---------
  
  private final byte[] reds   = { (byte)0x00,    (byte)0xff,    (byte)0x00};
  private final byte[] greens = { (byte)0xff,    (byte)0x00,    (byte)0x00};
  private final byte[] blues  = { (byte)0x00,    (byte)0x00,    (byte)0xff};

  //     pixel array and key run-time parameters
  //     ---------------------------------------

  private byte[] pixels;                     // pixel array of Cell matrix

  private byte[][] cell, last_cell;          // matrix of Cells (plus spare)

  // Note: we will maintain in last_cell the previous state of the Cells.

  private int width, height;

  private int[] count = new int[Cell.N_STATES];  // how many in each state

  private final static int IDLE = 0, RUNNING = 2, FROZEN = 3, RESET = 4;

  //  IDLE     <==>  "reset"  "FREEZE"    all green           not running
  //  RUNNING  <==>  "reset"  "FREEZE"    some infected/dead  running
  //  FROZEN   <==>  "RESET"  "UNFREEZE"  some infected/dead  not running
  //  RESET    <==>  "reset"  "UNFREEZE"  all green           not running
    
  private int state = IDLE;

  private final static int RESET_EVENT = 0, FREEZE_EVENT = 1;
  private final static int INFECT_RATE = 2, CONVERT_RATE = 3, RECOVER_RATE = 4;
  private final static int MOUSE = 5, MOUSE_MOTION = 6, SKIP = 7;

  private Guard[] guard;
                           
  private boolean[] preCondition;
  
  private Spray spray;

  //     private methods
  //     -----------------

  private ColorModel createColorModel () {
    return new IndexColorModel (2, 3, reds, greens, blues);
  }

  private final Rand random = new Rand ();

  private void initialisePixels () {
    for (int ij = 0; ij < pixels.length; ij++) {
      pixels[ij] = Cell.GREEN;
    }
    for (int j = 0; j < height; j++) {
      for (int i = 0; i < width; i++) {
        cell[j][i] = Cell.GREEN;
      }
    }
    count[Cell.GREEN] = height*width;
    count[Cell.INFECTED] = 0;
    count[Cell.DEAD] = 0;
    infectedConfigure.write ((new Integer (count[Cell.INFECTED])).toString ());
    deadConfigure.write ((new Integer (count[Cell.DEAD])).toString ());
  }

  private void pixelise () {
    int i0 = 0;
    for (int i = 0; i < cell.length; i++) {
      System.arraycopy (cell[i], 0, pixels, i0, width);
      i0 = i0 + width;
    }
  }

  private void byteMatrixCopy (final byte[][] from, final byte[][] to) {
    // assume: from and to are equally sized ...
    for (int i = 0; i < from.length; i++) {
      System.arraycopy (from[i], 0, to[i], 0, from[i].length);  // fast copy
    }
  }

  private void infect (int i, int j) {     // possibly infect Cell[i][j]
    i = (i < 0) ? i + height : (i >= height) ? i - height : i;
    j = (j < 0) ? j + width : (j >= width) ? j - width : j;
    if (last_cell[i][j] == Cell.GREEN) {
      if (random.bits7 () < infectRate) {
        count[cell[i][j]]--;
        cell[i][j] = Cell.INFECTED;
        count[Cell.INFECTED]++;
      }
    }
  }

  private void evolve () {                       // evolves the forest forward
    byteMatrixCopy (cell, last_cell);            // forward one cycle
    for (int i = 0; i < height; i++) {
      final byte[] last_row_i = last_cell[i];
      final byte[] row_i = cell[i];
      for (int j = 0; j < width; j++) {
        switch (last_row_i[j]) {
          // case Cell.GREEN:
          // break;
          case Cell.INFECTED:
            infect (i + 1, j);
            infect (i - 1, j);
            infect (i, j + 1);
            infect (i, j - 1);
            if ((i % 2) == 0) {
              infect (i + 1, j + 1);
              infect (i - 1, j - 1);
            } else {
              infect (i - 1, j + 1);
              infect (i + 1, j - 1);
            }
            if (random.bits7 () < convertRate) {
              row_i[j] = Cell.DEAD;
              count[Cell.INFECTED]--;
              count[Cell.DEAD]++;
            }
          break;
          case Cell.DEAD:
            if (random.bits7 () < recoverRate) {
              if (random.bits16 () < reinfectRate) {
                row_i[j] = Cell.INFECTED;
                count[Cell.DEAD]--;
                count[Cell.INFECTED]++;
              } else {
                row_i[j] = Cell.GREEN;
                count[Cell.DEAD]--;
                count[Cell.GREEN]++;
              }
            }
          break;
        }
      }
    }
  }

/*
  // report sets results to the number of GREEN, INFECTED and DEAD cells
  // (respectively) in the forest.  It assumes results has a length of 3.
  //
  // Not used any more -- since these counts are maintained automatically.

  private void report (final int[] results) {
    results[Cell.GREEN] = 0;
    results[Cell.INFECTED] = 0;
    results[Cell.DEAD] = 0;
    for (int i = 0; i < height; i++) {
      final byte[] row_i = cell[i];
      for (int j = 0; j < width; j++) {
        results[row_i[j]]++;
      }
    }
  }
*/

  private void handle (final Point point, final byte newCellState,
                       final boolean spraying) {
    if (spraying) {
      System.out.println ("Spraying ..." + point);
      spray.zap (point, newCellState);
    } else {
      System.out.print ("Spotting ..." + point + " ... (");
      int i = point.y;
      int j = point.x;
      while (i < 0) i += height;            // mostly won't happen or
      while (i >= height) i -= height;      // will happen only once.
      while (j < 0) j += width;             //         ditto.
      while (j >= width) j -= width;        //         ditto.
      System.out.println (j + ", " + i + ")");
      // if ((0 <= i) && (i < height) && (0 <= j) && (j < width)) {
      byte[] cellRow = cell[i];
      final byte current = cellRow[j];
      if (current != Cell.INFECTED){
        pixels[(i*width) + j] = newCellState;
        count[current]--;
        cellRow[j] = newCellState;
        count[newCellState]++;
      }
      // }
    }
    final int notGreen = count[Cell.INFECTED] + count[Cell.DEAD];
    infectedConfigure.write ((new Integer (count[Cell.INFECTED])).toString ());
    deadConfigure.write ((new Integer (count[Cell.DEAD])).toString ());
    switch (state) {
      case IDLE:
        if (notGreen > 0) {
          preCondition[SKIP] = true;
          state = RUNNING;
        }
      break;
      case RUNNING:
        if (notGreen == 0) {
          preCondition[SKIP] = false;
          state = IDLE;
        }
      break;
      case FROZEN:
        if (notGreen == 0) {
          resetConfigure.write (Boolean.FALSE);
          resetConfigure.write ("reset");
          preCondition[RESET_EVENT] = false;
          state = RESET;
        }
      break;
      case RESET:
        if (notGreen > 0) {
          while (resetEvent.pending ()) resetEvent.read ();
          resetConfigure.write (Boolean.TRUE);
          resetConfigure.write ("RESET");
          preCondition[RESET_EVENT] = true;
          state = FROZEN;
        }
      break;
    }
  }

  public void run () {

    infectedConfigure.write ("0");
    deadConfigure.write ("0");
    
    infectRateLabelConfigure.write ((new Integer (infectRate)).toString ());
    convertRateLabelConfigure.write ((new Integer (convertRate)).toString ());
    recoverRateLabelConfigure.write ((new Integer (recoverRate)).toString ());
    
    infectRate = ((infectRate*128) + 64)/100;
    convertRate = ((convertRate*128) + 64)/100;
    recoverRate = ((recoverRate*128) + 64)/100;
    
    convertRate = 128 - convertRate;
    recoverRate = 128 - recoverRate;
    
    resetConfigure.write (Boolean.FALSE);
    resetConfigure.write ("reset");
    
    freezeConfigure.write (Boolean.TRUE);
    freezeConfigure.write ("FREEZE");
    
    infectRateBarConfigure.write (Boolean.TRUE);
    convertRateBarConfigure.write (Boolean.TRUE);
    recoverRateBarConfigure.write (Boolean.TRUE);

    toGraphics.write (GraphicsProtocol.GET_DIMENSION);
    final Dimension graphicsDim = (Dimension) fromGraphics.read ();
    System.out.println ("Infection: graphics dimension = " + graphicsDim);

    width = graphicsDim.width;
    height = graphicsDim.height;

    pixels = new byte[width*height];

    cell = new byte[height][width];
    last_cell = new byte[height][width];

    final ColorModel model = createColorModel ();

    final MemoryImageSource mis =
      new MemoryImageSource (width, height, model, pixels, 0, width);
    mis.setAnimated (true);
    mis.setFullBufferUpdates (true);

    toGraphics.write (new GraphicsProtocol.MakeMISImage (mis));
    final Image image = (Image) fromGraphics.read ();

    final DisplayList display = new DisplayList ();
    toGraphics.write (new GraphicsProtocol.SetPaintable (display));
    fromGraphics.read ();

    final GraphicsCommand[] drawImage = {new GraphicsCommand.DrawImage (image, 0, 0)};
    display.set (drawImage);

    final Thread me = Thread.currentThread ();
    System.out.println ("Infection priority = " + me.getPriority ());
    me.setPriority (Thread.MIN_PRIORITY);
    System.out.println ("Infection priority = " + me.getPriority ());

    // final int RESET_EVENT = 0, FREEZE_EVENT = 1;
    // final int INFECT_RATE = 2, CONVERT_RATE = 3, RECOVER_RATE = 4;
    // final int MOUSE = 5, MOUSE_MOTION = 6, SKIP = 7;

    guard = new Guard[] {resetEvent, freezeEvent,
                         infectRateBarEvent, convertRateBarEvent,
                         recoverRateBarEvent, fromMouse, fromMouseMotion, new Skip ()};
                           
    preCondition = new boolean[] {false, true, true, true, true, true, false, false};

    boolean spraying = false;
    boolean controlled = false;
    boolean mousePressed = false;
    byte newCellState = Cell.GREEN;

    spray = new Spray (sprayRadius, cell, pixels, count);

    final Alternative alt = new Alternative (guard);

    initialisePixels ();
    mis.newPixels ();

    while (true) {
      switch (alt.fairSelect (preCondition)) {
        case RESET_EVENT:
System.out.println ("Infection: reset event ...");
          resetEvent.read ();
          // assert : state == FROZEN
          resetConfigure.write (Boolean.FALSE);
          resetConfigure.write ("reset");
          preCondition[RESET_EVENT] = false;
          state = RESET;
System.out.println ("Infection: reset");
          initialisePixels ();
          mis.newPixels ();
        break;
        case FREEZE_EVENT:
          freezeEvent.read ();
          switch (state) {
            case IDLE:
System.out.println ("Infection: freeze");
              freezeConfigure.write ("UNFREEZE");
              state = RESET;
            break;
            case RUNNING:
System.out.println ("Infection: freeze");
              freezeConfigure.write ("UNFREEZE");
              while (resetEvent.pending ()) resetEvent.read ();
              resetConfigure.write (Boolean.TRUE);
              resetConfigure.write ("RESET");
              preCondition[RESET_EVENT] = true;
              preCondition[SKIP] = false;
              state = FROZEN;
            break;
            case FROZEN:
System.out.println ("Infection: unfreeze");
              freezeConfigure.write ("FREEZE");
              resetConfigure.write (Boolean.FALSE);
              resetConfigure.write ("reset");
              preCondition[RESET_EVENT] = false;
              preCondition[SKIP] = true;
              state = RUNNING;
            break;
            case RESET:
System.out.println ("Infection: unfreeze");
              freezeConfigure.write ("FREEZE");
              state = IDLE;
            break;
          }
        break;
        case INFECT_RATE:
          infectRate = 100 - infectRateBarEvent.read ();
          infectRateLabelConfigure.write ((new Integer (infectRate)).toString ());
// System.out.print ("Infection: infectRate ... " + infectRate);
          infectRate = ((infectRate*128) + 64)/100;
// System.out.println (" ... " + infectRate);
        break;
        case CONVERT_RATE:
          convertRate = 100 - convertRateBarEvent.read ();
          convertRateLabelConfigure.write ((new Integer (convertRate)).toString ());
// System.out.print ("Infection: stayInfectiousRate ... " + convertRate);
          convertRate = ((convertRate*128) + 64)/100;
// System.out.println (" ... " + convertRate);
          convertRate = 128 - convertRate;
        break;
        case RECOVER_RATE:
          recoverRate = 100 - recoverRateBarEvent.read ();
          recoverRateLabelConfigure.write ((new Integer (recoverRate)).toString ());
// System.out.print ("Infection: stayImmuneRate ... " + recoverRate);
          recoverRate = ((recoverRate*128) + 64)/100;
// System.out.println (" ... " + recoverRate);
          recoverRate = 128 - recoverRate;
        break;
        case MOUSE:
          final MouseEvent event = (MouseEvent) fromMouse.read ();
          switch (event.getID ()) {
            case MouseEvent.MOUSE_PRESSED:
              if (controlled) {
                controlled = false;
                preCondition[MOUSE_MOTION] = false;
                if (spraying) {
                  spray.setMask ();
                  spraying = false;
                }
              } else {
                mousePressed = true;
                while (fromMouseMotion.pending ()) fromMouseMotion.read ();
                preCondition[MOUSE_MOTION] = true;
                int modifiers = event.getModifiers ();
                if ((modifiers & InputEvent.BUTTON1_MASK) != 0) {
                  newCellState = Cell.INFECTED;
                } else if ((modifiers & InputEvent.BUTTON2_MASK) != 0) {
                  newCellState = Cell.GREEN;
                } else {
                  newCellState = Cell.DEAD;
                }
// System.out.println ("MOUSE_PRESSED modifiers = " + modifiers);
// System.out.println ("SHIFT_MASK = " + InputEvent.SHIFT_MASK);
// System.out.println ("CTRL_MASK = " + InputEvent.CTRL_MASK);
// System.out.println ("META_MASK = " + InputEvent.META_MASK);
// System.out.println ("ALT_MASK = " + InputEvent.ALT_MASK);
// System.out.println ("BUTTON1_MASK = " + InputEvent.BUTTON1_MASK);
// System.out.println ("BUTTON2_MASK = " + InputEvent.BUTTON2_MASK);
// System.out.println ("BUTTON3_MASK = " + InputEvent.BUTTON3_MASK);
                spraying = ((modifiers & InputEvent.SHIFT_MASK) != 0);
                if (newCellState != Cell.GREEN) {  // CTRL_MASK doesn't work on BUTTON2 (JDK1.1/2/3)
                  controlled = ((modifiers & InputEvent.CTRL_MASK) != 0);
                }
                handle (event.getPoint (), newCellState, spraying);
                mis.newPixels ();
              }
            break;
            case MouseEvent.MOUSE_RELEASED:
              mousePressed = false;
              if (! controlled) {
                preCondition[MOUSE_MOTION] = false;
                if (spraying) {
                  spray.setMask ();
                  spraying = false;
                }
              }
            break;
          }
        break;
        case MOUSE_MOTION:
          final MouseEvent motion = (MouseEvent) fromMouseMotion.read ();
          switch (motion.getID ()) {
            case MouseEvent.MOUSE_MOVED:
              if (controlled) {
                handle (motion.getPoint (), newCellState, spraying);
                mis.newPixels ();
              }
            case MouseEvent.MOUSE_DRAGGED:
              if (mousePressed) {
                handle (motion.getPoint (), newCellState, spraying);
                mis.newPixels ();
              }
            break;
          }
        break;
        case SKIP:
          // assert : state == RUNNING
          evolve ();
          pixelise ();
          mis.newPixels ();
          final int notGreen = count[Cell.INFECTED] + count[Cell.DEAD];
          infectedConfigure.write ((new Integer (count[Cell.INFECTED])).toString ());
          deadConfigure.write ((new Integer (count[Cell.DEAD])).toString ());
          if (notGreen == 0) {
// System.out.println ("Infection: all healthy !!!");
            preCondition[SKIP] = false;
            state = IDLE;
          }
        break;
      }  
    }

  }

}
