import jcsp.lang.*;
import jcsp.util.*;
import jcsp.util.ints.*;
import jcsp.awt.*;

import java.awt.*;
import java.awt.image.*;

class InfectNetwork implements CSProcess {

  private final ActiveCanvas activeCanvas;
  private final ActiveScrollbar infectRateBar;
  private final ActiveScrollbar convertRateBar;
  private final ActiveScrollbar recoverRateBar;
  // private final ActiveButton[] button;
  // private final PseudoButton pseudoButton;
  private final ActiveButton resetButton;
  private final ActiveButton freezeButton;
  private final ActiveLabel infectedLabel;
  private final ActiveLabel deadLabel;
  private final ActiveLabel infectRateLabel;
  private final ActiveLabel convertRateLabel;
  private final ActiveLabel recoverRateLabel;
  // private final InfectionControl control;
  private final Infection infection;

  public InfectNetwork (final int rate, final Container parent) {

    parent.setLayout (new BorderLayout ());
    parent.setBackground (Color.blue);

    System.out.println ("Infect creating channels ...");
    
    // final One2OneChannel[] event =
    //   One2OneChannel.create (InfectionControl.NUMBER + 1,
    //                          new OverWriteOldestBuffer (1));
    // final One2OneChannel[] configure =
    //   One2OneChannel.create (InfectionControl.NUMBER + 1);

    final One2OneChannel resetEvent =
      One2OneChannel.create (new OverWriteOldestBuffer (1));
    final One2OneChannel resetConfigure = new One2OneChannel ();
    
    final One2OneChannel freezeEvent =
      One2OneChannel.create (new OverWriteOldestBuffer (1));
    final One2OneChannel freezeConfigure = new One2OneChannel ();

    final One2OneChannelInt infectRateBarEvent =
      One2OneChannelInt.create (new OverWriteOldestBufferInt (1));
    final One2OneChannel infectRateBarConfigure = new One2OneChannel ();

    final One2OneChannelInt convertRateBarEvent =
      One2OneChannelInt.create (new OverWriteOldestBufferInt (1));
    final One2OneChannel convertRateBarConfigure = new One2OneChannel ();

    final One2OneChannelInt recoverRateBarEvent =
      One2OneChannelInt.create (new OverWriteOldestBufferInt (1));
    final One2OneChannel recoverRateBarConfigure = new One2OneChannel ();

    // final One2OneChannel report = new One2OneChannel ();
    // final One2OneChannel generate = new One2OneChannel ();

    final One2OneChannel toGraphics = new One2OneChannel ();
    final One2OneChannel fromGraphics = new One2OneChannel ();

    // final One2OneChannel feedBack = new One2OneChannel ();

    final One2OneChannel infectedConfigure = new One2OneChannel ();
    final One2OneChannel deadConfigure = new One2OneChannel ();
    final One2OneChannel infectRateLabelConfigure = new One2OneChannel ();
    final One2OneChannel convertRateLabelConfigure = new One2OneChannel ();
    final One2OneChannel recoverRateLabelConfigure = new One2OneChannel ();
    
    final One2OneChannel fromMouse = One2OneChannel.create (new OverWriteOldestBuffer (9));
    final One2OneChannel fromMouseMotion = One2OneChannel.create (new OverWriteOldestBuffer (9));

    System.out.println ("InfectNetwork created channels");
    System.out.println ("InfectNetwork creating ActiveButtons ...");

    // button = new ActiveButton[InfectionControl.NUMBER];
    // for (int i = 0; i < InfectionControl.NUMBER; i++) {
    //   button[i]
    //     = new ActiveButton (configure[i], event[i], "XXXXXXXXXXXXX");
    //   button[i].setBackground (Color.white);
    //   System.out.println ("  button " + i);
    // }

    resetButton = new ActiveButton (resetConfigure, resetEvent, "XXXXXXXXXXXXX");
    resetButton.setBackground (Color.white);
    
    freezeButton = new ActiveButton (freezeConfigure, freezeEvent, "XXXXXXXXXXXXX");
    freezeButton.setBackground (Color.white);

    infectedLabel = new ActiveLabel (infectedConfigure, "XXXXXXXXXXXXX");
    infectedLabel.setAlignment (Label.CENTER);
    infectedLabel.setBackground (Color.white);

    deadLabel = new ActiveLabel (deadConfigure, "XXXXXXXXXXXXX");
    deadLabel.setAlignment (Label.CENTER);
    deadLabel.setBackground (Color.white);

    infectRateLabel = new ActiveLabel (infectRateLabelConfigure, "XXXXXXXXXXXXX");
    infectRateLabel.setAlignment (Label.CENTER);
    infectRateLabel.setBackground (Color.white);

    convertRateLabel = new ActiveLabel (convertRateLabelConfigure, "XXXXXXXXXXXXX");
    convertRateLabel.setAlignment (Label.CENTER);
    convertRateLabel.setBackground (Color.white);

    recoverRateLabel = new ActiveLabel (recoverRateLabelConfigure, "XXXXXXXXXXXXX");
    recoverRateLabel.setAlignment (Label.CENTER);
    recoverRateLabel.setBackground (Color.white);

    System.out.println ("InfectNetwork created ActiveButtons ... now adding them to the parent ...");
    
    final Panel north = new Panel ();
    final Panel south = new Panel ();

    // north.add (button[InfectionControl.RESET]);
    north.add (resetButton);
    north.add (infectedLabel);
    north.add (deadLabel);
    // north.add (button[InfectionControl.FREEZE]);
    north.add (freezeButton);
    // south.add (button[InfectionControl.RANDOM]);
    south.add (infectRateLabel);
    south.add (convertRateLabel);
    south.add (recoverRateLabel);
    // south.add (button[InfectionControl.CENTRE]);

    parent.add ("North", north);
    parent.add ("South", south);

    System.out.println ("InfectNetwork creating ActiveScrollbars ...");

    infectRateBar = new ActiveScrollbar (infectRateBarConfigure, infectRateBarEvent,
                                         Scrollbar.VERTICAL, 100 - rate, 25, 0, 125);
    infectRateBar.setBackground (Color.white);

    convertRateBar = new ActiveScrollbar (convertRateBarConfigure, convertRateBarEvent,
                                         Scrollbar.VERTICAL, 100 - 80, 25, 0, 125);
    convertRateBar.setBackground (Color.white);

    recoverRateBar = new ActiveScrollbar (recoverRateBarConfigure, recoverRateBarEvent,
                                         Scrollbar.VERTICAL, 100 - 99, 25, 0, 125);
    recoverRateBar.setBackground (Color.white);

    System.out.println ("InfectNetwork created ActiveScrollbars ... now adding it to the parent ...");

    parent.add ("West", infectRateBar);

    final Panel east = new Panel ();
    east.setLayout (new GridLayout (2, 1));
    east.add (convertRateBar);
    east.add (recoverRateBar);
    parent.add ("East", east);

    System.out.println ("InfectNetwork now creating ActiveCanvas ...");
    activeCanvas = new ActiveCanvas ();
    activeCanvas.addMouseEventChannel (fromMouse);
    activeCanvas.addMouseMotionEventChannel (fromMouseMotion);
    activeCanvas.setGraphicsChannels (toGraphics, fromGraphics);
    activeCanvas.setSize (parent.getSize ());

    // If the parent is an applet, the above setSize has no effect and the activeCanvas
    // is fitted to the "Center" area (see below) of the applet's panel.

    // If the parent is a frame, the above *does* define the size of the activeCanvas
    // and the size of the parent is expanded to wrap around when it is packed.

    System.out.println ("InfectNetwork adding ActiveCanvas to the parent ...");
    parent.add ("Center", activeCanvas);

    // System.out.println ("InfectNetwork creating infectionControl ...");
    // control = new InfectionControl (event, configure, report);

    System.out.println ("InfectNetwork now creating infection ...");
    infection = new Infection (rate, fromMouse, fromMouseMotion,
                               resetEvent, resetConfigure,
                               freezeEvent, freezeConfigure,
                               infectRateBarEvent, infectRateBarConfigure,
                               convertRateBarEvent, convertRateBarConfigure,
                               recoverRateBarEvent, recoverRateBarConfigure,
                               infectedConfigure, deadConfigure,
                               infectRateLabelConfigure, convertRateLabelConfigure,
                               recoverRateLabelConfigure,
                               toGraphics, fromGraphics);

    // System.out.println ("InfectNetwork creating pseudo button ...");
    // 
    // pseudoButton = new PseudoButton (configure[InfectionControl.NUMBER],
    //                                  event[InfectionControl.NUMBER],
    //                                  feedBack);

  }

  public void run () {

    System.out.println ("Infect starting up the network ...");

    new Parallel (
      new CSProcess[] {
        activeCanvas,
        resetButton,
        freezeButton,
        infectRateBar,
        convertRateBar,
        recoverRateBar,
        // pseudoButton,
        infectedLabel,
        deadLabel,
        infectRateLabel,
        convertRateLabel,
        recoverRateLabel,
        // control,
        infection
        // new Parallel (button)
      }
    ).run ();

  }

}
