import jcsp.lang.*;

public final class TrapNegative implements CSProcess {

  private final ChannelInputInt in;
  private final ChannelOutputInt out;
  private final ChannelOutputInt trap;

  public TrapNegative (final ChannelInputInt in, final ChannelOutputInt out,
                       final ChannelOutputInt trap) {
    this.in = in;
    this.out = out;
    this.trap = trap;
  }

  public void run () {
    int count = 0;
    int i = in.read ();
    while (i >= 0) {
      count++;
      out.write (i);
      i = in.read ();
    }
    trap.write (count);
  }

}
