import jcsp.lang.*;
import jcsp.util.ints.*;
import jcsp.plugNplay.ints.*;

public final class PrimeMultiples2 implements CSProcess {

  private final ChannelOutputInt trap;

  private final int[] primes;
  private final int minPrimes = 2;

  private final int howMany;

  public PrimeMultiples2 (final int[] primes, final int howMany,
                          final ChannelOutputInt trap) {
    // assume these are distinct primes (and at least minPrimes of them)
    this.primes = primes;
    if (howMany < minPrimes) {
      this.howMany = minPrimes;
    } else if (howMany > primes.length) {
      this.howMany = primes.length;
    } else {
      this.howMany = howMany;
    }
    this.trap = trap;
  }

  public void run () {

    final One2OneChannelInt[] a = One2OneChannelInt.create (howMany + 1);
    final One2OneChannelInt[] b = One2OneChannelInt.create (howMany,
                                    new InfiniteBufferInt ());
    final One2OneChannelInt c = new One2OneChannelInt ();
    final One2OneChannelInt d = new One2OneChannelInt ();
    final One2OneChannelInt e = new One2OneChannelInt ();

    final CSProcess[] Multipliers = new CSProcess[howMany];
    for (int i = 0; i < howMany; i++) {
      Multipliers[i] = new MultInt (primes[i], a[i], b[i]);
    }

    new Parallel (
      new CSProcess[] {
        new Parallel (Multipliers),
        new MergeInt (b, c),
        new PrefixInt (1, c, d),
        new DeltaInt (d, a),
        new TrapNegative (a[howMany], e, trap),
        new PrinterInt (e, "", " ")
      }
    ).run ();
  }
}
