import jcsp.lang.*;

public final class Hamming2 {

  public static void main (String[] args) {

    final CSTimer tim = new CSTimer ();

    final One2OneChannelInt trap = new One2OneChannelInt ();
    
    final int[] primes = {2, 3, 5, 7, 11, 13, 17, 19, 23, 29};
    final int n = primes.length;

    while (true) {

      for (int i = 2; i <= primes.length; i++)  {

        System.out.println ("\nAll positive ints whose prime factors contain only:\n");
        System.out.print ("  " + primes[0]);
        for (int j = 1; j < i; j++)  {
          System.out.print (", ");
          System.out.print (primes[j]);
        }
        System.out.println ("\n");

        final ProcessManager manager =
          new ProcessManager (new PrimeMultiples2 (primes, i, trap));

        manager.start ();                // start up the managed process

        for (int p = 0; p <= 2; p++)  {
          long t = tim.read ();
          tim.after (t + 2000);
          synchronized (System.out) {
            manager.suspend ();          // suspend up the managed process
          }
          System.out.print ("\n\nsuspending for 2 seconds [" + p + "/2] ...");
          t = tim.read ();
          tim.after (t + 2000);
          manager.resume ();             // resume up the managed process
        }

        final int count = trap.read ();  // wait for hamming numbers to overflow

        manager.stop ();                 // stop the managed process

        System.out.println ("\n\nThere were " + count + " of them ...");

      }
    }

  }

}
