import jcsp.lang.*;
import jcsp.awt.*;
import java.awt.*;

import phw.util.Ask;

/**
 * This example is loosely based on
 * A HREF="http://www.comp.lancs.ac.uk/computing/users/rgg/miscellaneous/Programming.html">
 * Jeffrey Hider's Geoapplet</A>
 * by <A HREF="mailto:jlhider@geocities.com">Jeffrey L. Hider</A>.
 * This JCSP demonstration is by <A HREF="mailto:P.H.Welch@ukc.ac.uk">Peter Welch</A>.
 */

public class FireworksMain extends ActiveApplet {

  public static final int minWidth = 300;
  public static final int maxWidth = 1024;

  public static final int maxHeight = 1024;
  public static final int minHeight = 100;

  public static final int minMaxParticles = 1000;
  public static final int maxMaxParticles = 50000;
  public static final int defaultMaxParticles = 15000;

  public static final int minStillCount = 10;
  public static final int maxStillCount = 1000;
  public static final int defaultStillCount = 100;

  public static final int minDragCount = 10;
  public static final int maxDragCount = 1000;
  public static final int defaultDragCount = 100;

  public static final int minSpeed = 1;
  public static final int maxSpeed = 100;
  public static final int defaultSpeed = 35;

  public static final int minScale = 0;
  public static final int maxScale = 10;
  public static final int defaultScale = 6;

  public static final int minMaxDeltaY = 1;
  public static final int maxMaxDeltaY = 10000;
  public static final int defaultMaxDeltaY = 10000;

  public static final int minLaunchDeltaX = 1;
  public static final int maxLaunchDeltaX = 10000;
  public static final int defaultLaunchDeltaX = 1200;

  public static final int minLaunchDeltaY = 1;
  public static final int maxLaunchDeltaY = 10000;
  public static final int defaultLaunchDeltaY = 1200;

  public static final int minAccY = 1;
  public static final int maxAccY = 1000;
  public static final int defaultAccY = 256;

  public void init () {
    final int maxParticles = getAppletInt ("maxParticles", minMaxParticles, maxMaxParticles, defaultMaxParticles);
    final int stillCount = getAppletInt ("stillCount", minStillCount, maxStillCount, defaultStillCount);
    final int dragCount = getAppletInt ("dragCount", minDragCount, maxDragCount, defaultDragCount);
    final int speed = getAppletInt ("speed", minSpeed, maxSpeed, defaultSpeed);
    final int accY = getAppletInt ("accY", minAccY, maxAccY, defaultAccY);
    final int maxDeltaY = getAppletInt ("maxDeltaY", minMaxDeltaY, maxMaxDeltaY, defaultMaxDeltaY);
    final int launchDeltaX = getAppletInt ("launchDeltaX", minLaunchDeltaX, maxLaunchDeltaX, defaultLaunchDeltaX);
    final int launchDeltaY = getAppletInt ("launchDeltaY", minLaunchDeltaY, maxLaunchDeltaY, defaultLaunchDeltaY);
    final int scale = getAppletInt ("scale", minScale, maxScale, defaultScale);
    setProcess (
      new FireNetwork (
        maxParticles, stillCount, dragCount, speed, accY,
        maxDeltaY, launchDeltaX, launchDeltaY, scale, this
      )
    );
  }

  public static void main (String[] args) {
  
    System.out.println ("\nFireworks starting ...\n");

    final int width = Ask.Int ("width = ", minWidth, maxWidth);
    final int height = Ask.Int ("height = ", minHeight, maxHeight);
    System.out.println ();

/*
    final int maxParticles = Ask.Int ("maxParticles = ", minMaxParticles, maxMaxParticles);
    final int stillCount = Ask.Int ("stillCount = ", minStillCount, maxStillCount);
    final int dragCount = Ask.Int ("dragCount = ", minDragCount, maxDragCount);
    final int speed = Ask.Int ("speed (frames per second) = ", minSpeed, maxSpeed);
    final int accY = Ask.Int ("accY = ", minAccY, maxAccY);
    final int maxDeltaY = Ask.Int ("maxDeltaY = ", minMaxDeltaY, maxMaxDeltaY);
    final int launchDeltaX = Ask.Int ("launchDeltaX = ", minLaunchDeltaX, maxLaunchDeltaX);
    final int launchDeltaY = Ask.Int ("launchDeltaY = ", minLaunchDeltaY, maxLaunchDeltaY);
    final int scale = Ask.Int ("scale = ", minScale, maxScale);
    System.out.println ();
*/

    final int maxParticles = defaultMaxParticles;
    final int stillCount = defaultStillCount;
    final int dragCount = defaultDragCount;
    final int speed = defaultSpeed;
    final int accY = defaultAccY;
    final int maxDeltaY = defaultMaxDeltaY;
    final int launchDeltaX = defaultLaunchDeltaX;
    final int launchDeltaY = defaultLaunchDeltaY;
    final int scale = defaultScale;
    System.out.println ("maxParticles = " + maxParticles);
    System.out.println ("stillCount = " + stillCount);
    System.out.println ("dragCount = " + dragCount);
    System.out.println ("speed = " + speed);
    System.out.println ("accY = " + accY);
    System.out.println ("maxDeltaY = " + maxDeltaY);
    System.out.println ("launchDeltaX = " + launchDeltaX);
    System.out.println ("launchDeltaY = " + launchDeltaY);
    System.out.println ("scale = " + scale);
    System.out.println ();

    final ActiveClosingFrame activeClosingframe = new ActiveClosingFrame ("Fireworks");
    final ActiveFrame activeFrame = activeClosingframe.getActiveFrame ();
    activeFrame.setSize (width, height);

    final FireNetwork fireNetwork =
      new FireNetwork (
        maxParticles, stillCount, dragCount, speed, accY,
        maxDeltaY, launchDeltaX, launchDeltaY, scale, activeFrame
      );

    activeFrame.pack ();
    activeFrame.setLocation ((maxWidth - width)/2, (maxHeight - height)/2);
    activeFrame.setVisible (true);
    activeFrame.toFront ();

    new Parallel (
      new CSProcess[] {
        activeClosingframe,
        fireNetwork
      }
    ).run ();

  }

}
