import jcsp.lang.*;
import jcsp.plugNplay.ints.*;

class Sieve2 implements CSProcess {

  //{{{ private countdown, in, out
  private final int countdown;
  private final ChannelInputInt in;
  private final ChannelOutputInt out;
  //}}} 
  
  //{{{ public Sieve2
  public Sieve2 (final int countdown,
                 final ChannelInputInt in,
                 final ChannelOutputInt out) {
    this.countdown = countdown;
    this.in = in;
    this.out = out;
  }
  //}}} 
  
  //{{{ public void run
  public void run () {
    if (countdown == 0) {
      new IdentityInt (in, out).run ();
    } else {
      int n = in.read ();
      out.write (n);
      One2OneChannelInt c = new One2OneChannelInt ();
      new Parallel (
        new CSProcess[] {
          new NoMultiples (n, in, c),
          new Sieve2 (countdown - 1, c, out)
        }
      ).run ();
    }
  }
  //}}} 

}
